/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.model.block;

import epicsquid.mysticallib.model.CustomModelBase;
import epicsquid.mysticallib.model.ModelUtil;
import epicsquid.mysticallib.model.block.BakedModelBlock;
import epicsquid.mysticallib.model.parts.Cube;
import epicsquid.mysticallib.struct.Vec4f;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockWall;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;

public class BakedModelFence
extends BakedModelBlock {
    private Cube post_right;
    private Cube post_left;
    private Cube west;
    private Cube west_top;
    private Cube north;
    private Cube north_top;
    private Cube south;
    private Cube south_top;
    private Cube east;
    private Cube east_top;
    private Cube post;

    public BakedModelFence(@Nonnull IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, @Nonnull CustomModelBase model) {
        super(format, bakedTextureGetter, model);
        TextureAtlasSprite[] texes = new TextureAtlasSprite[]{this.texwest, this.texeast, this.texdown, this.texup, this.texnorth, this.texsouth};
        this.post_right = this.makePostCube(format, 0.0, 0.0, 0.375, 0.25, 1.0, 0.25, null, texes, 0);
        this.post_left = this.makePostCube(format, 0.75, 0.0, 0.375, 0.25, 1.0, 0.25, null, texes, 0);
        this.north = ModelUtil.makeCube(format, 0.4375, 0.375, 0.0, 0.125, 0.1875, 0.5, null, texes, 0);
        this.south = ModelUtil.makeCube(format, 0.4375, 0.375, 0.5, 0.125, 0.1875, 0.5, null, texes, 0);
        this.west = ModelUtil.makeCube(format, 0.0, 0.375, 0.4375, 0.5, 0.1875, 0.125, null, texes, 0);
        this.east = ModelUtil.makeCube(format, 0.5, 0.375, 0.4375, 0.5, 0.1875, 0.125, null, texes, 0);
        this.north_top = ModelUtil.makeCube(format, 0.4375, 0.75, 0.0, 0.125, 0.1875, 0.5, null, texes, 0);
        this.south_top = ModelUtil.makeCube(format, 0.4375, 0.75, 0.5, 0.125, 0.1875, 0.5, null, texes, 0);
        this.west_top = ModelUtil.makeCube(format, 0.0, 0.75, 0.4375, 0.5, 0.1875, 0.125, null, texes, 0);
        this.east_top = ModelUtil.makeCube(format, 0.5, 0.75, 0.4375, 0.5, 0.1875, 0.125, null, texes, 0);
        this.post = this.makePostCube(format, 0.375, 0.0, 0.375, 0.25, 1.0, 0.25, null, texes, 0);
    }

    @Override
    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        this.getFaceQuads(quads, side, state);
        return quads;
    }

    private void getFaceQuads(@Nonnull List<BakedQuad> quads, @Nullable EnumFacing side, @Nullable IBlockState state) {
        if (state == null) {
            this.post_left.addToList(quads, side);
            this.post_right.addToList(quads, side);
            this.west.addToList(quads, side);
            this.west_top.addToList(quads, side);
        } else {
            boolean cnorth = (Boolean)state.func_177229_b((IProperty)BlockWall.field_176254_b);
            boolean csouth = (Boolean)state.func_177229_b((IProperty)BlockWall.field_176258_N);
            boolean cwest = (Boolean)state.func_177229_b((IProperty)BlockWall.field_176259_O);
            boolean ceast = (Boolean)state.func_177229_b((IProperty)BlockWall.field_176257_M);
            this.post.addToList(quads, side);
            if (cnorth) {
                this.north.addToList(quads, side);
                this.north_top.addToList(quads, side);
            }
            if (csouth) {
                this.south.addToList(quads, side);
                this.south_top.addToList(quads, side);
            }
            if (cwest) {
                this.west.addToList(quads, side);
                this.west_top.addToList(quads, side);
            }
            if (ceast) {
                this.east.addToList(quads, side);
                this.east_top.addToList(quads, side);
            }
        }
    }

    private Cube makePostCube(VertexFormat format, double x, double y, double z, double w, double h, double l, Vec4f[] uv, TextureAtlasSprite[] sprites, int tintIndex) {
        uv = new Vec4f[]{new Vec4f((float)z * 16.0f, (float)(-y) * 16.0f + (16.0f - (float)h * 16.0f), (float)l * 16.0f, (float)h * 16.0f), new Vec4f(16.0f - (float)l * 16.0f - (float)z * 16.0f, (float)(-y) * 16.0f + (16.0f - (float)h * 16.0f), (float)l * 16.0f, (float)h * 16.0f), new Vec4f(5.0f, 5.0f, 6.0f, 6.0f), new Vec4f(5.0f, 5.0f, 6.0f, 6.0f), new Vec4f(16.0f - (float)w * 16.0f - (float)x * 16.0f, (float)(-y) * 16.0f + (16.0f - (float)h * 16.0f), (float)w * 16.0f, (float)h * 16.0f), new Vec4f((float)x * 16.0f, (float)(-y) * 16.0f + (16.0f - (float)h * 16.0f), (float)w * 16.0f, (float)h * 16.0f)};
        return ModelUtil.makeCube(format, x, y, z, w, h, l, uv, sprites, tintIndex);
    }
}

