/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.gui;

import epicsquid.mysticallib.gui.GuiModular;
import epicsquid.mysticallib.gui.IGuiElement;
import epicsquid.mysticallib.util.FluidTextureUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class ElementFluidTank
implements IGuiElement {
    public int x;
    public int y;
    private IFluidTankProperties tank;
    private ResourceLocation texture = GuiModular.baseTexture;

    public ElementFluidTank(int x, int y, @Nonnull IFluidTankProperties tank) {
        this.x = x;
        this.y = y;
        this.tank = tank;
    }

    public ElementFluidTank(int x, int y, @Nonnull IFluidTankProperties tank, @Nonnull ResourceLocation texture) {
        this.x = x;
        this.y = y;
        this.tank = tank;
        this.texture = texture;
    }

    @Override
    public void draw(@Nonnull GuiContainer gui, float partialTicks, int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        if (this.tank != null && this.tank.getContents() != null && this.tank.getContents().getFluid() != null) {
            float coeff = (float)this.tank.getContents().amount / (float)this.tank.getCapacity();
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            Minecraft.func_71410_x().func_147117_R();
            textureManager.func_110577_a(TextureMap.field_110575_b);
            TextureAtlasSprite sprite = FluidTextureUtil.stillTextures.get(this.tank.getContents().getFluid());
            GlStateManager.func_179147_l();
            int height = Math.round(64.0f * coeff);
            if (sprite != null) {
                int i = 0;
                for (i = 0; i <= height - 16; i += 16) {
                    gui.func_175175_a(gui.getGuiLeft() + this.x, gui.getGuiTop() + this.y + 1 + (64 - (i + 16)) - height % 16, sprite, 16, 16);
                }
                int remainder = height - i;
                double swidth = sprite.func_94212_f() - sprite.func_94209_e();
                double sheight = sprite.func_94210_h() - sprite.func_94206_g();
                GuiModular.drawTexturedModalRectWithCustomUV(gui.getGuiLeft() + this.x, gui.getGuiTop() + this.y + 1 + 64 - height % 16, sprite.func_94209_e(), sprite.func_94206_g(), (double)sprite.func_94209_e() + swidth, (double)sprite.func_94206_g() + (sheight *= (double)((float)(height - i) / 16.0f)), 16, height - i);
            }
            GlStateManager.func_179084_k();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        }
        gui.func_73729_b(gui.getGuiLeft() + this.x, gui.getGuiTop() + this.y, 224, 64, 16, 66);
        gui.func_73729_b(gui.getGuiLeft() + this.x, gui.getGuiTop() + this.y, 208, 64, 16, 66);
        if (mouseX >= gui.getGuiLeft() + this.x && mouseY >= gui.getGuiTop() + this.y && mouseX < gui.getGuiLeft() + this.x + 16 && mouseY < gui.getGuiTop() + this.y + 66) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179118_c();
            gui.func_73729_b(gui.getGuiLeft() + this.x, gui.getGuiTop() + this.y, 240, 64, 16, 66);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
        }
    }

    @Override
    public void drawTooltip(@Nonnull GuiContainer gui, float partialTicks, int mouseX, int mouseY) {
        if (mouseX >= gui.getGuiLeft() + this.x && mouseY >= gui.getGuiTop() + this.y && mouseX < gui.getGuiLeft() + this.x + 16 && mouseY < gui.getGuiTop() + this.y + 66 && this.tank.getContents() != null) {
            gui.func_146279_a("" + this.tank.getContents().amount + " / " + this.tank.getCapacity(), mouseX, mouseY);
        }
    }

    @Override
    public void onClick(@Nonnull GuiContainer gui, int mouseX, int mouseY) {
    }
}

