/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.operator.vector;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceOperator;

public class PieceOperatorVectorRaycast
extends PieceOperator {
    SpellParam origin;
    SpellParam ray;
    SpellParam max;

    public PieceOperatorVectorRaycast(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.origin = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.origin);
        this.ray = new ParamVector("psi.spellparam.ray", SpellParam.GREEN, false, false);
        this.addParam(this.ray);
        this.max = new ParamNumber("psi.spellparam.max", SpellParam.PURPLE, true, false);
        this.addParam(this.max);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 originVal = (Vector3)this.getParamValue(context, this.origin);
        Vector3 rayVal = (Vector3)this.getParamValue(context, this.ray);
        if (originVal == null || rayVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        double maxLen = 32.0;
        Double numberVal = (Double)this.getParamValue(context, this.max);
        if (numberVal != null) {
            maxLen = numberVal;
        }
        maxLen = Math.min(32.0, maxLen);
        RayTraceResult pos = PieceOperatorVectorRaycast.raycast(context.caster.func_130014_f_(), originVal, rayVal, maxLen);
        if (pos == null || pos.func_178782_a() == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        return new Vector3(pos.func_178782_a().func_177958_n(), pos.func_178782_a().func_177956_o(), pos.func_178782_a().func_177952_p());
    }

    public static RayTraceResult raycast(Entity e, double len) throws SpellRuntimeException {
        Vec3d look;
        Vector3 vec = Vector3.fromEntity(e);
        if (e instanceof EntityPlayer) {
            vec.add(0.0, e.func_70047_e(), 0.0);
        }
        if ((look = e.func_70040_Z()) == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        return PieceOperatorVectorRaycast.raycast(e.func_130014_f_(), vec, new Vector3(look), len);
    }

    public static RayTraceResult raycast(World world, Vector3 origin, Vector3 ray, double len) {
        Vector3 end = origin.copy().add(ray.copy().normalize().multiply(len));
        RayTraceResult pos = world.func_72933_a(origin.toVec3D(), end.toVec3D());
        return pos;
    }

    @Override
    public Class<?> getEvaluationType() {
        return Vector3.class;
    }
}

