/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.constant;

import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;

public class PieceConstantWrapper
extends SpellPiece {
    SpellParam target;
    SpellParam max;

    public PieceConstantWrapper(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.target = new ParamNumber("psi.spellparam.target", SpellParam.RED, false, false);
        this.addParam(this.target);
        this.max = new ParamNumber("psi.spellparam.constant", SpellParam.GREEN, false, true);
        this.addParam(this.max);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        meta.addStat(EnumSpellStat.COMPLEXITY, 1);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Double targetVal = (Double)this.getParamValue(context, this.target);
        Double maxVal = (Double)this.getParamValue(context, this.max);
        if (maxVal > 0.0) {
            return Math.min(maxVal, Math.abs(targetVal));
        }
        if (maxVal < 0.0) {
            return Math.max(maxVal, -Math.abs(targetVal));
        }
        return 0.0;
    }

    @Override
    public Object evaluate() throws SpellCompilationException {
        return this.getParamEvaluation(this.max);
    }

    @Override
    public EnumPieceType getPieceType() {
        return EnumPieceType.CONSTANT;
    }

    @Override
    public Class<?> getEvaluationType() {
        return Double.class;
    }
}

