/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.component;

import java.util.HashMap;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.arl.item.ItemMod;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICADComponent;
import vazkii.psi.common.core.PsiCreativeTab;
import vazkii.psi.common.item.base.IPsiItem;

public abstract class ItemCADComponent
extends ItemMod
implements ICADComponent,
IPsiItem {
    private final HashMap<Pair<EnumCADStat, Integer>, Integer> stats;

    public ItemCADComponent(String name, String ... variants) {
        super(name, variants);
        this.func_77625_d(1);
        this.stats = new HashMap();
        this.registerStats();
        this.func_77637_a(PsiCreativeTab.INSTANCE);
    }

    public void registerStats() {
    }

    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        ItemCADComponent.tooltipIfShift(tooltip, () -> {
            EnumCADComponent componentType = this.getComponentType(stack);
            String componentName = ItemCADComponent.local((String)componentType.getName());
            ItemCADComponent.addToTooltip((List)tooltip, (String)"psimisc.componentType", (Object[])new Object[]{componentName});
            for (EnumCADStat stat : (EnumCADStat[])EnumCADStat.class.getEnumConstants()) {
                if (stat.getSourceType() != componentType) continue;
                int statVal = this.getCADStatValue(stack, stat);
                String statValStr = statVal == -1 ? "\u221e" : "" + statVal;
                String name = ItemCADComponent.local((String)stat.getName());
                ItemCADComponent.addToTooltip((List)tooltip, (String)(" " + TextFormatting.AQUA + name + TextFormatting.GRAY + ": " + statValStr), (Object[])new Object[0]);
            }
        });
    }

    public void addStat(EnumCADStat stat, int meta, int value) {
        this.stats.put((Pair<EnumCADStat, Integer>)Pair.of((Object)((Object)stat), (Object)meta), value);
    }

    @Override
    public int getCADStatValue(ItemStack stack, EnumCADStat stat) {
        Pair p = Pair.of((Object)((Object)stat), (Object)stack.func_77952_i());
        if (this.stats.containsKey(p)) {
            return this.stats.get(p);
        }
        return 0;
    }
}

