/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.helper;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class TextHelper {
    @SideOnly(value=Side.CLIENT)
    public static List<String> renderText(int x, int y, int width, String unlocalizedText, boolean centered, boolean doit, Object ... format) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        boolean unicode = font.func_82883_a();
        font.func_78264_a(true);
        String text = I18n.func_74838_a((String)unlocalizedText).replaceAll("&", "\u00a7");
        if (format != null && format.length > 0) {
            text = String.format(text, format);
        }
        String[] textEntries = text.split("<br>");
        ArrayList lines = new ArrayList();
        String controlCodes = "";
        for (String string : textEntries) {
            String[] tokens;
            ArrayList<String> words = new ArrayList<String>();
            String lineStr = "";
            for (String token : tokens = string.split(" ")) {
                String prev = lineStr;
                String spaced = token + " ";
                lineStr = lineStr + spaced;
                controlCodes = TextHelper.toControlCodes(TextHelper.getControlCodes(prev));
                if (font.func_78256_a(lineStr) > width) {
                    lines.add(words);
                    lineStr = controlCodes + spaced;
                    words = new ArrayList();
                }
                words.add(controlCodes + token);
            }
            if (!lineStr.isEmpty()) {
                lines.add(words);
            }
            lines.add(new ArrayList());
        }
        ArrayList<String> textLines = new ArrayList<String>();
        String lastLine = "";
        for (List list : lines) {
            list.size();
            int xi = x;
            int spacing = 4;
            int wcount = list.size();
            int compensationSpaces = 0;
            boolean justify = false;
            if (justify) {
                String s = Joiner.on((String)"").join((Iterable)list);
                int swidth = font.func_78256_a(s);
                int space = width - swidth;
                spacing = wcount == 1 ? 0 : space / (wcount - 1);
                compensationSpaces = wcount == 1 ? 0 : space % (wcount - 1);
            }
            String lineStr = "";
            for (String s : list) {
                int extra = 0;
                if (compensationSpaces > 0) {
                    --compensationSpaces;
                    ++extra;
                }
                int swidth = font.func_78256_a(s);
                if (doit) {
                    if (centered) {
                        font.func_78276_b(s, xi + width / 2 - swidth / 2, y, 0xFFFFFF);
                    } else {
                        font.func_78276_b(s, xi, y, 0xFFFFFF);
                    }
                }
                xi += swidth + spacing + extra;
                lineStr = lineStr + s + " ";
            }
            if (!lineStr.isEmpty() || lastLine.isEmpty()) {
                y += 10;
                textLines.add(lineStr);
            }
            lastLine = lineStr;
        }
        font.func_78264_a(unicode);
        return textLines;
    }

    public static String getControlCodes(String s) {
        String controls = s.replaceAll("(?<!\u00a7)(.)", "");
        String wiped = controls.replaceAll(".*r", "r");
        return wiped;
    }

    public static String toControlCodes(String s) {
        return s.replaceAll(".", "\u00a7$0");
    }
}

