/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.universalSensor.IEventSensorSetting;
import me.desht.pneumaticcraft.api.universalSensor.IPollSensorSetting;
import me.desht.pneumaticcraft.api.universalSensor.ISensorSetting;
import me.desht.pneumaticcraft.client.gui.GuiUniversalSensor;
import me.desht.pneumaticcraft.client.render.RenderRangeLines;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.item.ItemGPSTool;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketRenderRangeLines;
import me.desht.pneumaticcraft.common.sensor.SensorHandler;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.LuaConstant;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.LuaMethod;
import me.desht.pneumaticcraft.common.tileentity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRangeLineShower;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.GlobalTileEntityCacheManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityUniversalSensor
extends TileEntityPneumaticBase
implements IRangeLineShower,
IGUITextFieldSensitive,
IMinWorkingPressure,
IRedstoneControl {
    private static final List<String> REDSTONE_LABELS = ImmutableList.of((Object)"gui.tab.redstoneBehaviour.universalSensor.button.inverted", (Object)"gui.tab.redstoneBehaviour.universalSensor.button.normal");
    public static final int INVENTORY_SIZE = 4;
    @DescSynced
    public final boolean[] sidesConnected = new boolean[6];
    @GuiSynced
    private String sensorSetting = "";
    private int tickTimer;
    public int redstoneStrength;
    private int eventTimer;
    public float dishRotation;
    public float oldDishRotation;
    private float dishSpeed;
    @GuiSynced
    private boolean invertedRedstone;
    @DescSynced
    public boolean isSensorActive;
    @GuiSynced
    private String sensorGuiText = "";
    private boolean requestPollPullEvent;
    private final Set<BlockPos> positions = new HashSet<BlockPos>();
    private int oldSensorRange;
    private final RenderRangeLines rangeLineRenderer = new RenderRangeLines(0x330000FF);
    private final List<IComputerAccess> attachedComputers = new ArrayList<IComputerAccess>();

    public TileEntityUniversalSensor() {
        super(5.0f, 7.0f, 5000, 0);
        for (Item upgrade : SensorHandler.getInstance().getUniversalSensorUpgrades()) {
            this.addApplicableUpgrade(upgrade);
        }
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.RANGE);
        this.upgradeHandler = new UniversalSensorUpgradeHandler(this);
    }

    @Override
    public void func_73660_a() {
        this.oldDishRotation = this.dishRotation;
        this.dishSpeed = this.isSensorActive ? Math.min(this.dishSpeed + 0.2f, 10.0f) : Math.max(this.dishSpeed - 0.2f, 0.0f);
        this.dishRotation += this.dishSpeed;
        if (this.func_145831_w().field_72995_K) {
            int sensorRange = this.getRange();
            if (this.oldSensorRange != sensorRange || this.oldSensorRange == 0) {
                this.oldSensorRange = sensorRange;
                if (!this.firstRun) {
                    this.rangeLineRenderer.resetRendering(sensorRange);
                }
            }
            this.rangeLineRenderer.update();
        }
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            ++this.tickTimer;
            ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(this.sensorSetting);
            if (sensor != null && this.getPressure() > 0.5f) {
                this.isSensorActive = true;
                this.addAir(-sensor.getAirUsage(this.func_145831_w(), this.func_174877_v()));
                if (sensor instanceof IPollSensorSetting) {
                    if (this.tickTimer >= ((IPollSensorSetting)sensor).getPollFrequency(this)) {
                        int newRedstoneStrength = ((IPollSensorSetting)sensor).getRedstoneValue(this.func_145831_w(), this.func_174877_v(), this.getRange(), this.sensorGuiText);
                        if (this.invertedRedstone) {
                            newRedstoneStrength = 15 - newRedstoneStrength;
                        }
                        if (newRedstoneStrength != this.redstoneStrength) {
                            this.redstoneStrength = newRedstoneStrength;
                            if (this.requestPollPullEvent) {
                                this.notifyComputers(this.redstoneStrength);
                            }
                            this.updateNeighbours();
                        }
                        this.tickTimer = 0;
                    }
                    this.eventTimer = 0;
                } else if (this.eventTimer > 0) {
                    --this.eventTimer;
                    if (this.eventTimer == 0 && this.redstoneStrength != (this.invertedRedstone ? 15 : 0)) {
                        this.redstoneStrength = this.invertedRedstone ? 15 : 0;
                        this.updateNeighbours();
                    }
                }
            } else {
                this.isSensorActive = false;
                if (this.redstoneStrength != (this.invertedRedstone ? 15 : 0)) {
                    this.redstoneStrength = this.invertedRedstone ? 15 : 0;
                    this.updateNeighbours();
                }
            }
        }
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        this.updateConnections();
    }

    public void updateConnections() {
        List<Pair<EnumFacing, IAirHandler>> connections = this.getAirHandler(null).getConnectedPneumatics();
        Arrays.fill(this.sidesConnected, false);
        for (Pair<EnumFacing, IAirHandler> entry : connections) {
            this.sidesConnected[((EnumFacing)entry.getKey()).ordinal()] = true;
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public boolean isConnectedTo(EnumFacing side) {
        return side != EnumFacing.UP;
    }

    @Override
    public void showRangeLines() {
        if (this.func_145831_w().field_72995_K) {
            this.rangeLineRenderer.resetRendering(this.getRange());
        } else {
            NetworkHandler.sendToAllAround(new PacketRenderRangeLines(this), this.func_145831_w(), 64.0 + (double)this.getRange());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderRangeLines() {
        this.rangeLineRenderer.render();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.rangeLineRenderer == null || !this.rangeLineRenderer.isCurrentlyRendering()) {
            return super.getRenderBoundingBox();
        }
        int range = this.getRange();
        return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - range), (double)(this.func_174877_v().func_177956_o() - range), (double)(this.func_174877_v().func_177952_p() - range), (double)(this.func_174877_v().func_177958_n() + 1 + range), (double)(this.func_174877_v().func_177956_o() + 1 + range), (double)(this.func_174877_v().func_177952_p() + 1 + range));
    }

    public void onEvent(Event event) {
        ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(this.sensorSetting);
        if (sensor instanceof IEventSensorSetting && this.getPressure() > 0.5f) {
            int newRedstoneStrength = ((IEventSensorSetting)sensor).emitRedstoneOnEvent(event, this, this.getRange(), this.sensorGuiText);
            if (newRedstoneStrength != 0) {
                this.eventTimer = ((IEventSensorSetting)sensor).getRedstonePulseLength();
            }
            if (this.invertedRedstone) {
                newRedstoneStrength = 15 - newRedstoneStrength;
            }
            if (this.eventTimer > 0 && ThirdPartyManager.computerCraftLoaded) {
                if (event instanceof PlayerInteractEvent) {
                    PlayerInteractEvent e = (PlayerInteractEvent)event;
                    this.notifyComputers(newRedstoneStrength, e.getPos().func_177958_n(), e.getPos().func_177956_o(), e.getPos().func_177952_p());
                } else {
                    this.notifyComputers(newRedstoneStrength);
                }
            }
            if (newRedstoneStrength != this.redstoneStrength) {
                this.redstoneStrength = newRedstoneStrength;
                this.updateNeighbours();
            }
        }
    }

    public int getRange() {
        return this.getUpgrades(IItemRegistry.EnumUpgrade.RANGE) + 2;
    }

    private void setSensorSetting(String sensorPath) {
        GuiScreen guiScreen;
        this.sensorSetting = sensorPath;
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K && (guiScreen = Minecraft.func_71410_x().field_71462_r) instanceof GuiUniversalSensor) {
            ((GuiUniversalSensor)guiScreen).updateButtons();
        }
    }

    private boolean setSensorSetting(ISensorSetting sensor) {
        if (this.areGivenUpgradesInserted(sensor.getRequiredUpgrades())) {
            this.setSensorSetting(sensor.getSensorPath());
            return true;
        }
        return false;
    }

    public String getSensorSetting() {
        return this.sensorSetting;
    }

    @Override
    public void onGuiUpdate() {
        this.setSensorSetting(this.sensorSetting);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74778_a("sensorSetting", this.sensorSetting);
        tag.func_74757_a("invertedRedstone", this.invertedRedstone);
        tag.func_74776_a("dishSpeed", this.dishSpeed);
        tag.func_74778_a("sensorText", this.sensorGuiText);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setSensorSetting(tag.func_74779_i("sensorSetting"));
        this.invertedRedstone = tag.func_74767_n("invertedRedstone");
        this.dishSpeed = tag.func_74760_g("dishSpeed");
        this.sensorGuiText = tag.func_74779_i("sensorText");
        this.setupGPSPositions();
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID >= 10 && buttonID % 10 == 0) {
            String[] directories = SensorHandler.getInstance().getDirectoriesAtLocation(this.getSensorSetting());
            if (buttonID / 10 <= directories.length) {
                if (this.getSensorSetting().equals("")) {
                    this.setSensorSetting(directories[buttonID / 10 - 1]);
                } else {
                    this.setSensorSetting(this.getSensorSetting() + "/" + directories[buttonID / 10 - 1]);
                }
            }
        } else if (buttonID == 1) {
            String[] folders = this.getSensorSetting().split("/");
            String newPath = this.getSensorSetting().replace(folders[folders.length - 1], "");
            if (newPath.endsWith("/")) {
                newPath = newPath.substring(0, newPath.length() - 1);
            }
            this.setSensorSetting(newPath);
        } else if (buttonID == 0) {
            this.invertedRedstone = !this.invertedRedstone;
            this.redstoneStrength = 15 - this.redstoneStrength;
            this.updateNeighbours();
        }
    }

    public boolean areGivenUpgradesInserted(Set<Item> requiredItems) {
        for (Item requiredItem : requiredItems) {
            if (this.getUpgrades(requiredItem) != 0) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public Set<BlockPos> getGPSPositions() {
        return this.positions;
    }

    private void setupGPSPositions() {
        this.positions.clear();
        ArrayList<BlockPos> gpsPositions = new ArrayList<BlockPos>();
        int sensorRange = this.getRange();
        for (int i = 0; i < this.upgradeHandler.getSlots(); ++i) {
            BlockPos pos;
            ItemStack gps = this.upgradeHandler.getStackInSlot(i);
            if (gps.func_77973_b() != Itemss.GPS_TOOL || (pos = ItemGPSTool.getGPSLocation(gps)) == null || Math.abs(pos.func_177958_n() - this.func_174877_v().func_177958_n()) > sensorRange || Math.abs(pos.func_177956_o() - this.func_174877_v().func_177956_o()) > sensorRange || Math.abs(pos.func_177952_p() - this.func_174877_v().func_177952_p()) > sensorRange) continue;
            gpsPositions.add(pos);
        }
        if (gpsPositions.size() == 1) {
            this.positions.add((BlockPos)gpsPositions.get(0));
        } else if (gpsPositions.size() > 1) {
            int minX = Math.min(((BlockPos)gpsPositions.get(0)).func_177958_n(), ((BlockPos)gpsPositions.get(1)).func_177958_n());
            int minY = Math.min(((BlockPos)gpsPositions.get(0)).func_177956_o(), ((BlockPos)gpsPositions.get(1)).func_177956_o());
            int minZ = Math.min(((BlockPos)gpsPositions.get(0)).func_177952_p(), ((BlockPos)gpsPositions.get(1)).func_177952_p());
            int maxX = Math.max(((BlockPos)gpsPositions.get(0)).func_177958_n(), ((BlockPos)gpsPositions.get(1)).func_177958_n());
            int maxY = Math.max(((BlockPos)gpsPositions.get(0)).func_177956_o(), ((BlockPos)gpsPositions.get(1)).func_177956_o());
            int maxZ = Math.max(((BlockPos)gpsPositions.get(0)).func_177952_p(), ((BlockPos)gpsPositions.get(1)).func_177952_p());
            for (int x = minX; x <= maxX; ++x) {
                for (int y = Math.min(255, maxY); y >= minY && y >= 0; --y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        this.positions.add(new BlockPos(x, y, z));
                    }
                }
            }
        }
    }

    @Override
    public String getName() {
        return Blockss.UNIVERSAL_SENSOR.func_149739_a();
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.sensorGuiText = text;
        if (!this.func_145831_w().field_72995_K) {
            this.scheduleDescriptionPacket();
        }
    }

    @Override
    public String getText(int textFieldID) {
        return this.sensorGuiText;
    }

    @Override
    public String getType() {
        return "universalSensor";
    }

    @Override
    public void addLuaMethods() {
        super.addLuaMethods();
        this.luaMethods.add(new LuaMethod("getSensorNames"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    return SensorHandler.getInstance().getSensorNames();
                }
                throw new IllegalArgumentException("getSensorNames doesn't accept any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("setSensor"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    ISensorSetting sensor = args[0] instanceof String ? SensorHandler.getInstance().getSensorForName((String)args[0]) : SensorHandler.getInstance().getSensorByIndex(((Double)args[0]).intValue() - 1);
                    if (sensor != null) {
                        return new Object[]{TileEntityUniversalSensor.this.setSensorSetting(sensor)};
                    }
                    throw new IllegalArgumentException("Invalid sensor name/index: " + args[0]);
                }
                if (args.length == 0) {
                    TileEntityUniversalSensor.this.setSensorSetting("");
                    return new Object[]{true};
                }
                throw new IllegalArgumentException("setSensor needs one argument(a number as index, or a sensor name).");
            }
        });
        this.luaMethods.add(new LuaMethod("getSensor"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    Object[] objectArray;
                    ISensorSetting curSensor = SensorHandler.getInstance().getSensorFromPath(TileEntityUniversalSensor.this.getSensorSetting());
                    if (curSensor == null) {
                        objectArray = null;
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = TileEntityUniversalSensor.this.getSensorSetting().substring(TileEntityUniversalSensor.this.getSensorSetting().lastIndexOf(47) + 1);
                    }
                    return objectArray;
                }
                throw new IllegalArgumentException("getSensor doesn't take any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("setTextfield"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityUniversalSensor.this.setText(0, (String)args[0]);
                    return null;
                }
                throw new IllegalArgumentException("setTextfield takes one argument (string)");
            }
        });
        this.luaMethods.add(new LuaMethod("getTextfield"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    return new Object[]{TileEntityUniversalSensor.this.getText(0)};
                }
                throw new IllegalArgumentException("getTextfield takes no arguments");
            }
        });
        this.luaMethods.add(new LuaMethod("isSensorEventBased"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    return new Object[]{SensorHandler.getInstance().getSensorFromPath(TileEntityUniversalSensor.this.getSensorSetting()) instanceof IEventSensorSetting};
                }
                throw new IllegalArgumentException("isSensorEventBased takes no arguments");
            }
        });
        this.luaMethods.add(new LuaMethod("getSensorValue"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    ISensorSetting s = SensorHandler.getInstance().getSensorFromPath(TileEntityUniversalSensor.this.getSensorSetting());
                    if (s instanceof IPollSensorSetting) {
                        TileEntityUniversalSensor.this.requestPollPullEvent = true;
                        return new Object[]{TileEntityUniversalSensor.this.redstoneStrength};
                    }
                    if (s != null) {
                        throw new IllegalArgumentException("The selected sensor is pull event based. You can't poll the value.");
                    }
                    throw new IllegalArgumentException("There's no sensor selected!");
                }
                throw new IllegalArgumentException("getSensorValue takes no arguments");
            }
        });
        this.luaMethods.add(new LuaConstant("getMinWorkingPressure", 0.5f));
        this.luaMethods.add(new LuaMethod("setGPSToolCoordinate"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 4) {
                    ItemStack stack = TileEntityUniversalSensor.this.upgradeHandler.getStackInSlot(((Double)args[0]).intValue() - 1);
                    if (stack.func_77973_b() == Itemss.GPS_TOOL) {
                        ItemGPSTool.setGPSLocation(stack, new BlockPos(((Double)args[1]).doubleValue(), ((Double)args[2]).doubleValue(), ((Double)args[3]).doubleValue()));
                        return new Object[]{true};
                    }
                    return new Object[]{false};
                }
                throw new IllegalArgumentException("setGPSToolCoordinate needs 4 arguments: slot, x, y, z");
            }
        });
        this.luaMethods.add(new LuaMethod("getGPSToolCoordinate"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    ItemStack stack = TileEntityUniversalSensor.this.upgradeHandler.getStackInSlot(((Double)args[0]).intValue() - 1);
                    if (stack.func_77973_b() == Itemss.GPS_TOOL) {
                        BlockPos pos = ItemGPSTool.getGPSLocation(stack);
                        if (pos != null) {
                            return new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
                        }
                        return new Object[]{0, 0, 0};
                    }
                    return null;
                }
                throw new IllegalArgumentException("setGPSToolCoordinate needs 1 argument: slot");
            }
        });
    }

    @Override
    @Optional.Method(modid="computercraft")
    public void attach(IComputerAccess computer) {
        this.attachedComputers.add(computer);
    }

    @Override
    @Optional.Method(modid="computercraft")
    public void detach(IComputerAccess computer) {
        this.attachedComputers.remove(computer);
    }

    @Optional.Method(modid="computercraft")
    private void notifyComputers(Object ... arguments) {
        for (IComputerAccess computer : this.attachedComputers) {
            computer.queueEvent(this.getType(), arguments);
        }
    }

    @Override
    public int getRedstoneMode() {
        return this.invertedRedstone ? 1 : 0;
    }

    @Override
    public float getMinWorkingPressure() {
        return 0.5f;
    }

    @Override
    public String getRedstoneTabTitle() {
        return "gui.tab.redstoneBehaviour.universalSensor.redstoneEmission";
    }

    @Override
    protected List<String> getRedstoneButtonLabels() {
        return REDSTONE_LABELS;
    }

    public void func_145843_s() {
        super.func_145843_s();
        GlobalTileEntityCacheManager.getInstance().universalSensors.remove(this);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        GlobalTileEntityCacheManager.getInstance().universalSensors.add(this);
    }

    private class UniversalSensorUpgradeHandler
    extends TileEntityBase.UpgradeHandler {
        private final TileEntityUniversalSensor te;

        UniversalSensorUpgradeHandler(TileEntityUniversalSensor te) {
            super(TileEntityUniversalSensor.this, 4);
            this.te = te;
        }

        @Override
        public boolean test(Integer integer, ItemStack itemStack) {
            return itemStack.func_190926_b() || TileEntityUniversalSensor.this.getApplicableUpgrades().contains(itemStack.func_77973_b()) || itemStack.func_77973_b() == Itemss.GPS_TOOL;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (!(TileEntityUniversalSensor.this.func_145831_w().field_72995_K || TileEntityUniversalSensor.this.getSensorSetting().equals("") || TileEntityUniversalSensor.this.areGivenUpgradesInserted(SensorHandler.getInstance().getRequiredStacksFromText(TileEntityUniversalSensor.this.getSensorSetting())))) {
                TileEntityUniversalSensor.this.setSensorSetting("");
            }
            this.te.setupGPSPositions();
        }
    }
}

