/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.recipe.IThermopneumaticProcessingPlantRecipe;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.recipes.BasicThermopneumaticProcessingPlantRecipe;
import me.desht.pneumaticcraft.common.tileentity.FilteredItemStackHandler;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.ISmartFluidSync;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;

public class TileEntityThermopneumaticProcessingPlant
extends TileEntityPneumaticBase
implements IHeatExchanger,
IMinWorkingPressure,
IRedstoneControlled,
ISerializableTanks,
ISmartFluidSync {
    private static final int INVENTORY_SIZE = 1;
    private static final int CRAFTING_TIME = 60;
    @GuiSynced
    @DescSynced
    @LazySynced
    private final ThermopneumaticFluidTankInput inputTank = new ThermopneumaticFluidTankInput(16000);
    @GuiSynced
    @DescSynced
    @LazySynced
    private final ThermopneumaticFluidTankOutput outputTank = new ThermopneumaticFluidTankOutput(16000);
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().getHeatExchangerLogic();
    @GuiSynced
    public int redstoneMode;
    @GuiSynced
    private int craftingProgress;
    @GuiSynced
    public boolean hasRecipe;
    @GuiSynced
    private float requiredPressure;
    @GuiSynced
    public double requiredTemperature;
    @DescSynced
    private int inputAmountScaled;
    @DescSynced
    private int outputAmountScaled;
    private final ItemStackHandler handler = new FilteredItemStackHandler(this, 1){

        @Override
        public boolean test(Integer integer, ItemStack itemStack) {
            return itemStack.func_190926_b() || BasicThermopneumaticProcessingPlantRecipe.recipes.stream().anyMatch(r -> r.isValidInput(itemStack));
        }
    };
    private final ThermopneumaticFluidHandler fluidHandler = new ThermopneumaticFluidHandler();

    public TileEntityThermopneumaticProcessingPlant() {
        super(5.0f, 7.0f, 3000, 4);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.DISPENSER);
        this.heatExchanger.setThermalResistance(10.0);
    }

    @Override
    public boolean isConnectedTo(EnumFacing dir) {
        return this.getRotation().func_176734_d() != dir && dir != EnumFacing.UP;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            IThermopneumaticProcessingPlantRecipe recipe = this.getValidRecipe();
            boolean bl = this.hasRecipe = recipe != null;
            if (this.hasRecipe) {
                ItemStack stackInSlot = this.handler.getStackInSlot(0);
                this.requiredPressure = recipe.getRequiredPressure(this.inputTank.getFluid(), stackInSlot);
                this.requiredTemperature = recipe.getRequiredTemperature(this.inputTank.getFluid(), stackInSlot);
                if (this.redstoneAllows() && this.heatExchanger.getTemperature() >= this.requiredTemperature && this.getPressure() >= this.getMinWorkingPressure()) {
                    ++this.craftingProgress;
                    if (this.craftingProgress >= 60) {
                        this.outputTank.fill(recipe.getRecipeOutput(this.inputTank.getFluid(), stackInSlot).copy(), true);
                        recipe.useRecipeItems(this.inputTank.getFluid(), stackInSlot);
                        this.handler.setStackInSlot(0, stackInSlot);
                        this.addAir(-recipe.airUsed(this.inputTank.getFluid(), stackInSlot));
                        this.heatExchanger.addHeat(-recipe.heatUsed(this.inputTank.getFluid(), stackInSlot));
                        if (this.inputTank.getFluid() != null && this.inputTank.getFluid().amount <= 0) {
                            this.inputTank.setFluid(null);
                        }
                        this.craftingProgress = 0;
                    }
                }
            } else {
                this.craftingProgress = 0;
                this.requiredTemperature = 273.0;
                this.requiredPressure = 0.0f;
            }
            if (this.getUpgrades(IItemRegistry.EnumUpgrade.DISPENSER) > 0) {
                this.autoExportLiquid();
            }
        }
    }

    private IThermopneumaticProcessingPlantRecipe getValidRecipe() {
        for (IThermopneumaticProcessingPlantRecipe recipe : BasicThermopneumaticProcessingPlantRecipe.recipes) {
            if (!recipe.isValidRecipe(this.inputTank.getFluid(), this.handler.getStackInSlot(0))) continue;
            if (this.outputTank.getFluid() == null) {
                return recipe;
            }
            FluidStack output = recipe.getRecipeOutput(this.inputTank.getFluid(), this.handler.getStackInSlot(0));
            if (output.getFluid() != this.outputTank.getFluid().getFluid() || output.amount > this.outputTank.getCapacity() - this.outputTank.getFluidAmount()) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return this.handler;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidHandler);
        }
        return super.getCapability(capability, facing);
    }

    public FluidTank getInputTank() {
        return this.inputTank;
    }

    public FluidTank getOutputTank() {
        return this.outputTank;
    }

    @SideOnly(value=Side.CLIENT)
    public double getCraftingPercentage() {
        return (double)this.craftingProgress / 60.0;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("Items", (NBTBase)this.handler.serializeNBT());
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        tag.func_74768_a("craftingProgress", this.craftingProgress);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.inputTank.writeToNBT(tankTag);
        tag.func_74782_a("inputTank", (NBTBase)tankTag);
        tankTag = new NBTTagCompound();
        this.outputTank.writeToNBT(tankTag);
        tag.func_74782_a("outputTank", (NBTBase)tankTag);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.handler.deserializeNBT(tag.func_74775_l("Items"));
        this.redstoneMode = tag.func_74771_c("redstoneMode");
        this.craftingProgress = tag.func_74762_e("craftingProgress");
        this.inputTank.readFromNBT(tag.func_74775_l("inputTank"));
        this.inputAmountScaled = this.inputTank.getScaledFluidAmount();
        this.outputTank.readFromNBT(tag.func_74775_l("outputTank"));
        this.outputAmountScaled = this.outputTank.getScaledFluidAmount();
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(EnumFacing side) {
        return this.heatExchanger;
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        } else if (buttonID == 1) {
            this.inputTank.drain(this.inputTank.getCapacity(), true);
        }
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public float getMinWorkingPressure() {
        return this.requiredPressure;
    }

    @Override
    public String getName() {
        return Blockss.THERMOPNEUMATIC_PROCESSING_PLANT.func_149739_a();
    }

    @Override
    @Nonnull
    public Map<String, FluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"InputTank", (Object)((Object)this.inputTank), (Object)"OutputTank", (Object)((Object)this.outputTank));
    }

    @Override
    public void updateScaledFluidAmount(int tankIndex, int amount) {
        if (tankIndex == 1) {
            this.inputAmountScaled = amount;
        } else if (tankIndex == 2) {
            this.outputAmountScaled = amount;
        }
    }

    private class ThermopneumaticFluidHandler
    implements IFluidHandler {
        private ThermopneumaticFluidHandler() {
        }

        public IFluidTankProperties[] getTankProperties() {
            return (IFluidTankProperties[])ArrayUtils.addAll((Object[])TileEntityThermopneumaticProcessingPlant.this.inputTank.getTankProperties(), (Object[])TileEntityThermopneumaticProcessingPlant.this.outputTank.getTankProperties());
        }

        public int fill(FluidStack resource, boolean doFill) {
            return TileEntityThermopneumaticProcessingPlant.this.inputTank.fill(resource, doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return TileEntityThermopneumaticProcessingPlant.this.outputTank.getFluid() != null && TileEntityThermopneumaticProcessingPlant.this.outputTank.getFluid().isFluidEqual(resource) ? TileEntityThermopneumaticProcessingPlant.this.outputTank.drain(resource.amount, doDrain) : null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return TileEntityThermopneumaticProcessingPlant.this.outputTank.drain(maxDrain, doDrain);
        }
    }

    private class ThermopneumaticFluidTankOutput
    extends ISmartFluidSync.SmartSyncTank {
        ThermopneumaticFluidTankOutput(int capacity) {
            super(TileEntityThermopneumaticProcessingPlant.this, capacity, 2);
        }
    }

    private class ThermopneumaticFluidTankInput
    extends ISmartFluidSync.SmartSyncTank {
        ThermopneumaticFluidTankInput(int capacity) {
            super(TileEntityThermopneumaticProcessingPlant.this, capacity, 1);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid == null || BasicThermopneumaticProcessingPlantRecipe.recipes.stream().anyMatch(r -> r.isValidInput(fluid));
        }
    }
}

