/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.recipes.RefineryRecipe;
import me.desht.pneumaticcraft.common.tileentity.IComparatorSupport;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.ISmartFluidSync;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.apache.commons.lang3.ArrayUtils;

public class TileEntityRefinery
extends TileEntityTickableBase
implements IHeatExchanger,
IRedstoneControlled,
IComparatorSupport,
ISerializableTanks,
ISmartFluidSync {
    @GuiSynced
    @DescSynced
    @LazySynced
    private final RefineryInputTank inputTank = new RefineryInputTank(16000);
    @GuiSynced
    @DescSynced
    @LazySynced
    private final ISmartFluidSync.SmartSyncTank outputTank = new ISmartFluidSync.SmartSyncTank(this, 16000, 2);
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().getHeatExchangerLogic();
    @DescSynced
    private int inputAmountScaled;
    @DescSynced
    private int outputAmountScaled;
    @GuiSynced
    private int redstoneMode;
    @GuiSynced
    private boolean blocked;
    private RefineryRecipe currentRecipe;
    private int workTimer = 0;
    private int comparatorValue;
    private int prevRefineryCount = -1;
    private final RefineryFluidHandler refineryFluidHandler = new RefineryFluidHandler();
    private boolean searchForRecipe = true;

    public static boolean isInputFluidValid(Fluid fluid, int size) {
        return RefineryRecipe.getRecipe(fluid, size).isPresent();
    }

    @Override
    public String getName() {
        return Blockss.REFINERY.func_149739_a();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K && this.isMaster()) {
            List<TileEntityRefinery> refineries = this.getRefineries();
            if (this.searchForRecipe) {
                Optional<RefineryRecipe> recipe = RefineryRecipe.getRecipe(this.inputTank.getFluid() != null ? this.inputTank.getFluid().getFluid() : null, refineries.size());
                this.currentRecipe = recipe.orElse(null);
                this.searchForRecipe = false;
            }
            boolean didWork = false;
            if (this.currentRecipe != null) {
                if (this.prevRefineryCount != refineries.size() && refineries.size() > 1) {
                    this.redistributeFluids(refineries, this.currentRecipe);
                    this.prevRefineryCount = refineries.size();
                }
                if (this.heatExchanger.getTemperature() >= 373.0 && this.redstoneAllows() && this.inputTank.getFluidAmount() >= this.currentRecipe.input.amount) {
                    if (refineries.size() > 1 && this.refine(refineries, true)) {
                        int progress = Math.max(0, ((int)this.heatExchanger.getTemperature() - 343) / 30);
                        progress = Math.min(5, progress);
                        this.heatExchanger.addHeat(-progress);
                        this.workTimer += progress;
                        while (this.workTimer >= 20 && this.inputTank.getFluidAmount() >= this.currentRecipe.input.amount) {
                            this.workTimer -= 20;
                            this.refine(refineries, false);
                            this.inputTank.drain(this.currentRecipe.input.amount, true);
                            NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumParticleTypes.SMOKE_LARGE, (double)this.func_174877_v().func_177958_n(), (double)(this.func_174877_v().func_177956_o() + refineries.size()), (double)this.func_174877_v().func_177952_p(), 0.0, 0.0, 0.0, Math.max(2, progress), 1.0, 1.0, 1.0), this.func_145831_w());
                        }
                        didWork = true;
                    } else {
                        this.workTimer = 0;
                    }
                }
            }
            this.updateComparatorValue(refineries, didWork);
        }
    }

    private void redistributeFluids(List<TileEntityRefinery> refineries, RefineryRecipe currentRecipe) {
        int i;
        for (int i2 = 1; i2 < refineries.size(); ++i2) {
            this.tryMoveFluid(refineries.get(i2).getInputTank(), this.getInputTank());
        }
        FluidTank[] tempTanks = new FluidTank[refineries.size()];
        for (i = 0; i < refineries.size(); ++i) {
            tempTanks[i] = new FluidTank(16000);
        }
        block2: for (i = 0; i < refineries.size(); ++i) {
            FluidTank sourceTank = refineries.get(i).getOutputTank();
            FluidStack fluid = sourceTank.getFluid();
            if (fluid == null || fluid.isFluidEqual(currentRecipe.outputs[i])) continue;
            for (int j = 0; j < currentRecipe.outputs.length; ++j) {
                if (!currentRecipe.outputs[j].isFluidEqual(fluid)) continue;
                this.tryMoveFluid(sourceTank, tempTanks[j]);
                continue block2;
            }
        }
        for (i = 0; i < refineries.size(); ++i) {
            this.tryMoveFluid(tempTanks[i], refineries.get(i).getOutputTank());
        }
    }

    private void tryMoveFluid(FluidTank sourceTank, FluidTank destTank) {
        int moved;
        FluidStack fluid = sourceTank.drain(sourceTank.getCapacity(), false);
        if (fluid != null && fluid.amount > 0 && (moved = destTank.fill(fluid, true)) > 0) {
            sourceTank.drain(moved, true);
        }
    }

    private List<TileEntityRefinery> getRefineries() {
        ArrayList<TileEntityRefinery> refineries = new ArrayList<TileEntityRefinery>();
        refineries.add(this);
        TileEntityRefinery refinery = this;
        while (refinery.getCachedNeighbor(EnumFacing.UP) instanceof TileEntityRefinery) {
            refinery = (TileEntityRefinery)refinery.getCachedNeighbor(EnumFacing.UP);
            refineries.add(refinery);
        }
        return refineries;
    }

    private boolean refine(List<TileEntityRefinery> refineries, boolean simulate) {
        if (this.currentRecipe == null) {
            this.blocked = true;
            return false;
        }
        FluidStack[] outputs = this.currentRecipe.outputs;
        int i = 0;
        for (TileEntityRefinery refinery : refineries) {
            if (i > outputs.length - 1) {
                this.blocked = false;
                return true;
            }
            if (outputs[i].amount != refinery.outputTank.fill(outputs[i], !simulate)) {
                this.blocked = true;
                return false;
            }
            ++i;
        }
        this.blocked = false;
        return true;
    }

    public TileEntityRefinery getMasterRefinery() {
        TileEntityRefinery master = this;
        while (master.getCachedNeighbor(EnumFacing.DOWN) instanceof TileEntityRefinery) {
            master = (TileEntityRefinery)master.getCachedNeighbor(EnumFacing.DOWN);
        }
        return master;
    }

    private boolean isMaster() {
        return this.getMasterRefinery() == this;
    }

    @Override
    public boolean redstoneAllows() {
        boolean isPoweredByRedstone = this.poweredRedstone > 0;
        TileEntityRefinery refinery = this;
        while (refinery.poweredRedstone == 0 && refinery.getCachedNeighbor(EnumFacing.UP) instanceof TileEntityRefinery) {
            refinery = (TileEntityRefinery)refinery.getCachedNeighbor(EnumFacing.UP);
            isPoweredByRedstone = refinery.poweredRedstone > 0;
        }
        switch (this.getRedstoneMode()) {
            case 0: {
                return true;
            }
            case 1: {
                return isPoweredByRedstone;
            }
            case 2: {
                return !isPoweredByRedstone;
            }
        }
        return false;
    }

    public FluidTank getInputTank() {
        return this.inputTank;
    }

    public FluidTank getOutputTank() {
        return this.outputTank;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.inputTank.writeToNBT(tankTag);
        tag.func_74782_a("oilTank", (NBTBase)tankTag);
        tankTag = new NBTTagCompound();
        this.outputTank.writeToNBT(tankTag);
        tag.func_74782_a("outputTank", (NBTBase)tankTag);
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inputTank.readFromNBT(tag.func_74775_l("oilTank"));
        this.inputAmountScaled = this.inputTank.getScaledFluidAmount();
        this.outputTank.readFromNBT(tag.func_74775_l("outputTank"));
        this.outputAmountScaled = this.outputTank.getScaledFluidAmount();
        this.redstoneMode = tag.func_74771_c("redstoneMode");
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(EnumFacing side) {
        return this.heatExchanger;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    private void updateComparatorValue(List<TileEntityRefinery> refineries, boolean didWork) {
        int value;
        if (this.inputTank.getFluidAmount() < 10 || refineries.size() < 2 || this.currentRecipe == null || refineries.size() > this.currentRecipe.outputs.length) {
            value = 0;
        } else {
            int n = value = didWork ? 15 : 0;
        }
        if (value != this.comparatorValue) {
            this.comparatorValue = value;
            this.func_145831_w().func_175666_e(this.func_174877_v(), this.func_145838_q());
        }
    }

    @Override
    public int getComparatorValue() {
        return this.getMasterRefinery().comparatorValue;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.refineryFluidHandler);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    @Nonnull
    public Map<String, FluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"OilTank", (Object)((Object)this.inputTank), (Object)"OutputTank", (Object)((Object)this.outputTank));
    }

    @Override
    public void updateScaledFluidAmount(int tankIndex, int amount) {
        if (tankIndex == 1) {
            this.inputAmountScaled = amount;
        } else if (tankIndex == 2) {
            this.outputAmountScaled = amount;
        }
    }

    private class RefineryFluidHandler
    implements IFluidHandler {
        private RefineryFluidHandler() {
        }

        public IFluidTankProperties[] getTankProperties() {
            return (IFluidTankProperties[])ArrayUtils.addAll((Object[])TileEntityRefinery.this.getMasterRefinery().inputTank.getTankProperties(), (Object[])TileEntityRefinery.this.outputTank.getTankProperties());
        }

        public int fill(FluidStack resource, boolean doFill) {
            return TileEntityRefinery.this.getMasterRefinery().inputTank.fill(resource, doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return TileEntityRefinery.this.outputTank.drain(resource, doDrain);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return TileEntityRefinery.this.outputTank.drain(maxDrain, doDrain);
        }
    }

    private class RefineryInputTank
    extends ISmartFluidSync.SmartSyncTank {
        private Fluid prevFluid;

        RefineryInputTank(int capacity) {
            super(TileEntityRefinery.this, capacity, 1);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return this.getFluid() != null && this.getFluid().isFluidEqual(fluid) || TileEntityRefinery.isInputFluidValid(fluid.getFluid(), 4);
        }

        @Override
        protected void onContentsChanged() {
            Fluid newFluid;
            super.onContentsChanged();
            Fluid fluid = newFluid = this.getFluid() == null ? null : this.getFluid().getFluid();
            if (this.prevFluid != newFluid) {
                TileEntityRefinery.this.searchForRecipe = true;
                this.prevFluid = newFluid;
            }
        }
    }
}

