/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAdvancedAirCompressor;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityPneumaticDynamo
extends TileEntityPneumaticBase
implements IRedstoneControlled,
IHeatExchanger,
IMinWorkingPressure {
    private final PneumaticEnergyStorage energy = new PneumaticEnergyStorage(100000);
    @GuiSynced
    private int rfPerTick;
    @GuiSynced
    private int airPerTick;
    @DescSynced
    public boolean isEnabled;
    @GuiSynced
    private int redstoneMode;
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().getHeatExchangerLogic();

    public TileEntityPneumaticDynamo() {
        this(20.0f, 25.0f, 10000, 4);
    }

    public TileEntityPneumaticDynamo(float dangerPressure, float criticalPressure, int volume, int upgradeSlots) {
        super(dangerPressure, criticalPressure, volume, upgradeSlots);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.SPEED);
        this.heatExchanger.setThermalCapacity(100.0);
    }

    public int getEfficiency() {
        return TileEntityAdvancedAirCompressor.getEfficiency(this.heatExchanger.getTemperature());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            int extracted;
            IEnergyStorage neighborStorage;
            int energyPushed;
            TileEntity receiver;
            boolean newEnabled;
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                int efficiency = ConfigHandler.machineProperties.pneumaticDynamoEfficiency;
                if (efficiency < 1) {
                    efficiency = 1;
                }
                this.airPerTick = (int)(40.0f * this.getSpeedUsageMultiplierFromUpgrades() * 100.0f / (float)efficiency);
                this.rfPerTick = (int)(40.0f * this.getSpeedUsageMultiplierFromUpgrades() * (float)this.getEfficiency() / 100.0f);
            }
            if (this.redstoneAllows() && this.getPressure() > 15.0f && this.energy.getMaxEnergyStored() - this.energy.getEnergyStored() >= this.rfPerTick) {
                this.addAir(-this.airPerTick);
                this.heatExchanger.addHeat((double)this.airPerTick / 100.0);
                this.energy.receiveEnergy(this.rfPerTick, false);
                newEnabled = true;
            } else {
                newEnabled = false;
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L && newEnabled != this.isEnabled) {
                this.isEnabled = newEnabled;
                this.sendDescriptionPacket();
            }
            if ((receiver = this.getTileCache()[this.getRotation().ordinal()].getTileEntity()) != null && receiver.hasCapability(CapabilityEnergy.ENERGY, this.getRotation().func_176734_d()) && (energyPushed = (neighborStorage = (IEnergyStorage)receiver.getCapability(CapabilityEnergy.ENERGY, this.getRotation().func_176734_d())).receiveEnergy(extracted = this.energy.extractEnergy(this.rfPerTick * 2, true), true)) > 0) {
                neighborStorage.receiveEnergy(this.energy.extractEnergy(energyPushed, false), false);
            }
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0 && ++this.redstoneMode > 2) {
            this.redstoneMode = 0;
        }
    }

    @Override
    public String getName() {
        return Blockss.PNEUMATIC_DYNAMO.func_149739_a();
    }

    @Override
    public boolean isConnectedTo(EnumFacing side) {
        return side == this.getRotation().func_176734_d();
    }

    @Override
    public float getMinWorkingPressure() {
        return 15.0f;
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(EnumFacing side) {
        return this.heatExchanger;
    }

    public int getRFRate() {
        return this.rfPerTick;
    }

    public int getAirRate() {
        return this.airPerTick;
    }

    public int getInfoEnergyStored() {
        return this.energy.getEnergyStored();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY && (facing == this.getRotation() || facing == null) || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityEnergy.ENERGY && (facing == this.getRotation() || facing == null) ? CapabilityEnergy.ENERGY.cast((Object)this.energy) : super.getCapability(capability, facing));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.energy.writeToNBT(tag);
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.energy.readFromNBT(tag);
        this.redstoneMode = tag.func_74771_c("redstoneMode");
    }
}

