/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.tileentity.IAssemblyMachine;
import me.desht.pneumaticcraft.common.tileentity.IResettable;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyPlatform;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityAssemblyRobot
extends TileEntityTickableBase
implements IAssemblyMachine,
IResettable {
    public final float[] oldAngles = new float[5];
    @DescSynced
    @LazySynced
    public final float[] angles = new float[5];
    @DescSynced
    final float[] targetAngles = new float[5];
    EnumFacing[] targetDirection = new EnumFacing[]{null, null};
    @DescSynced
    boolean slowMode;
    @DescSynced
    protected float speed = 1.0f;

    public TileEntityAssemblyRobot() {
        this.gotoHomePosition();
        for (int i = 0; i < 5; ++i) {
            this.angles[i] = this.targetAngles[i];
            this.oldAngles[i] = this.targetAngles[i];
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        System.arraycopy(this.angles, 0, this.oldAngles, 0, 5);
        for (int i = 0; i < 5; ++i) {
            if (this.angles[i] > this.targetAngles[i]) {
                this.angles[i] = Math.max(this.angles[i] - 1.0f * (this.slowMode ? 0.1f : 1.0f) * this.speed, this.targetAngles[i]);
                continue;
            }
            if (!(this.angles[i] < this.targetAngles[i])) continue;
            this.angles[i] = Math.min(this.angles[i] + 1.0f * (this.slowMode ? 0.1f : 1.0f) * this.speed, this.targetAngles[i]);
        }
    }

    public void gotoHomePosition() {
        this.targetAngles[EnumAngles.TURN.ordinal()] = 0.0f;
        this.targetAngles[EnumAngles.BASE.ordinal()] = 0.0f;
        this.targetAngles[EnumAngles.MIDDLE.ordinal()] = 55.0f;
        this.targetAngles[EnumAngles.TAIL.ordinal()] = 35.0f;
        this.targetAngles[EnumAngles.HEAD.ordinal()] = 0.0f;
    }

    public boolean gotoTarget() {
        if (this.targetDirection == null) {
            return false;
        }
        this.gotoNeighbour(this.targetDirection[0], this.targetDirection[1]);
        return this.isDoneMoving();
    }

    public void gotoNeighbour(EnumFacing direction) {
        this.gotoNeighbour(direction, null);
    }

    public boolean gotoNeighbour(EnumFacing primaryDir, EnumFacing secondaryDir) {
        this.targetDirection = new EnumFacing[]{primaryDir, secondaryDir};
        boolean diagonal = true;
        boolean diagonalAllowed = this.canMoveToDiagonalNeighbours();
        switch (primaryDir) {
            case SOUTH: {
                if (secondaryDir == EnumFacing.EAST && diagonalAllowed) {
                    this.targetAngles[EnumAngles.TURN.ordinal()] = -45.0f;
                    this.targetAngles[EnumAngles.HEAD.ordinal()] = 40.0f;
                    break;
                }
                if (secondaryDir == EnumFacing.WEST && diagonalAllowed) {
                    this.targetAngles[EnumAngles.TURN.ordinal()] = 45.0f;
                    this.targetAngles[EnumAngles.HEAD.ordinal()] = -40.0f;
                    break;
                }
                this.targetAngles[EnumAngles.TURN.ordinal()] = 0.0f;
                this.targetAngles[EnumAngles.HEAD.ordinal()] = 90.0f;
                diagonal = false;
                break;
            }
            case EAST: {
                this.targetAngles[EnumAngles.TURN.ordinal()] = -90.0f;
                this.targetAngles[EnumAngles.HEAD.ordinal()] = 0.0f;
                diagonal = false;
                break;
            }
            case NORTH: {
                if (secondaryDir == EnumFacing.EAST && diagonalAllowed) {
                    this.targetAngles[EnumAngles.TURN.ordinal()] = -135.0f;
                    this.targetAngles[EnumAngles.HEAD.ordinal()] = -40.0f;
                    break;
                }
                if (secondaryDir == EnumFacing.WEST && diagonalAllowed) {
                    this.targetAngles[EnumAngles.TURN.ordinal()] = 135.0f;
                    this.targetAngles[EnumAngles.HEAD.ordinal()] = 40.0f;
                    break;
                }
                this.targetAngles[EnumAngles.TURN.ordinal()] = 180.0f;
                this.targetAngles[EnumAngles.HEAD.ordinal()] = 90.0f;
                diagonal = false;
                break;
            }
            case WEST: {
                this.targetAngles[EnumAngles.TURN.ordinal()] = 90.0f;
                this.targetAngles[EnumAngles.HEAD.ordinal()] = 0.0f;
                diagonal = false;
            }
        }
        if (diagonal) {
            this.targetAngles[EnumAngles.BASE.ordinal()] = 160.0f;
            this.targetAngles[EnumAngles.MIDDLE.ordinal()] = -85.0f;
            this.targetAngles[EnumAngles.TAIL.ordinal()] = -20.0f;
        } else {
            this.targetAngles[EnumAngles.BASE.ordinal()] = 100.0f;
            this.targetAngles[EnumAngles.MIDDLE.ordinal()] = -10.0f;
            this.targetAngles[EnumAngles.TAIL.ordinal()] = 0.0f;
        }
        return diagonal;
    }

    public boolean hoverOverTarget() {
        if (this.targetDirection == null) {
            return false;
        }
        return this.hoverOverNeighbour(this.targetDirection);
    }

    public boolean hoverOverNeighbour(EnumFacing[] directions) {
        this.hoverOverNeighbour(directions[0], directions[1]);
        return this.isDoneMoving();
    }

    public void hoverOverNeighbour(EnumFacing primaryDir, EnumFacing secondaryDir) {
        boolean diagonal = this.gotoNeighbour(primaryDir, secondaryDir);
        if (diagonal) {
            this.targetAngles[EnumAngles.BASE.ordinal()] = 160.0f;
            this.targetAngles[EnumAngles.MIDDLE.ordinal()] = -95.0f;
            this.targetAngles[EnumAngles.TAIL.ordinal()] = -10.0f;
        } else {
            this.targetAngles[EnumAngles.BASE.ordinal()] = 100.0f;
            this.targetAngles[EnumAngles.MIDDLE.ordinal()] = -20.0f;
            this.targetAngles[EnumAngles.TAIL.ordinal()] = 10.0f;
        }
    }

    public TileEntity getTileEntityForCurrentDirection() {
        return this.getTileEntityForDirection(this.targetDirection[0], this.targetDirection[1]);
    }

    public TileEntity getTileEntityForDirection(EnumFacing[] directions) {
        return this.getTileEntityForDirection(directions[0], directions[1]);
    }

    public TileEntity getTileEntityForDirection(EnumFacing firstDir, EnumFacing secondDir) {
        return this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(firstDir).func_177967_a(secondDir, secondDir != null ? 1 : 0));
    }

    protected boolean isDoneMoving() {
        for (int i = 0; i < 5; ++i) {
            if (PneumaticCraftUtils.areFloatsEqual(this.angles[i], this.targetAngles[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isDoneRotatingYaw() {
        return PneumaticCraftUtils.areFloatsEqual(this.angles[EnumAngles.TURN.ordinal()], this.targetAngles[EnumAngles.TURN.ordinal()]);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < 5; ++i) {
            this.angles[i] = tag.func_74760_g("angle" + i);
            this.targetAngles[i] = tag.func_74760_g("targetAngle" + i);
        }
        this.slowMode = tag.func_74767_n("slowMode");
        this.speed = tag.func_74760_g("speed");
        this.targetDirection[0] = tag.func_74764_b("targetDir1") ? EnumFacing.field_82609_l[tag.func_74762_e("targetDir1")] : null;
        this.targetDirection[1] = tag.func_74764_b("targetDir2") ? EnumFacing.field_82609_l[tag.func_74762_e("targetDir2")] : null;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        for (int i = 0; i < 5; ++i) {
            tag.func_74776_a("angle" + i, this.angles[i]);
            tag.func_74776_a("targetAngle" + i, this.targetAngles[i]);
        }
        tag.func_74757_a("slowMode", this.slowMode);
        tag.func_74776_a("speed", this.speed);
        if (this.targetDirection != null) {
            if (this.targetDirection[0] != null) {
                tag.func_74768_a("targetDir1", this.targetDirection[0].ordinal());
            }
            if (this.targetDirection[1] != null) {
                tag.func_74768_a("targetDir2", this.targetDirection[1].ordinal());
            }
        }
        return tag;
    }

    public abstract boolean canMoveToDiagonalNeighbours();

    public EnumFacing[] getPlatformDirection() {
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            if (!(this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(dir)) instanceof TileEntityAssemblyPlatform)) continue;
            return new EnumFacing[]{dir, null};
        }
        if (this.canMoveToDiagonalNeighbours()) {
            for (EnumFacing secDir : new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST}) {
                for (EnumFacing primDir : new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH}) {
                    if (!(this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(primDir).func_177972_a(secDir)) instanceof TileEntityAssemblyPlatform)) continue;
                    return new EnumFacing[]{primDir, secDir};
                }
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 1), (double)(this.func_174877_v().func_177956_o() - 1), (double)(this.func_174877_v().func_177952_p() - 1), (double)(this.func_174877_v().func_177958_n() + 2), (double)(this.func_174877_v().func_177956_o() + 2), (double)(this.func_174877_v().func_177952_p() + 2));
    }

    @Override
    public void setSpeed(float speed) {
        this.speed = speed;
    }

    protected static enum EnumAngles {
        TURN,
        BASE,
        MIDDLE,
        TAIL,
        HEAD;

    }
}

