/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.tileentity.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.tileentity.IAssemblyMachine;
import me.desht.pneumaticcraft.common.tileentity.IResettable;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityAssemblyPlatform
extends TileEntityTickableBase
implements IAssemblyMachine,
IResettable {
    @DescSynced
    private boolean shouldClawClose;
    @DescSynced
    @LazySynced
    public float clawProgress;
    public float oldClawProgress;
    @DescSynced
    private final ItemStackHandler inventory = new BaseItemStackHandler(this, 1);
    private float speed = 1.0f;
    boolean hasDrilledStack;
    boolean hasLaseredStack;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.oldClawProgress = this.clawProgress;
        if (!this.shouldClawClose && this.clawProgress > 0.0f) {
            this.clawProgress = Math.max(this.clawProgress - 0.05f * this.speed, 0.0f);
        } else if (this.shouldClawClose && this.clawProgress < 1.0f) {
            this.clawProgress = Math.min(this.clawProgress + 0.05f * this.speed, 1.0f);
        }
    }

    private boolean isClawDone() {
        return this.clawProgress == (this.shouldClawClose ? 1.0f : 0.0f);
    }

    @Override
    public boolean isIdle() {
        return !this.shouldClawClose && this.isClawDone() && this.getHeldStack().func_190926_b();
    }

    @Override
    public boolean reset() {
        this.openClaw();
        return this.isIdle();
    }

    public boolean closeClaw() {
        this.hasDrilledStack = false;
        this.hasLaseredStack = false;
        this.shouldClawClose = true;
        this.sendDescriptionPacket();
        return this.isClawDone();
    }

    public boolean openClaw() {
        this.shouldClawClose = false;
        this.sendDescriptionPacket();
        return this.isClawDone();
    }

    @Nonnull
    public ItemStack getHeldStack() {
        return this.inventory.getStackInSlot(0);
    }

    public void setHeldStack(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            this.hasDrilledStack = false;
            this.hasLaseredStack = false;
        }
        this.inventory.setStackInSlot(0, stack);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("clawClosing", this.shouldClawClose);
        tag.func_74776_a("clawProgress", this.clawProgress);
        tag.func_74776_a("speed", this.speed);
        tag.func_74757_a("drilled", this.hasDrilledStack);
        tag.func_74757_a("lasered", this.hasLaseredStack);
        tag.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.shouldClawClose = tag.func_74767_n("clawClosing");
        this.clawProgress = tag.func_74760_g("clawProgress");
        this.speed = tag.func_74760_g("speed");
        this.hasDrilledStack = tag.func_74767_n("drilled");
        this.hasLaseredStack = tag.func_74767_n("lasered");
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
    }

    @Override
    public void setSpeed(float speed) {
        this.speed = speed;
    }
}

