/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.PneumaticCraftAPIHandler;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IComparatorSupport;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.ISideConfigurable;
import me.desht.pneumaticcraft.common.tileentity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.tileentity.SideConfigurator;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.EnchantmentUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerArmorInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.items.wrapper.PlayerOffhandInvWrapper;

public class TileEntityAerialInterface
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
IRedstoneControl,
IComparatorSupport,
ISideConfigurable {
    private static final int ENERGY_CAPACITY = 100000;
    private static final int RF_PER_TICK = 1000;
    @GuiSynced
    @DescSynced
    public String playerName = "";
    @DescSynced
    private String playerUUID = "";
    private Fluid curXpFluid;
    @DescSynced
    public int curXPFluidIndex = -1;
    @GuiSynced
    public int redstoneMode;
    @GuiSynced
    public int feedMode = 0;
    private boolean oldRedstoneStatus;
    private boolean updateNeighbours;
    @GuiSynced
    public boolean isConnectedToPlayer = false;
    private boolean dispenserUpgradeInserted;
    private final SideConfigurator<IItemHandler> itemHandlerSideConfigurator;
    private final PlayerExperienceHandler playerExperienceHandler;
    private final PlayerFoodHandler playerFoodHandler;
    private WeakReference<EntityPlayer> playerRef = new WeakReference<Object>(null);
    private final PneumaticEnergyStorage energyStorage;
    private final List<Integer> chargeableSlots = new ArrayList<Integer>();
    private static final List<String> REDSTONE_LABELS = ImmutableList.of((Object)"gui.tab.redstoneBehaviour.button.never", (Object)"gui.tab.redstoneBehaviour.aerialInterface.button.playerConnected");

    public TileEntityAerialInterface() {
        super(20.0f, 25.0f, 4000, 4);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.DISPENSER);
        PlayerMainInvHandler playerMainInvHandler = new PlayerMainInvHandler();
        PlayerArmorInvHandler playerArmorInvHandler = new PlayerArmorInvHandler();
        PlayerOffhandInvHandler playerOffhandInvHandler = new PlayerOffhandInvHandler();
        PlayerEnderInvHandler playerEnderInvHandler = new PlayerEnderInvHandler();
        this.playerExperienceHandler = new PlayerExperienceHandler();
        this.playerFoodHandler = new PlayerFoodHandler();
        this.itemHandlerSideConfigurator = new SideConfigurator("items", this, 5);
        this.itemHandlerSideConfigurator.registerHandler("mainInv", new ItemStack((Block)Blocks.field_150486_ae), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (IItemHandler)playerMainInvHandler, SideConfigurator.RelativeFace.FRONT, SideConfigurator.RelativeFace.BACK, SideConfigurator.RelativeFace.LEFT, SideConfigurator.RelativeFace.RIGHT);
        this.itemHandlerSideConfigurator.registerHandler("armorInv", new ItemStack(Itemss.PNEUMATIC_CHESTPLATE), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (IItemHandler)playerArmorInvHandler, SideConfigurator.RelativeFace.TOP, SideConfigurator.RelativeFace.BOTTOM);
        this.itemHandlerSideConfigurator.registerHandler("offhandInv", new ItemStack(Items.field_185159_cQ), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (IItemHandler)playerOffhandInvHandler, new SideConfigurator.RelativeFace[0]);
        this.itemHandlerSideConfigurator.registerHandler("enderInv", new ItemStack(Blocks.field_150477_bB), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (IItemHandler)playerEnderInvHandler, new SideConfigurator.RelativeFace[0]);
        this.energyStorage = new PneumaticEnergyStorage(100000);
    }

    public void setPlayer(EntityPlayer player) {
        this.playerRef = new WeakReference<EntityPlayer>(player);
        boolean old = this.isConnectedToPlayer;
        if (player == null) {
            this.isConnectedToPlayer = false;
        } else {
            this.setPlayer(player.func_146103_bH().getName(), player.func_146103_bH().getId().toString());
            this.isConnectedToPlayer = true;
        }
        if (old != this.isConnectedToPlayer) {
            this.updateNeighbours = true;
            this.scanForChargeableItems();
        }
    }

    private void setPlayer(String username, String uuid) {
        if (!this.playerUUID.equals(uuid)) {
            this.updateNeighbours = true;
        }
        this.playerName = username;
        this.playerUUID = uuid;
    }

    @Override
    protected void onUpgradesChanged() {
        super.onUpgradesChanged();
        boolean old = this.dispenserUpgradeInserted;
        boolean bl = this.dispenserUpgradeInserted = this.getUpgrades(IItemRegistry.EnumUpgrade.DISPENSER) > 0;
        if (old != this.dispenserUpgradeInserted) {
            this.updateNeighbours = true;
        }
    }

    @Override
    protected void onFirstServerUpdate() {
        super.onFirstServerUpdate();
        SideConfigurator.validateBlockRotation(this);
    }

    @Override
    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K && this.updateNeighbours) {
            this.updateNeighbours = false;
            this.updateNeighbours();
        }
        if (!this.func_145831_w().field_72995_K) {
            if (this.getPressure() > 10.0f && this.isConnectedToPlayer) {
                EntityPlayer player;
                this.addAir(-1);
                if ((this.func_145831_w().func_82737_E() & 0x3FL) == 0L) {
                    this.scanForChargeableItems();
                }
                this.supplyEnergyToPlayer();
                if ((this.func_145831_w().func_82737_E() & 0xFL) == 0L && (player = this.getPlayer()) != null && player.func_70086_ai() <= 280) {
                    player.func_70050_g(player.func_70086_ai() + 16);
                    this.addAir(-80);
                }
            }
            if ((this.func_145831_w().func_82737_E() & 0xFL) == 0L && !this.playerUUID.isEmpty()) {
                this.setPlayer(PneumaticCraftUtils.getPlayerFromId(this.playerUUID));
            }
        }
        if (this.oldRedstoneStatus != this.shouldEmitRedstone()) {
            this.oldRedstoneStatus = this.shouldEmitRedstone();
            this.updateNeighbours = true;
        }
        super.func_73660_a();
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 1) {
                this.redstoneMode = 0;
            }
        } else if (buttonID >= 1 && buttonID < 4) {
            this.feedMode = buttonID - 1;
        } else if (buttonID == 4) {
            ++this.curXPFluidIndex;
            List<Fluid> available = PneumaticCraftAPIHandler.getInstance().availableLiquidXPs;
            if (this.curXPFluidIndex >= available.size()) {
                this.curXPFluidIndex = -1;
            }
            this.curXpFluid = this.curXPFluidIndex >= 0 && this.curXPFluidIndex < available.size() ? available.get(this.curXPFluidIndex) : null;
        } else if (this.itemHandlerSideConfigurator.handleButtonPress(buttonID)) {
            this.updateNeighbours = true;
        }
    }

    public boolean shouldEmitRedstone() {
        switch (this.redstoneMode) {
            case 0: {
                return false;
            }
            case 1: {
                return this.isConnectedToPlayer;
            }
        }
        return false;
    }

    private EntityPlayer getPlayer() {
        return (EntityPlayer)this.playerRef.get();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return (this.isConnectedToPlayer && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.dispenserUpgradeInserted && this.curXpFluid != null || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) && this.itemHandlerSideConfigurator.getHandler(facing) != null || capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.dispenserUpgradeInserted) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.playerFoodHandler);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandlerSideConfigurator.getHandler(facing));
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.dispenserUpgradeInserted && this.curXpFluid != null) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.playerExperienceHandler);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyStorage);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public String getName() {
        return Blockss.AERIAL_INTERFACE.func_149739_a();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.feedMode = tag.func_74762_e("feedMode");
        this.setPlayer(tag.func_74779_i("playerName"), tag.func_74779_i("playerUUID"));
        this.curXpFluid = tag.func_74764_b("curXpFluid") ? FluidRegistry.getFluid((String)tag.func_74779_i("curXpFluid")) : null;
        this.energyStorage.readFromNBT(tag);
        this.curXPFluidIndex = this.curXpFluid == null ? -1 : PneumaticCraftAPIHandler.getInstance().availableLiquidXPs.indexOf(this.curXpFluid);
        this.dispenserUpgradeInserted = this.getUpgrades(IItemRegistry.EnumUpgrade.DISPENSER) > 0;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74768_a("feedMode", this.feedMode);
        tag.func_74778_a("playerName", this.playerName);
        tag.func_74778_a("playerUUID", this.playerUUID);
        if (this.curXpFluid != null) {
            tag.func_74778_a("curXpFluid", this.curXpFluid.getName());
        }
        this.energyStorage.writeToNBT(tag);
        return tag;
    }

    @Override
    public float getMinWorkingPressure() {
        return 10.0f;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public int getComparatorValue() {
        return this.shouldEmitRedstone() ? 15 : 0;
    }

    private void scanForChargeableItems() {
        this.chargeableSlots.clear();
        if (this.isConnectedToPlayer) {
            InventoryPlayer inv = ((EntityPlayer)this.playerRef.get()).field_71071_by;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (!inv.func_70301_a(i).hasCapability(CapabilityEnergy.ENERGY, null)) continue;
                this.chargeableSlots.add(i);
            }
        }
    }

    private void supplyEnergyToPlayer() {
        if (!this.isConnectedToPlayer) {
            return;
        }
        InventoryPlayer inv = ((EntityPlayer)this.playerRef.get()).field_71071_by;
        for (int slot : this.chargeableSlots) {
            ItemStack stack = inv.func_70301_a(slot);
            if (!stack.hasCapability(CapabilityEnergy.ENERGY, null)) continue;
            IEnergyStorage receivingStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            int energyLeft = this.energyStorage.getEnergyStored();
            if (energyLeft > 0) {
                this.energyStorage.extractEnergy(receivingStorage.receiveEnergy(Math.min(energyLeft, 1000), false), false);
            }
            if (this.energyStorage.getEnergyStored() != 0) continue;
            break;
        }
    }

    @Override
    protected List<String> getRedstoneButtonLabels() {
        return REDSTONE_LABELS;
    }

    @Override
    public List<SideConfigurator> getSideConfigurators() {
        return Collections.singletonList(this.itemHandlerSideConfigurator);
    }

    @Override
    public EnumFacing byIndex() {
        return this.getRotation();
    }

    private class PlayerExperienceHandler
    implements IFluidHandler {
        private PlayerExperienceHandler() {
        }

        public IFluidTankProperties[] getTankProperties() {
            EntityPlayer player;
            if (TileEntityAerialInterface.this.curXpFluid != null && (player = TileEntityAerialInterface.this.getPlayer()) != null) {
                return new FluidTankProperties[]{new FluidTankProperties(new FluidStack(TileEntityAerialInterface.this.curXpFluid, EnchantmentUtils.getPlayerXP(player) * PneumaticCraftAPIHandler.getInstance().liquidXPs.get(TileEntityAerialInterface.this.curXpFluid)), Integer.MAX_VALUE)};
            }
            return null;
        }

        public int fill(FluidStack resource, boolean doFill) {
            EntityPlayer player;
            if (resource != null && this.canFill(resource.getFluid()) && (player = TileEntityAerialInterface.this.getPlayer()) != null) {
                int liquidToXP = PneumaticCraftAPIHandler.getInstance().liquidXPs.get(resource.getFluid());
                int pointsAdded = resource.amount / liquidToXP;
                if (doFill) {
                    player.func_71023_q(pointsAdded);
                }
                return pointsAdded * liquidToXP;
            }
            return 0;
        }

        private boolean canFill(Fluid fluid) {
            return TileEntityAerialInterface.this.dispenserUpgradeInserted && fluid != null && fluid == TileEntityAerialInterface.this.curXpFluid && PneumaticCraftAPIHandler.getInstance().liquidXPs.containsKey(fluid) && TileEntityAerialInterface.this.getPlayer() != null && TileEntityAerialInterface.this.getPressure() > 10.0f;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            EntityPlayer player;
            if (resource != null && this.canDrain(resource.getFluid()) && (player = TileEntityAerialInterface.this.getPlayer()) != null) {
                int liquidToXP = PneumaticCraftAPIHandler.getInstance().liquidXPs.get(resource.getFluid());
                int pointsDrained = Math.min(EnchantmentUtils.getPlayerXP(player), resource.amount / liquidToXP);
                if (doDrain) {
                    EnchantmentUtils.addPlayerXP(player, -pointsDrained);
                }
                return new FluidStack(resource.getFluid(), pointsDrained * liquidToXP);
            }
            return null;
        }

        private boolean canDrain(Fluid fluid) {
            return TileEntityAerialInterface.this.dispenserUpgradeInserted && (fluid == null || PneumaticCraftAPIHandler.getInstance().liquidXPs.containsKey(fluid)) && TileEntityAerialInterface.this.getPlayer() != null && TileEntityAerialInterface.this.getPressure() > 10.0f;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (TileEntityAerialInterface.this.curXpFluid == null) {
                return null;
            }
            return this.drain(new FluidStack(TileEntityAerialInterface.this.curXpFluid, maxDrain), doDrain);
        }
    }

    private class PlayerFoodHandler
    implements IItemHandler {
        private PlayerFoodHandler() {
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            EntityPlayer player = TileEntityAerialInterface.this.getPlayer();
            if (player == null || this.getFoodValue(stack) <= 0) {
                return stack;
            }
            if (!this.okToFeed(stack, player)) {
                return stack;
            }
            if (simulate) {
                return ItemStack.field_190927_a;
            }
            int startValue = stack.func_190916_E();
            ItemStack remainingItem = stack;
            while (stack.func_190916_E() > 0) {
                remainingItem = stack.func_77950_b(player.field_70170_p, (EntityLivingBase)player);
                if (!((remainingItem = ForgeEventFactory.onItemUseFinish((EntityLivingBase)player, (ItemStack)stack, (int)0, (ItemStack)remainingItem)).func_190916_E() <= 0 || remainingItem == stack && remainingItem.func_190916_E() == startValue || player.field_71071_by.func_70441_a(remainingItem) || remainingItem.func_190916_E() <= 0)) {
                    player.func_71019_a(remainingItem, false);
                }
                if (stack.func_190916_E() != startValue) continue;
            }
            return remainingItem.func_190916_E() > 0 ? remainingItem : ItemStack.field_190927_a;
        }

        private boolean okToFeed(@Nonnull ItemStack stack, EntityPlayer player) {
            int foodValue = this.getFoodValue(stack);
            int curFoodLevel = player.func_71024_bL().func_75116_a();
            int tmpFeedMode = TileEntityAerialInterface.this.feedMode;
            if (tmpFeedMode == 2) {
                tmpFeedMode = player.func_110138_aP() - player.func_110143_aJ() > 0.0f ? 1 : 0;
            }
            switch (tmpFeedMode) {
                case 0: {
                    return 20 - curFoodLevel >= foodValue * stack.func_190916_E();
                }
                case 1: {
                    return 20 - curFoodLevel >= foodValue * (stack.func_190916_E() - 1) + 1;
                }
            }
            return false;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        private int getFoodValue(ItemStack item) {
            return item.func_77973_b() instanceof ItemFood ? ((ItemFood)item.func_77973_b()).func_150905_g(item) : 0;
        }
    }

    private class PlayerEnderInvHandler
    extends PlayerInvHandler {
        private PlayerEnderInvHandler() {
        }

        @Override
        protected IItemHandler getInvWrapper() {
            return new InvWrapper((IInventory)TileEntityAerialInterface.this.getPlayer().func_71005_bN());
        }
    }

    private class PlayerOffhandInvHandler
    extends PlayerInvHandler {
        private PlayerOffhandInvHandler() {
        }

        @Override
        protected IItemHandler getInvWrapper() {
            return new PlayerOffhandInvWrapper(((TileEntityAerialInterface)TileEntityAerialInterface.this).getPlayer().field_71071_by);
        }
    }

    private class PlayerArmorInvHandler
    extends PlayerInvHandler {
        private PlayerArmorInvHandler() {
        }

        @Override
        protected IItemHandler getInvWrapper() {
            return new PlayerArmorInvWrapper(((TileEntityAerialInterface)TileEntityAerialInterface.this).getPlayer().field_71071_by);
        }
    }

    private class PlayerMainInvHandler
    extends PlayerInvHandler {
        private PlayerMainInvHandler() {
        }

        @Override
        protected IItemHandler getInvWrapper() {
            return new PlayerMainInvWrapper(((TileEntityAerialInterface)TileEntityAerialInterface.this).getPlayer().field_71071_by);
        }
    }

    private abstract class PlayerInvHandler
    implements IItemHandler {
        private PlayerInvHandler() {
        }

        protected abstract IItemHandler getInvWrapper();

        public int getSlots() {
            return TileEntityAerialInterface.this.playerRef.get() == null ? 0 : this.getInvWrapper().getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return TileEntityAerialInterface.this.playerRef.get() == null ? ItemStack.field_190927_a : this.getInvWrapper().getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return TileEntityAerialInterface.this.playerRef.get() == null ? stack : this.getInvWrapper().insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return TileEntityAerialInterface.this.playerRef.get() == null ? ItemStack.field_190927_a : this.getInvWrapper().extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return TileEntityAerialInterface.this.playerRef.get() == null ? 1 : this.getInvWrapper().getSlotLimit(slot);
        }
    }
}

