/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidTank;

public interface ISerializableTanks {
    public static final String SAVED_TANKS = "SavedTanks";

    @Nonnull
    public Map<String, FluidTank> getSerializableTanks();

    default public void deserializeTanks(NBTTagCompound tag) {
        for (Map.Entry<String, FluidTank> entry : this.getSerializableTanks().entrySet()) {
            entry.getValue().readFromNBT(tag.func_74775_l(entry.getKey()));
        }
    }

    default public void serializeTanks(ItemStack customDrop) {
        for (Map.Entry<String, FluidTank> entry : this.getSerializableTanks().entrySet()) {
            ISerializableTanks.serializeTank(entry.getValue(), customDrop, entry.getKey());
        }
    }

    public static void serializeTank(FluidTank tank, ItemStack stack, String tagName) {
        NBTTagCompound tag;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(tag = stack.func_77978_p()).func_150297_b(SAVED_TANKS, 10)) {
            tag.func_74782_a(SAVED_TANKS, (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound subTag = tag.func_74775_l(SAVED_TANKS);
        if (tank.getFluid() != null && tank.getFluid().amount > 0) {
            NBTTagCompound tankTag = new NBTTagCompound();
            tank.writeToNBT(tankTag);
            subTag.func_74782_a(tagName, (NBTBase)tankTag);
        } else {
            subTag.func_82580_o(tagName);
        }
        if (subTag.func_186856_d() == 0) {
            tag.func_82580_o(SAVED_TANKS);
            if (tag.func_186856_d() == 0) {
                stack.func_77982_d(null);
            }
        }
    }

    public static FluidTank deserializeTank(ItemStack stack, String tagName, int capacity) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b(SAVED_TANKS, 10)) {
            FluidTank tank = new FluidTank(capacity);
            NBTTagCompound subTag = stack.func_77978_p().func_74775_l(SAVED_TANKS);
            return tank.readFromNBT(subTag.func_74775_l(tagName));
        }
        return null;
    }
}

