/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.computercraft;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.SimpleComponent;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.item.ItemProgrammingPuzzle;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketShowArea;
import me.desht.pneumaticcraft.common.network.PacketSpawnRing;
import me.desht.pneumaticcraft.common.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetString;
import me.desht.pneumaticcraft.common.progwidgets.WidgetRegistrator;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.DroneAICC;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.ILuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.ProgWidgetCC;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemDye;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="computercraft"), @Optional.Interface(iface="li.cil.oc.api.network.ManagedPeripheral", modid="opencomputers"), @Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")})
public class TileEntityDroneInterface
extends TileEntity
implements ITickable,
IPeripheral,
ManagedPeripheral,
SimpleComponent {
    private final List<IComputerAccess> attachedComputers = new ArrayList<IComputerAccess>();
    private final List<ILuaMethod> luaMethods = new ArrayList<ILuaMethod>();
    private EntityDrone drone;
    public float rotationYaw;
    public float rotationPitch = (float)Math.toRadians(-42.0);
    private final List<Integer> ringSendList = new ArrayList<Integer>();
    private int ringSendCooldown;
    private IProgWidget curAction;

    public void func_73660_a() {
        if (this.drone != null && this.drone.field_70128_L) {
            this.setDrone(null);
        }
        if (this.drone != null) {
            if (this.func_145831_w().field_72995_K) {
                double dx = this.drone.field_70165_t - ((double)this.func_174877_v().func_177958_n() + 0.5);
                double dy = this.drone.field_70163_u - ((double)this.func_174877_v().func_177956_o() + 0.5);
                double dz = this.drone.field_70161_v - ((double)this.func_174877_v().func_177952_p() + 0.5);
                float f3 = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                this.rotationYaw = (float)(-Math.atan2(dx, dz));
                this.rotationPitch = (float)(-Math.atan2(dy, f3));
            } else {
                if (this.ringSendCooldown > 0) {
                    --this.ringSendCooldown;
                }
                if (this.ringSendList.size() > 0 && this.ringSendCooldown <= 0) {
                    this.ringSendCooldown = this.ringSendList.size() > 10 ? 1 : 5;
                    NetworkHandler.sendToDimension(new PacketSpawnRing((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.8, (double)this.func_174877_v().func_177952_p() + 0.5, (Entity)this.drone, this.ringSendList.remove(0)), this.func_145831_w().field_73011_w.getDimension());
                }
            }
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("drone", this.drone != null ? this.drone.func_145782_y() : -1);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        Entity entity = this.func_145831_w().func_73045_a(tag.func_74762_e("drone"));
        this.drone = entity instanceof EntityDrone ? (EntityDrone)entity : null;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public TileEntityDroneInterface() {
        this.luaMethods.add(new LuaMethod("isConnectedToDrone"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    return new Object[]{TileEntityDroneInterface.this.drone != null};
                }
                throw new IllegalArgumentException("isConnectedToDrone doesn't take any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("getDronePressure"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    if (TileEntityDroneInterface.this.drone == null) {
                        throw new IllegalStateException("There's no connected Drone!");
                    }
                    return new Object[]{(double)TileEntityDroneInterface.this.drone.getPressure(null)};
                }
                throw new IllegalArgumentException("getDronePressure doesn't take any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("exitPiece"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    if (TileEntityDroneInterface.this.drone == null) {
                        throw new IllegalStateException("There's no connected Drone!");
                    }
                    TileEntityDroneInterface.this.setDrone(null);
                    return null;
                }
                throw new IllegalArgumentException("exitPiece doesn't take any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("getAllActions"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    ArrayList<String> actions = new ArrayList<String>();
                    for (IProgWidget widget : WidgetRegistrator.registeredWidgets) {
                        if (!widget.canBeRunByComputers(new EntityDrone(TileEntityDroneInterface.this.func_145831_w()), TileEntityDroneInterface.this.getWidget())) continue;
                        actions.add(widget.getWidgetString());
                    }
                    return new Object[]{this.getStringTable(actions)};
                }
                throw new IllegalArgumentException("getAllActions doesn't take any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("getDronePosition"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    return new Double[]{((TileEntityDroneInterface)TileEntityDroneInterface.this).drone.field_70165_t, ((TileEntityDroneInterface)TileEntityDroneInterface.this).drone.field_70163_u, ((TileEntityDroneInterface)TileEntityDroneInterface.this).drone.field_70161_v};
                }
                throw new IllegalArgumentException("getDronePosition doesn't take any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("setBlockOrder"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    String arg = (String)args[0];
                    for (IBlockOrdered.EnumOrder order : IBlockOrdered.EnumOrder.values()) {
                        if (!order.toString().equalsIgnoreCase(arg)) continue;
                        TileEntityDroneInterface.this.getWidget().setOrder(order);
                        return null;
                    }
                    throw new IllegalArgumentException("No valid order. Valid arguments:  'closest', 'highToLow' or 'lowToHigh'!");
                }
                throw new IllegalArgumentException("setBlockOrder takes one argument, 'closest', 'highToLow' or 'lowToHigh'!");
            }
        });
        this.luaMethods.add(new LuaMethod("getAreaTypes"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    return TileEntityDroneInterface.this.getWidget().getAreaTypes();
                }
                throw new IllegalArgumentException("getAreaTypes doesn't take any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("addArea"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 3) {
                    TileEntityDroneInterface.this.getWidget().addArea(((Double)args[0]).intValue(), ((Double)args[1]).intValue(), ((Double)args[2]).intValue());
                    TileEntityDroneInterface.this.messageToDrone(ProgWidgetArea.class);
                    return null;
                }
                if (args.length == 7) {
                    TileEntityDroneInterface.this.getWidget().addArea(((Double)args[0]).intValue(), ((Double)args[1]).intValue(), ((Double)args[2]).intValue(), ((Double)args[3]).intValue(), ((Double)args[4]).intValue(), ((Double)args[5]).intValue(), (String)args[6]);
                    TileEntityDroneInterface.this.messageToDrone(ProgWidgetArea.class);
                    return null;
                }
                throw new IllegalArgumentException("addArea either requires 3 arguments (x, y, z), or 7 (x1, y1, z1, x2, y2, z2, areaType)!");
            }
        });
        this.luaMethods.add(new LuaMethod("removeArea"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 3) {
                    TileEntityDroneInterface.this.getWidget().removeArea(((Double)args[0]).intValue(), ((Double)args[1]).intValue(), ((Double)args[2]).intValue());
                    TileEntityDroneInterface.this.messageToDrone(ProgWidgetArea.class);
                    return null;
                }
                if (args.length == 7) {
                    TileEntityDroneInterface.this.getWidget().removeArea(((Double)args[0]).intValue(), ((Double)args[1]).intValue(), ((Double)args[2]).intValue(), ((Double)args[3]).intValue(), ((Double)args[4]).intValue(), ((Double)args[5]).intValue(), (String)args[6]);
                    TileEntityDroneInterface.this.messageToDrone(ProgWidgetArea.class);
                    return null;
                }
                throw new IllegalArgumentException("removeArea either requires 3 arguments (x, y, z), or 7 (x1, y1, z1, x2, y2, z2, areaType)!");
            }
        });
        this.luaMethods.add(new LuaMethod("clearArea"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    TileEntityDroneInterface.this.getWidget().clearArea();
                    TileEntityDroneInterface.this.messageToDrone(ProgWidgetArea.class);
                    return null;
                }
                throw new IllegalArgumentException("clearArea doesn't take any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("showArea"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    HashSet<BlockPos> area = new HashSet<BlockPos>();
                    TileEntityDroneInterface.this.getWidget().getArea(area);
                    NetworkHandler.sendToDimension(new PacketShowArea(TileEntityDroneInterface.this.func_174877_v(), area), TileEntityDroneInterface.this.func_145831_w().field_73011_w.getDimension());
                    return null;
                }
                throw new IllegalArgumentException("showArea doesn't take any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("hideArea"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    NetworkHandler.sendToDimension(new PacketShowArea(TileEntityDroneInterface.this.func_174877_v(), new BlockPos[0]), TileEntityDroneInterface.this.func_145831_w().field_73011_w.getDimension());
                    return null;
                }
                throw new IllegalArgumentException("hideArea doesn't take any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("addWhitelistItemFilter"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 6) {
                    TileEntityDroneInterface.this.getWidget().addWhitelistItemFilter((String)args[0], ((Double)args[1]).intValue(), (Boolean)args[2], (Boolean)args[3], (Boolean)args[4], (Boolean)args[5]);
                    TileEntityDroneInterface.this.messageToDrone(ProgWidgetItemFilter.class);
                    return null;
                }
                throw new IllegalArgumentException("addWhitelistItemFilter takes 6 arguments (<string> item/block name, <number> item/block metadata, <bool> Use Metadata, <bool> Use NBT, <bool> Use Ore Dictionary, <bool> Use Mod Similarity)!");
            }
        });
        this.luaMethods.add(new LuaMethod("addBlacklistItemFilter"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 6) {
                    TileEntityDroneInterface.this.getWidget().addBlacklistItemFilter((String)args[0], ((Double)args[1]).intValue(), (Boolean)args[2], (Boolean)args[3], (Boolean)args[4], (Boolean)args[5]);
                    TileEntityDroneInterface.this.messageToDrone(ProgWidgetItemFilter.class);
                    return null;
                }
                throw new IllegalArgumentException("addBlacklistItemFilter takes 6 arguments (<string> item/block name, <number> item/block metadata, <bool> Use Metadata, <bool> Use NBT, <bool> Use Ore Dictionary, <bool> Use Mod Similarity)!");
            }
        });
        this.luaMethods.add(new LuaMethod("clearWhitelistItemFilter"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    TileEntityDroneInterface.this.getWidget().clearItemWhitelist();
                    TileEntityDroneInterface.this.messageToDrone(ProgWidgetItemFilter.class);
                    return null;
                }
                throw new IllegalArgumentException("clearWhitelistItemFilter doesn't take any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("clearBlacklistItemFilter"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    TileEntityDroneInterface.this.getWidget().clearItemBlacklist();
                    TileEntityDroneInterface.this.messageToDrone(ProgWidgetItemFilter.class);
                    return null;
                }
                throw new IllegalArgumentException("clearBlacklistItemFilter doesn't take any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("addWhitelistText"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityDroneInterface.this.getWidget().addWhitelistText((String)args[0]);
                    TileEntityDroneInterface.this.messageToDrone(ProgWidgetString.class);
                    return null;
                }
                throw new IllegalArgumentException("addWhitelistText takes one argument (text)!");
            }
        });
        this.luaMethods.add(new LuaMethod("addBlacklistText"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityDroneInterface.this.getWidget().addBlacklistText((String)args[0]);
                    TileEntityDroneInterface.this.messageToDrone(ProgWidgetString.class);
                    return null;
                }
                throw new IllegalArgumentException("addBlacklistText takes one argument (text)!");
            }
        });
        this.luaMethods.add(new LuaMethod("clearWhitelistText"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    TileEntityDroneInterface.this.getWidget().clearWhitelistText();
                    TileEntityDroneInterface.this.messageToDrone(ProgWidgetString.class);
                    return null;
                }
                throw new IllegalArgumentException("clearWhitelistText doesn't take any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("clearBlacklistText"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    TileEntityDroneInterface.this.getWidget().clearBlacklistText();
                    TileEntityDroneInterface.this.messageToDrone(ProgWidgetString.class);
                    return null;
                }
                throw new IllegalArgumentException("clearBlacklistText doesn't take any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("setSide"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 2) {
                    EnumFacing dir = this.getDirForString((String)args[0]);
                    boolean[] sides = TileEntityDroneInterface.this.getWidget().getSides();
                    sides[dir.ordinal()] = (Boolean)args[1];
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return null;
                }
                throw new IllegalArgumentException("addSide takes two arguments (direction, <boolean> valid)!");
            }
        });
        this.luaMethods.add(new LuaMethod("setSides"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 6) {
                    boolean[] sides = new boolean[6];
                    for (int i = 0; i < 6; ++i) {
                        sides[i] = (Boolean)args[i];
                    }
                    TileEntityDroneInterface.this.getWidget().setSides(sides);
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return null;
                }
                throw new IllegalArgumentException("setSides takes 6 arguments (6x boolean)!");
            }
        });
        this.luaMethods.add(new LuaMethod("setEmittingRedstone"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityDroneInterface.this.getWidget().setEmittingRedstone(((Double)args[0]).intValue());
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return null;
                }
                throw new IllegalArgumentException("setEmittingRedstone takes 1 argument (redstone strength)!");
            }
        });
        this.luaMethods.add(new LuaMethod("setRenameString"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityDroneInterface.this.getWidget().setNewName((String)args[0]);
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return null;
                }
                throw new IllegalArgumentException("setRenameString takes 1 argument (new name)!");
            }
        });
        this.luaMethods.add(new LuaMethod("addWhitelistLiquidFilter"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityDroneInterface.this.getWidget().addWhitelistLiquidFilter((String)args[0]);
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return null;
                }
                throw new IllegalArgumentException("addWhitelistLiquidFilter takes 1 argument (liquid name)!");
            }
        });
        this.luaMethods.add(new LuaMethod("addBlacklistLiquidFilter"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityDroneInterface.this.getWidget().addBlacklistLiquidFilter((String)args[0]);
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return null;
                }
                throw new IllegalArgumentException("addBlacklistLiquidFilter takes 1 argument (liquid name)!");
            }
        });
        this.luaMethods.add(new LuaMethod("clearWhitelistLiquidFilter"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    TileEntityDroneInterface.this.getWidget().clearLiquidWhitelist();
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return null;
                }
                throw new IllegalArgumentException("clearWhitelistLiquidFilter takes no arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("clearBlacklistLiquidFilter"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    TileEntityDroneInterface.this.getWidget().clearLiquidBlacklist();
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return null;
                }
                throw new IllegalArgumentException("clearBlacklistLiquidFilter takes no arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("setDropStraight"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityDroneInterface.this.getWidget().setDropStraight((Boolean)args[0]);
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return null;
                }
                throw new IllegalArgumentException("setDropStraight takes 1 argument (boolean straight true/false!");
            }
        });
        this.luaMethods.add(new LuaMethod("setUseCount"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityDroneInterface.this.getWidget().setUseCount((Boolean)args[0]);
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return null;
                }
                throw new IllegalArgumentException("setUseCount takes 1 argument (boolean use count true/false!");
            }
        });
        this.luaMethods.add(new LuaMethod("setCount"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityDroneInterface.this.getWidget().setCount(((Double)args[0]).intValue());
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return null;
                }
                throw new IllegalArgumentException("setCount takes 1 argument (count)!");
            }
        });
        this.luaMethods.add(new LuaMethod("setIsAndFunction"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityDroneInterface.this.getWidget().setAndFunction((Boolean)args[0]);
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return null;
                }
                throw new IllegalArgumentException("setIsAndFunction takes 1 argument (boolean is and function true/false!");
            }
        });
        this.luaMethods.add(new LuaMethod("setOperator"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityDroneInterface.this.getWidget().setOperator((String)args[0]);
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return null;
                }
                throw new IllegalArgumentException("setOperator takes 1 argument (\">=\" or \"=\")!");
            }
        });
        this.luaMethods.add(new LuaMethod("evaluateCondition"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    if (TileEntityDroneInterface.this.curAction instanceof ICondition) {
                        Boolean bool = ((ICondition)((Object)TileEntityDroneInterface.this.curAction)).evaluate(TileEntityDroneInterface.this.drone, TileEntityDroneInterface.this.getWidget());
                        return new Object[]{bool};
                    }
                    throw new IllegalArgumentException("current action is not a condition! Action: " + (TileEntityDroneInterface.this.curAction != null ? TileEntityDroneInterface.this.curAction.getWidgetString() : "no action"));
                }
                throw new IllegalArgumentException("evaluateCondition takes no arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("setUseMaxActions"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityDroneInterface.this.getWidget().setUseMaxActions((Boolean)args[0]);
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return null;
                }
                throw new IllegalArgumentException("setUseMaxActions takes 1 argument (boolean use max actions true/false!");
            }
        });
        this.luaMethods.add(new LuaMethod("setMaxActions"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityDroneInterface.this.getWidget().setMaxActions(((Double)args[0]).intValue());
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return null;
                }
                throw new IllegalArgumentException("setMaxActions takes 1 argument (actions)!");
            }
        });
        this.luaMethods.add(new LuaMethod("setSneaking"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityDroneInterface.this.getWidget().setSneaking((Boolean)args[0]);
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return null;
                }
                throw new IllegalArgumentException("setSneaking takes 1 argument (boolean is sneaking true/false!");
            }
        });
        this.luaMethods.add(new LuaMethod("setPlaceFluidBlocks"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityDroneInterface.this.getWidget().setPlaceFluidBlocks((Boolean)args[0]);
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return null;
                }
                throw new IllegalArgumentException("setPlaceFluidBlocks takes 1 argument (boolean is sneaking true/false!");
            }
        });
        this.luaMethods.add(new LuaMethod("setAction"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    String widgetName = (String)args[0];
                    for (IProgWidget widget : WidgetRegistrator.registeredWidgets) {
                        if (!widget.getWidgetString().equalsIgnoreCase(widgetName)) continue;
                        EntityAIBase ai = widget.getWidgetAI(TileEntityDroneInterface.this.drone, TileEntityDroneInterface.this.getWidget());
                        if (ai == null || !widget.canBeRunByComputers(TileEntityDroneInterface.this.drone, TileEntityDroneInterface.this.getWidget())) {
                            throw new IllegalArgumentException("The parsed action is not a runnable action! Action: \"" + widget.getWidgetString() + "\".");
                        }
                        TileEntityDroneInterface.this.getAI().setAction(widget, ai);
                        TileEntityDroneInterface.this.getTargetAI().setAction(widget, widget.getWidgetTargetAI(TileEntityDroneInterface.this.drone, TileEntityDroneInterface.this.getWidget()));
                        TileEntityDroneInterface.this.messageToDrone(ItemDye.field_150922_c[widget.getCraftingColorIndex()]);
                        TileEntityDroneInterface.this.curAction = widget;
                        return null;
                    }
                    throw new IllegalArgumentException("No action with the name \"" + widgetName + "\"!");
                }
                throw new IllegalArgumentException("setAction takes one argument (action)!");
            }
        });
        this.luaMethods.add(new LuaMethod("getAction"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    Object[] objectArray;
                    if (TileEntityDroneInterface.this.curAction != null) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = TileEntityDroneInterface.this.curAction.getWidgetString();
                    } else {
                        objectArray = null;
                    }
                    return objectArray;
                }
                throw new IllegalArgumentException("getAction doesn't take arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("abortAction"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    TileEntityDroneInterface.this.getAI().abortAction();
                    TileEntityDroneInterface.this.getTargetAI().abortAction();
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    TileEntityDroneInterface.this.curAction = null;
                    return null;
                }
                throw new IllegalArgumentException("abortAction takes no arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("isActionDone"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    return new Object[]{TileEntityDroneInterface.this.getAI().isActionDone()};
                }
                throw new IllegalArgumentException("isActionDone doesn't take any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("forgetTarget"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    if (TileEntityDroneInterface.this.drone == null) {
                        throw new IllegalStateException("There's no connected Drone!");
                    }
                    TileEntityDroneInterface.this.drone.func_70624_b(null);
                    return null;
                }
                throw new IllegalArgumentException("forgetTarget doesn't take any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("getUpgrades"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    if (TileEntityDroneInterface.this.drone == null) {
                        throw new IllegalStateException("There's no connected Drone!");
                    }
                    return new Object[]{(double)TileEntityDroneInterface.this.drone.getUpgrades(IItemRegistry.EnumUpgrade.values()[((Double)args[0]).intValue()])};
                }
                throw new IllegalArgumentException("getUpgrades takes one argument (upgrade index)!");
            }
        });
        this.luaMethods.add(new LuaMethod("setCraftingGrid"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 9) {
                    String[] grid = new String[9];
                    for (int i = 0; i < 9; ++i) {
                        grid[i] = (String)args[i];
                    }
                    TileEntityDroneInterface.this.getWidget().setCraftingGrid(grid);
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return null;
                }
                throw new IllegalArgumentException("setCraftingGrid takes 9 arguments (crafting items)!");
            }
        });
        this.luaMethods.add(new LuaMethod("setVariable"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 2 || args.length == 4) {
                    if (TileEntityDroneInterface.this.drone == null) {
                        throw new IllegalStateException("There's no connected Drone!");
                    }
                    String varName = (String)args[0];
                    int x = args[1] instanceof Double ? ((Double)args[1]).intValue() : ((Boolean)args[1] != false ? 1 : 0);
                    int y = 0;
                    int z = 0;
                    if (args.length == 4) {
                        y = ((Double)args[2]).intValue();
                        z = ((Double)args[3]).intValue();
                    }
                    TileEntityDroneInterface.this.drone.setVariable(varName, new BlockPos(x, y, z));
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return null;
                }
                throw new IllegalArgumentException("setVariable takes 2 or 4 arguments (<variable name>, <true/false>), or (<variable name>, <x> [, <y>, <z>])!");
            }
        });
        this.luaMethods.add(new LuaMethod("getVariable"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    if (TileEntityDroneInterface.this.drone == null) {
                        throw new IllegalStateException("There's no connected Drone!");
                    }
                    String varName = (String)args[0];
                    BlockPos var = TileEntityDroneInterface.this.drone.getVariable(varName);
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return new Object[]{var.func_177958_n(), var.func_177956_o(), var.func_177952_p()};
                }
                throw new IllegalArgumentException("setVariable takes 2 or 4 arguments (<variable name>, <true/false>), or (<variable name>, <x> [, <y>, <z>])!");
            }
        });
        this.luaMethods.add(new LuaMethod("setSignText"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                ((TileEntityDroneInterface)TileEntityDroneInterface.this).getWidget().signText = new String[args.length];
                for (int i = 0; i < args.length; ++i) {
                    ((TileEntityDroneInterface)TileEntityDroneInterface.this).getWidget().signText[i] = (String)args[i];
                }
                return null;
            }
        });
        this.luaMethods.add(new LuaMethod("setRequiresTool"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityDroneInterface.this.getWidget().setRequiresTool((Boolean)args[0]);
                    TileEntityDroneInterface.this.messageToDrone(-1);
                    return null;
                }
                throw new IllegalArgumentException("setRequiresTool takes 1 argument (boolean requires tool true/false!");
            }
        });
        this.luaMethods.add(new LuaMethod("getDroneName"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (TileEntityDroneInterface.this.drone == null) {
                    throw new IllegalStateException("There's no connected Drone!");
                }
                return new Object[]{TileEntityDroneInterface.this.drone.func_70005_c_()};
            }
        });
        this.luaMethods.add(new LuaMethod("getOwnerName"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (TileEntityDroneInterface.this.drone == null) {
                    throw new IllegalStateException("There's no connected Drone!");
                }
                return new Object[]{TileEntityDroneInterface.this.drone.getPlayerName()};
            }
        });
        this.luaMethods.add(new LuaMethod("getOwnerID"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (TileEntityDroneInterface.this.drone == null) {
                    throw new IllegalStateException("There's no connected Drone!");
                }
                return new Object[]{TileEntityDroneInterface.this.drone.getOwnerUUID()};
            }
        });
    }

    public String getType() {
        return "droneInterface";
    }

    public String getComponentName() {
        return this.getType();
    }

    public String[] getMethodNames() {
        String[] methodNames = new String[this.luaMethods.size()];
        for (int i = 0; i < methodNames.length; ++i) {
            methodNames[i] = this.luaMethods.get(i).getMethodName();
        }
        return methodNames;
    }

    public String[] methods() {
        return this.getMethodNames();
    }

    @Optional.Method(modid="opencomputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        if ("greet".equals(method)) {
            return new Object[]{String.format("Hello, %s!", args.checkString(0))};
        }
        for (ILuaMethod m : this.luaMethods) {
            if (!m.getMethodName().equals(method)) continue;
            return m.call(args.toArray());
        }
        throw new IllegalArgumentException("Can't invoke method with name \"" + method + "\". not registered");
    }

    @Optional.Method(modid="computercraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException {
        try {
            return this.luaMethods.get(method).call(arguments);
        }
        catch (Exception e) {
            throw new LuaException(e.getMessage());
        }
    }

    @Optional.Method(modid="computercraft")
    public void attach(IComputerAccess computer) {
        this.attachedComputers.add(computer);
    }

    @Optional.Method(modid="computercraft")
    public void detach(IComputerAccess computer) {
        this.attachedComputers.remove(computer);
    }

    @Optional.Method(modid="computercraft")
    public boolean equals(IPeripheral other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof TileEntity) {
            TileEntity tother = (TileEntity)other;
            return tother.func_145831_w().equals(this.func_145831_w()) && tother.func_174877_v().equals((Object)this.func_174877_v());
        }
        return false;
    }

    private void sendEvent(String name, Object ... parms) {
        if (Loader.isModLoaded((String)"computercraft")) {
            for (IComputerAccess computer : this.attachedComputers) {
                computer.queueEvent(name, parms);
            }
        }
    }

    public void setDrone(EntityDrone drone) {
        this.drone = drone;
        this.sendEvent(drone != null ? "droneConnected" : "droneDisconnected", new Object[0]);
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public EntityDrone getDrone() {
        return this.drone;
    }

    private ProgWidgetCC getWidget() throws Exception {
        return this.getAI().getWidget();
    }

    private DroneAICC getAI() throws Exception {
        if (this.drone != null) {
            for (DroneAIManager.EntityAITaskEntry task : this.drone.getRunningTasks()) {
                if (!(task.action instanceof DroneAICC)) continue;
                return (DroneAICC)task.action;
            }
        }
        this.setDrone(null);
        throw new IllegalStateException("There's no connected Drone!");
    }

    private DroneAICC getTargetAI() throws Exception {
        if (this.drone != null && this.drone.getRunningTargetAI() instanceof DroneAICC) {
            return (DroneAICC)this.drone.getRunningTargetAI();
        }
        this.setDrone(null);
        throw new IllegalStateException("There's no connected Drone!");
    }

    private void messageToDrone(Class<? extends IProgWidget> widget) {
        this.messageToDrone(ItemDye.field_150922_c[ItemProgrammingPuzzle.getWidgetForClass(widget).getCraftingColorIndex()]);
    }

    private void messageToDrone(int color) {
        this.ringSendList.add(color);
    }
}

