/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.remote;

import me.desht.pneumaticcraft.client.gui.GuiRemoteEditor;
import me.desht.pneumaticcraft.client.gui.remote.GuiRemoteDropdown;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSetGlobalVariable;
import me.desht.pneumaticcraft.common.remote.ActionWidgetVariable;
import me.desht.pneumaticcraft.common.remote.GlobalVariableManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.text.WordUtils;

public class ActionWidgetDropdown
extends ActionWidgetVariable<WidgetComboBox> {
    private int x;
    private int y;
    private int width;
    private int height;
    private String dropDownElements = "";
    private String selectedElement = "";

    public ActionWidgetDropdown() {
    }

    public ActionWidgetDropdown(WidgetComboBox widget) {
        super(widget);
        this.width = widget.field_146218_h;
        this.height = widget.field_146219_i;
        widget.func_146180_a(I18n.func_135052_a((String)"remote.dropdown.name", (Object[])new Object[0]));
        widget.setTooltip(WordUtils.wrap((String)I18n.func_135052_a((String)"remote.dropdown.tooltip", (Object[])new Object[0]), (int)50).split(System.getProperty("line.separator")));
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, int guiLeft, int guiTop) {
        super.readFromNBT(tag, guiLeft, guiTop);
        this.x = tag.func_74762_e("x") + guiLeft;
        this.y = tag.func_74762_e("y") + guiTop;
        this.width = tag.func_74762_e("width");
        this.height = tag.func_74762_e("height");
        this.dropDownElements = tag.func_74779_i("dropDownElements");
        this.updateWidget();
    }

    @Override
    public NBTTagCompound toNBT(int guiLeft, int guiTop) {
        NBTTagCompound tag = super.toNBT(guiLeft, guiTop);
        tag.func_74768_a("x", this.x - guiLeft);
        tag.func_74768_a("y", this.y - guiTop);
        tag.func_74768_a("width", this.width);
        tag.func_74768_a("height", this.height);
        tag.func_74778_a("dropDownElements", this.dropDownElements);
        return tag;
    }

    @Override
    public String getId() {
        return "dropdown";
    }

    @Override
    public void onKeyTyped() {
        String[] elements = this.getDropdownElements();
        this.selectedElement = this.getWidget().func_146179_b();
        for (int i = 0; i < elements.length; ++i) {
            if (!elements[i].equals(this.selectedElement)) continue;
            NetworkHandler.sendToServer(new PacketSetGlobalVariable(this.getVariableName(), i));
            break;
        }
    }

    @Override
    public void onVariableChange() {
        this.updateWidget();
    }

    @Override
    public void setWidgetPos(int x, int y) {
        this.x = x;
        this.y = y;
        this.updateWidget();
    }

    @Override
    public WidgetComboBox getWidget() {
        if (this.widget == null) {
            this.widget = new WidgetComboBox(Minecraft.func_71410_x().field_71466_p, this.x, this.y, this.width, this.height);
            ((WidgetComboBox)this.widget).setElements(this.getDropdownElements());
            ((WidgetComboBox)this.widget).setFixedOptions();
            this.updateWidget();
        }
        return (WidgetComboBox)this.widget;
    }

    private String[] getDropdownElements() {
        return this.dropDownElements.split(",");
    }

    private void updateWidget() {
        String[] elements = this.getDropdownElements();
        this.selectedElement = elements[MathHelper.func_76125_a((int)GlobalVariableManager.getInstance().getInteger(this.getVariableName()), (int)0, (int)(elements.length - 1))];
        if (this.widget != null) {
            ((WidgetComboBox)this.widget).field_146209_f = this.x;
            ((WidgetComboBox)this.widget).field_146210_g = this.y;
            ((WidgetComboBox)this.widget).field_146218_h = this.width;
            ((WidgetComboBox)this.widget).field_146219_i = this.height;
            ((WidgetComboBox)this.widget).setElements(this.getDropdownElements());
            ((WidgetComboBox)this.widget).func_146180_a(this.selectedElement);
        }
    }

    @Override
    public void onActionPerformed() {
    }

    public void setDropDownElements(String dropDownElements) {
        this.dropDownElements = dropDownElements;
        this.updateWidget();
    }

    public String getDropDownElements() {
        return this.dropDownElements;
    }

    public void setWidth(int width) {
        this.width = width;
        this.updateWidget();
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(GuiRemoteEditor guiRemote) {
        return new GuiRemoteDropdown(this, guiRemote);
    }
}

