/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.remote;

import me.desht.pneumaticcraft.client.gui.GuiRemoteEditor;
import me.desht.pneumaticcraft.client.gui.widget.IGuiWidget;
import me.desht.pneumaticcraft.common.remote.GlobalVariableManager;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public abstract class ActionWidget<Widget extends IGuiWidget> {
    protected Widget widget;
    private String enableVariable = "";
    private BlockPos enablingValue = new BlockPos(0, 0, 0);

    public ActionWidget(Widget widget) {
        this.widget = widget;
    }

    public ActionWidget() {
    }

    public void readFromNBT(NBTTagCompound tag, int guiLeft, int guiTop) {
        this.enableVariable = tag.func_74779_i("enableVariable");
        this.enablingValue = tag.func_74764_b("enablingX") ? new BlockPos(tag.func_74762_e("enablingX"), tag.func_74762_e("enablingY"), tag.func_74762_e("enablingZ")) : new BlockPos(1, 0, 0);
    }

    public NBTTagCompound toNBT(int guiLeft, int guitTop) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("id", this.getId());
        tag.func_74778_a("enableVariable", this.enableVariable);
        tag.func_74768_a("enablingX", this.enablingValue.func_177958_n());
        tag.func_74768_a("enablingY", this.enablingValue.func_177956_o());
        tag.func_74768_a("enablingZ", this.enablingValue.func_177952_p());
        return tag;
    }

    public ActionWidget copy() {
        try {
            ActionWidget widget = (ActionWidget)this.getClass().newInstance();
            widget.readFromNBT(this.toNBT(0, 0), 0, 0);
            return widget;
        }
        catch (Exception e) {
            Log.error("Error occured when trying to copy an " + this.getId() + " action widget.");
            e.printStackTrace();
            return null;
        }
    }

    public Widget getWidget() {
        return this.widget;
    }

    public abstract void setWidgetPos(int var1, int var2);

    public abstract String getId();

    public GuiScreen getGui(GuiRemoteEditor guiRemote) {
        return null;
    }

    public void setEnableVariable(String varName) {
        this.enableVariable = varName;
    }

    public String getEnableVariable() {
        return this.enableVariable;
    }

    public boolean isEnabled() {
        return this.enableVariable.equals("") || GlobalVariableManager.getInstance().getPos(this.enableVariable).equals((Object)this.enablingValue);
    }

    public void setEnablingValue(int x, int y, int z) {
        this.enablingValue = new BlockPos(x, y, z);
    }

    public BlockPos getEnablingValue() {
        return this.enablingValue;
    }
}

