/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.programs;

import java.util.List;
import me.desht.pneumaticcraft.common.item.ItemAssemblyProgram;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.recipes.AssemblyRecipe;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyDrill;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyIOUnit;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyLaser;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyPlatform;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public abstract class AssemblyProgram {
    public EnumTubeProblem curProblem = EnumTubeProblem.NO_PROBLEM;

    public abstract EnumMachine[] getRequiredMachines();

    public abstract boolean executeStep(TileEntityAssemblyController var1, TileEntityAssemblyPlatform var2, TileEntityAssemblyIOUnit var3, TileEntityAssemblyIOUnit var4, TileEntityAssemblyDrill var5, TileEntityAssemblyLaser var6);

    public abstract void writeToNBT(NBTTagCompound var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public abstract List<AssemblyRecipe> getRecipeList();

    public void addProgramProblem(List<String> problemList) {
        switch (this.curProblem) {
            case NO_INPUT: {
                problemList.addAll(PneumaticCraftUtils.convertStringIntoList(TextFormatting.GRAY + "The input IO Unit can't find an inventory with a Block of Compressed Iron.", 26));
                problemList.addAll(PneumaticCraftUtils.convertStringIntoList(TextFormatting.BLACK + "Place an inventory with a Block of Compressed Iron surrounding the IO Unit.", 26));
                break;
            }
            case NO_OUTPUT: {
                problemList.addAll(PneumaticCraftUtils.convertStringIntoList(TextFormatting.GRAY + "The output IO Unit can't find an inventory to place the output in.", 26));
                problemList.addAll(PneumaticCraftUtils.convertStringIntoList(TextFormatting.BLACK + "Place an inventory / make space in a connected inventory.", 26));
            }
        }
    }

    public static boolean isValidInput(AssemblyRecipe recipe, ItemStack input) {
        return !input.func_190926_b() && (input.func_77969_a(recipe.getInput()) || PneumaticCraftUtils.isSameOreDictStack(input, recipe.getInput())) && input.func_190916_E() == recipe.getInput().func_190916_E();
    }

    public static AssemblyProgram fromRecipe(AssemblyRecipe recipe) {
        int meta = AssemblyRecipe.drillRecipes.contains(recipe) ? 0 : (AssemblyRecipe.laserRecipes.contains(recipe) ? 1 : 2);
        return ItemAssemblyProgram.getProgramFromItem(meta);
    }

    public ItemStack getItemStack(int amount) {
        return new ItemStack(Itemss.ASSEMBLY_PROGRAM, amount, this.getItemMeta());
    }

    protected abstract int getItemMeta();

    public static enum EnumMachine {
        PLATFORM,
        DRILL,
        LASER,
        IO_UNIT_EXPORT,
        IO_UNIT_IMPORT;

    }

    public static enum EnumTubeProblem {
        NO_PROBLEM,
        NO_INPUT,
        NO_OUTPUT;

    }
}

