/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.gui.programmer.GuiProgWidgetCoordinateOperator;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableSetWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCoordinate;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProgWidgetCoordinateOperator
extends ProgWidget
implements IVariableSetWidget {
    private EnumOperator operator = EnumOperator.PLUS_MINUS;
    private String variable = "";
    private DroneAIManager aiManager;

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public Class<? extends IProgWidget> returnType() {
        return null;
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetCoordinate.class};
    }

    @Override
    public String getWidgetString() {
        return "coordinateOperator";
    }

    @Override
    public int getCraftingColorIndex() {
        return 8;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public void addErrors(List<String> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.variable.equals("")) {
            curInfo.add("gui.progWidget.general.error.emptyVariable");
        }
        if (this.operator == EnumOperator.MAX_MIN && this.getConnectedParameters()[0] == null && this.getConnectedParameters()[this.getParameters().length] == null) {
            curInfo.add("gui.progWidget.coordinateOperator.noParameter");
        }
    }

    @Override
    public IProgWidget getOutputWidget(IDroneBase drone, List<IProgWidget> allWidgets) {
        if (!this.variable.equals("")) {
            BlockPos curPos = ProgWidgetCoordinateOperator.calculateCoordinate(this, 0, this.operator);
            this.aiManager.setCoordinate(this.variable, curPos);
        }
        return super.getOutputWidget(drone, allWidgets);
    }

    public static BlockPos calculateCoordinate(IProgWidget widget, int argIndex, EnumOperator operator) {
        BlockPos curPos = null;
        switch (operator) {
            case MULIPLY_DIVIDE: {
                BlockPos pos;
                curPos = new BlockPos(1, 1, 1);
                ProgWidgetCoordinate coordinateWidget = (ProgWidgetCoordinate)widget.getConnectedParameters()[argIndex];
                while (coordinateWidget != null) {
                    pos = coordinateWidget.getCoordinate();
                    curPos = new BlockPos(curPos.func_177958_n() * pos.func_177958_n(), curPos.func_177956_o() * pos.func_177956_o(), curPos.func_177952_p() * pos.func_177952_p());
                    coordinateWidget = (ProgWidgetCoordinate)coordinateWidget.getConnectedParameters()[0];
                }
                coordinateWidget = (ProgWidgetCoordinate)widget.getConnectedParameters()[widget.getParameters().length + argIndex];
                while (coordinateWidget != null) {
                    pos = coordinateWidget.getCoordinate();
                    if (pos.func_177958_n() != 0 && pos.func_177956_o() != 0 && pos.func_177952_p() != 0) {
                        curPos = new BlockPos(curPos.func_177958_n() / pos.func_177958_n(), curPos.func_177956_o() / pos.func_177956_o(), curPos.func_177952_p() / pos.func_177952_p());
                    }
                    coordinateWidget = (ProgWidgetCoordinate)coordinateWidget.getConnectedParameters()[0];
                }
                break;
            }
            case PLUS_MINUS: {
                BlockPos pos;
                curPos = new BlockPos(0, 0, 0);
                ProgWidgetCoordinate coordinateWidget = (ProgWidgetCoordinate)widget.getConnectedParameters()[argIndex];
                while (coordinateWidget != null) {
                    pos = coordinateWidget.getCoordinate();
                    curPos = new BlockPos(curPos.func_177958_n() + pos.func_177958_n(), curPos.func_177956_o() + pos.func_177956_o(), curPos.func_177952_p() + pos.func_177952_p());
                    coordinateWidget = (ProgWidgetCoordinate)coordinateWidget.getConnectedParameters()[0];
                }
                coordinateWidget = (ProgWidgetCoordinate)widget.getConnectedParameters()[widget.getParameters().length + argIndex];
                while (coordinateWidget != null) {
                    pos = coordinateWidget.getCoordinate();
                    curPos = new BlockPos(curPos.func_177958_n() - pos.func_177958_n(), curPos.func_177956_o() - pos.func_177956_o(), curPos.func_177952_p() - pos.func_177952_p());
                    coordinateWidget = (ProgWidgetCoordinate)coordinateWidget.getConnectedParameters()[0];
                }
                break;
            }
            case MAX_MIN: {
                BlockPos pos;
                curPos = new BlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
                ProgWidgetCoordinate coordinateWidget = (ProgWidgetCoordinate)widget.getConnectedParameters()[argIndex];
                while (coordinateWidget != null) {
                    pos = coordinateWidget.getCoordinate();
                    curPos = new BlockPos(Math.max(curPos.func_177958_n(), pos.func_177958_n()), Math.max(curPos.func_177956_o(), pos.func_177956_o()), Math.max(curPos.func_177952_p(), pos.func_177952_p()));
                    coordinateWidget = (ProgWidgetCoordinate)coordinateWidget.getConnectedParameters()[0];
                }
                if (curPos.equals((Object)new BlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE))) {
                    curPos = new BlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
                }
                coordinateWidget = (ProgWidgetCoordinate)widget.getConnectedParameters()[widget.getParameters().length + argIndex];
                while (coordinateWidget != null) {
                    pos = coordinateWidget.getCoordinate();
                    curPos = new BlockPos(Math.min(curPos.func_177958_n(), pos.func_177958_n()), Math.min(curPos.func_177956_o(), pos.func_177956_o()), Math.min(curPos.func_177952_p(), pos.func_177952_p()));
                    coordinateWidget = (ProgWidgetCoordinate)coordinateWidget.getConnectedParameters()[0];
                }
                break;
            }
        }
        return curPos;
    }

    @Override
    public ResourceLocation getTexture() {
        return this.operator.texture;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74778_a("variable", this.variable);
        tag.func_74774_a("operator", (byte)this.operator.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.variable = tag.func_74779_i("variable");
        byte operatorValue = tag.func_74764_b("multiplyDivide") ? tag.func_74771_c("multiplyDivide") : tag.func_74771_c("operator");
        this.operator = EnumOperator.values()[operatorValue];
    }

    public EnumOperator getOperator() {
        return this.operator;
    }

    public void setOperator(EnumOperator operator) {
        this.operator = operator;
    }

    @Override
    public String getVariable() {
        return this.variable;
    }

    @Override
    public void setVariable(String variable) {
        this.variable = variable;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetCoordinateOperator(this, guiProgrammer);
    }

    @Override
    public void getTooltip(List<String> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add("Setting variable: \"" + this.variable + "\"");
    }

    @Override
    public String getExtraStringInfo() {
        return "\"" + this.variable + "\"";
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.variable);
    }

    public static enum EnumOperator {
        PLUS_MINUS("plus_minus"),
        MULIPLY_DIVIDE("multiply_divide"),
        MAX_MIN("max_min");

        public final ResourceLocation texture;
        private final String name;

        private EnumOperator(String name) {
            this.name = name;
            this.texture = new ResourceLocation("pneumaticcraft:textures/items/progwidgets/coordinate_operation_" + name + ".png");
        }

        public String getTranslationKey() {
            return "gui.progWidget.coordinateOperator." + this.name;
        }
    }
}

