/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.gui.programmer.GuiProgWidgetAreaShow;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.ai.StringFilterEntitySelector;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.progwidgets.IItemFiltering;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetString;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ProgWidgetAreaItemBase
extends ProgWidget
implements IAreaProvider,
IEntityProvider,
IItemFiltering,
IVariableWidget {
    private List<BlockPos> areaListCache;
    private Set<BlockPos> areaSetCache;
    private Map<String, BlockPos> areaVariableStates;
    protected DroneAIManager aiManager;
    private boolean canCache = true;

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public Class<? extends IProgWidget> returnType() {
        return null;
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetArea.class, ProgWidgetItemFilter.class};
    }

    @Override
    public void addErrors(List<String> curInfo, List<IProgWidget> widgets) {
        Set<BlockPos> posSet;
        super.addErrors(curInfo, widgets);
        if (this.getConnectedParameters()[0] == null) {
            curInfo.add("gui.progWidget.area.error.noArea");
        }
        if ((posSet = this.getCachedAreaSet()).size() > ConfigHandler.general.maxProgrammingArea) {
            curInfo.add(I18n.func_135052_a((String)"gui.progWidget.area.error.areaTooBig", (Object[])new Object[]{ConfigHandler.general.maxProgrammingArea}));
        }
    }

    public static IBlockAccess getCache(Collection<BlockPos> area, World world) {
        int maxZ;
        int maxY;
        int maxX;
        if (area.size() == 0) {
            return world;
        }
        Iterator<BlockPos> iterator = area.iterator();
        BlockPos p = iterator.next();
        int minX = maxX = p.func_177958_n();
        int minY = maxY = p.func_177956_o();
        int minZ = maxZ = p.func_177952_p();
        while (iterator.hasNext()) {
            p = iterator.next();
            minX = Math.min(minX, p.func_177958_n());
            minY = Math.min(minY, p.func_177956_o());
            minZ = Math.min(minZ, p.func_177952_p());
            maxX = Math.max(maxX, p.func_177958_n());
            maxY = Math.max(maxY, p.func_177956_o());
            maxZ = Math.max(maxZ, p.func_177952_p());
        }
        return new ChunkCache(world, new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ), 0);
    }

    public List<BlockPos> getCachedAreaList() {
        if (this.areaListCache != null) {
            if (!this.canCache || this.updateVariables()) {
                this.areaSetCache = new HashSet<BlockPos>(this.areaListCache.size());
                this.getArea(this.areaSetCache);
                this.areaListCache = new ArrayList<BlockPos>(this.areaSetCache.size());
                this.areaListCache.addAll(this.areaSetCache);
            }
        } else {
            this.areaSetCache = new HashSet<BlockPos>();
            this.getArea(this.areaSetCache);
            this.areaListCache = new ArrayList<BlockPos>(this.areaSetCache.size());
            this.areaListCache.addAll(this.areaSetCache);
            this.initializeVariableCache();
        }
        return this.areaListCache;
    }

    public Set<BlockPos> getCachedAreaSet() {
        this.getCachedAreaList();
        return this.areaSetCache;
    }

    private void initializeVariableCache() {
        this.areaVariableStates = new HashMap<String, BlockPos>();
        ProgWidgetArea whitelistWidget = (ProgWidgetArea)this.getConnectedParameters()[0];
        ProgWidgetArea blacklistWidget = (ProgWidgetArea)this.getConnectedParameters()[this.getParameters().length];
        if (whitelistWidget == null) {
            return;
        }
        ProgWidgetArea widget = whitelistWidget;
        while (widget != null) {
            if (!widget.type.isDeterministic()) {
                this.canCache = false;
            }
            if (this.aiManager != null) {
                if (!widget.getCoord1Variable().equals("")) {
                    this.areaVariableStates.put(widget.getCoord1Variable(), this.aiManager.getCoordinate(widget.getCoord1Variable()));
                }
                if (!widget.getCoord2Variable().equals("")) {
                    this.areaVariableStates.put(widget.getCoord2Variable(), this.aiManager.getCoordinate(widget.getCoord2Variable()));
                }
            }
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        widget = blacklistWidget;
        while (widget != null) {
            if (!widget.type.isDeterministic()) {
                this.canCache = false;
            }
            if (this.aiManager != null) {
                if (!widget.getCoord1Variable().equals("")) {
                    this.areaVariableStates.put(widget.getCoord1Variable(), this.aiManager.getCoordinate(widget.getCoord1Variable()));
                }
                if (!widget.getCoord2Variable().equals("")) {
                    this.areaVariableStates.put(widget.getCoord2Variable(), this.aiManager.getCoordinate(widget.getCoord2Variable()));
                }
            }
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
    }

    private boolean updateVariables() {
        boolean varChanged = false;
        for (Map.Entry<String, BlockPos> entry : this.areaVariableStates.entrySet()) {
            BlockPos newValue = this.aiManager.getCoordinate(entry.getKey());
            if (newValue.equals((Object)entry.getValue())) continue;
            varChanged = true;
            entry.setValue(newValue);
        }
        return varChanged;
    }

    @Override
    public void getArea(Set<BlockPos> area) {
        ProgWidgetAreaItemBase.getArea(area, (ProgWidgetArea)this.getConnectedParameters()[0], (ProgWidgetArea)this.getConnectedParameters()[this.getParameters().length]);
    }

    public static void getArea(Set<BlockPos> area, ProgWidgetArea whitelistWidget, ProgWidgetArea blacklistWidget) {
        if (whitelistWidget == null) {
            return;
        }
        ProgWidgetArea widget = whitelistWidget;
        while (widget != null) {
            widget.getArea(area);
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        widget = blacklistWidget;
        HashSet<BlockPos> blacklistedArea = new HashSet<BlockPos>();
        while (widget != null) {
            widget.getArea(blacklistedArea);
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        area.removeAll(blacklistedArea);
    }

    @Override
    public boolean isItemValidForFilters(ItemStack item) {
        return this.isItemValidForFilters(item, null);
    }

    public boolean isItemValidForFilters(ItemStack item, IBlockState blockState) {
        return ProgWidgetItemFilter.isItemValidForFilters(item, ProgWidget.getConnectedWidgetList(this, 1), ProgWidget.getConnectedWidgetList(this, this.getParameters().length + 1), blockState);
    }

    public boolean isItemFilterEmpty() {
        return this.getConnectedParameters()[1] == null && this.getConnectedParameters()[3] == null;
    }

    public List<Entity> getEntitiesInArea(World world, Predicate<? super Entity> filter) {
        return ProgWidgetAreaItemBase.getEntitiesInArea((ProgWidgetArea)this.getConnectedParameters()[0], (ProgWidgetArea)this.getConnectedParameters()[this.getParameters().length], world, filter, null);
    }

    public static List<Entity> getValidEntities(World world, IProgWidget widget) {
        StringFilterEntitySelector whitelistFilter = ProgWidgetAreaItemBase.getEntityFilter((ProgWidgetString)widget.getConnectedParameters()[1], true);
        StringFilterEntitySelector blacklistFilter = ProgWidgetAreaItemBase.getEntityFilter((ProgWidgetString)widget.getConnectedParameters()[widget.getParameters().length + 1], false);
        return ProgWidgetAreaItemBase.getEntitiesInArea((ProgWidgetArea)widget.getConnectedParameters()[0], (ProgWidgetArea)widget.getConnectedParameters()[widget.getParameters().length], world, (Predicate<? super Entity>)((Object)whitelistFilter), (Predicate<? super Entity>)((Object)blacklistFilter));
    }

    @Override
    public List<Entity> getValidEntities(World world) {
        return ProgWidgetAreaItemBase.getValidEntities(world, this);
    }

    public static boolean isEntityValid(Entity entity, IProgWidget widget) {
        StringFilterEntitySelector whitelistFilter = ProgWidgetAreaItemBase.getEntityFilter((ProgWidgetString)widget.getConnectedParameters()[1], true);
        StringFilterEntitySelector blacklistFilter = ProgWidgetAreaItemBase.getEntityFilter((ProgWidgetString)widget.getConnectedParameters()[widget.getParameters().length + 1], false);
        return whitelistFilter.apply(entity) && !blacklistFilter.apply(entity);
    }

    @Override
    public boolean isEntityValid(Entity entity) {
        return ProgWidgetAreaItemBase.isEntityValid(entity, this);
    }

    public static StringFilterEntitySelector getEntityFilter(ProgWidgetString widget, boolean allowEntityIfNoFilter) {
        StringFilterEntitySelector filter = new StringFilterEntitySelector();
        if (widget != null) {
            while (widget != null) {
                filter.addEntry(widget.string);
                widget = (ProgWidgetString)widget.getConnectedParameters()[0];
            }
        } else if (allowEntityIfNoFilter) {
            filter.setFilter("");
        }
        return filter;
    }

    public static List<Entity> getEntitiesInArea(ProgWidgetArea whitelistWidget, ProgWidgetArea blacklistWidget, World world, Predicate<? super Entity> whitelistPredicate, Predicate<? super Entity> blacklistPredicate) {
        if (whitelistWidget == null) {
            return new ArrayList<Entity>();
        }
        HashSet<Entity> entities = new HashSet<Entity>();
        ProgWidgetArea widget = whitelistWidget;
        while (widget != null) {
            entities.addAll(widget.getEntitiesWithinArea(world, whitelistPredicate));
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        widget = blacklistWidget;
        while (widget != null) {
            entities.removeAll(widget.getEntitiesWithinArea(world, whitelistPredicate));
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        if (blacklistPredicate != null) {
            entities.removeIf(blacklistPredicate::test);
        }
        return new ArrayList<Entity>(entities);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetAreaShow<ProgWidgetAreaItemBase>(this, guiProgrammer);
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    @Override
    public void addVariables(Set<String> variables) {
    }
}

