/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.network.AbstractPacket;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketSyncDroneEntityProgWidgets
extends AbstractPacket<PacketSyncDroneEntityProgWidgets> {
    private List<IProgWidget> progWidgets;
    private int entityId;

    public PacketSyncDroneEntityProgWidgets() {
    }

    public PacketSyncDroneEntityProgWidgets(EntityDrone drone) {
        this.progWidgets = drone.getProgWidgets();
        this.entityId = drone.func_145782_y();
    }

    public void fromBytes(ByteBuf buf) {
        this.progWidgets = TileEntityProgrammer.getWidgetsFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
        this.entityId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        TileEntityProgrammer.setWidgetsToNBT(this.progWidgets, tag);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
        buf.writeInt(this.entityId);
    }

    @Override
    public void handleClientSide(PacketSyncDroneEntityProgWidgets message, EntityPlayer player) {
        Entity entity = player.field_70170_p.func_73045_a(message.entityId);
        if (entity instanceof EntityDrone) {
            EntityDrone drone = (EntityDrone)entity;
            List<IProgWidget> widgets = drone.getProgWidgets();
            widgets.clear();
            widgets.addAll(message.progWidgets);
        }
    }

    @Override
    public void handleServerSide(PacketSyncDroneEntityProgWidgets message, EntityPlayer player) {
    }
}

