/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.item.IAmadronInterface;
import me.desht.pneumaticcraft.common.item.ItemPressurizable;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncAmadronOffers;
import me.desht.pneumaticcraft.common.recipes.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.AmadronOfferCustom;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemAmadronTablet
extends ItemPressurizable
implements IAmadronInterface,
IPositionProvider {
    public ItemAmadronTablet() {
        super("amadron_tablet", 30000, 3000);
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (handIn != EnumHand.MAIN_HAND) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
        }
        if (!worldIn.field_72995_K) {
            NetworkHandler.sendTo(new PacketSyncAmadronOffers(playerIn), (EntityPlayerMP)playerIn);
            playerIn.openGui((Object)PneumaticCraftRepressurized.instance, GuiHandler.EnumGuiId.AMADRON.ordinal(), playerIn.field_70170_p, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)playerIn.func_184614_ca());
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return EnumActionResult.PASS;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te == null) {
            return EnumActionResult.PASS;
        }
        if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) {
            if (!worldIn.field_72995_K) {
                ItemAmadronTablet.setLiquidProvidingLocation(player.func_184614_ca(), pos, worldIn.field_73011_w.getDimension());
                player.func_146105_b((ITextComponent)new TextComponentTranslation("message.amadronTable.setLiquidProvidingLocation", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), worldIn.field_73011_w.getDimension(), worldIn.field_73011_w.func_186058_p().toString()}), false);
            }
        } else if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            if (!worldIn.field_72995_K) {
                ItemAmadronTablet.setItemProvidingLocation(player.func_184614_ca(), pos, worldIn.field_73011_w.getDimension());
                player.func_146105_b((ITextComponent)new TextComponentTranslation("message.amadronTable.setItemProvidingLocation", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), worldIn.field_73011_w.getDimension(), worldIn.field_73011_w.func_186058_p().toString()}), false);
            }
        } else {
            return EnumActionResult.PASS;
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> infoList, ITooltipFlag flag) {
        int dim;
        super.func_77624_a(stack, worldIn, infoList, flag);
        BlockPos pos = ItemAmadronTablet.getItemProvidingLocation(stack);
        if (pos != null) {
            dim = ItemAmadronTablet.getItemProvidingDimension(stack);
            infoList.add(I18n.func_135052_a((String)"gui.tooltip.amadronTablet.itemLocation", (Object[])new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dim}));
        } else {
            infoList.add(I18n.func_135052_a((String)"gui.tooltip.amadronTablet.selectItemLocation", (Object[])new Object[0]));
        }
        pos = ItemAmadronTablet.getLiquidProvidingLocation(stack);
        if (pos != null) {
            dim = ItemAmadronTablet.getLiquidProvidingDimension(stack);
            infoList.add(I18n.func_135052_a((String)"gui.tooltip.amadronTablet.fluidLocation", (Object[])new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dim}));
        } else {
            infoList.add(I18n.func_135052_a((String)"gui.tooltip.amadronTablet.selectFluidLocation", (Object[])new Object[0]));
        }
    }

    public static IItemHandler getItemProvider(ItemStack tablet) {
        BlockPos pos = ItemAmadronTablet.getItemProvidingLocation(tablet);
        if (pos != null) {
            int dimension = ItemAmadronTablet.getItemProvidingDimension(tablet);
            TileEntity te = PneumaticCraftUtils.getTileEntity(pos, dimension);
            return IOHelper.getInventoryForTE(te);
        }
        return null;
    }

    public static BlockPos getItemProvidingLocation(ItemStack tablet) {
        NBTTagCompound compound = tablet.func_77978_p();
        if (compound != null) {
            int x = compound.func_74762_e("itemX");
            int y = compound.func_74762_e("itemY");
            int z = compound.func_74762_e("itemZ");
            if (x != 0 || y != 0 || z != 0) {
                return new BlockPos(x, y, z);
            }
            return null;
        }
        return null;
    }

    public static int getItemProvidingDimension(ItemStack tablet) {
        return tablet.func_77942_o() ? tablet.func_77978_p().func_74762_e("itemDim") : 0;
    }

    public static void setItemProvidingLocation(ItemStack tablet, BlockPos pos, int dimensionId) {
        NBTUtil.setInteger(tablet, "itemX", pos.func_177958_n());
        NBTUtil.setInteger(tablet, "itemY", pos.func_177956_o());
        NBTUtil.setInteger(tablet, "itemZ", pos.func_177952_p());
        NBTUtil.setInteger(tablet, "itemDim", dimensionId);
    }

    public static IFluidHandler getLiquidProvider(ItemStack tablet) {
        BlockPos pos = ItemAmadronTablet.getLiquidProvidingLocation(tablet);
        if (pos != null) {
            int dimension = ItemAmadronTablet.getLiquidProvidingDimension(tablet);
            return FluidUtil.getFluidHandler((World)DimensionManager.getWorld((int)dimension), (BlockPos)pos, null);
        }
        return null;
    }

    public static BlockPos getLiquidProvidingLocation(ItemStack tablet) {
        NBTTagCompound compound = tablet.func_77978_p();
        if (compound != null) {
            int x = compound.func_74762_e("liquidX");
            int y = compound.func_74762_e("liquidY");
            int z = compound.func_74762_e("liquidZ");
            if (x != 0 || y != 0 || z != 0) {
                return new BlockPos(x, y, z);
            }
            return null;
        }
        return null;
    }

    public static int getLiquidProvidingDimension(ItemStack tablet) {
        return tablet.func_77942_o() ? tablet.func_77978_p().func_74762_e("liquidDim") : 0;
    }

    public static void setLiquidProvidingLocation(ItemStack tablet, BlockPos pos, int dimensionId) {
        NBTUtil.setInteger(tablet, "liquidX", pos.func_177958_n());
        NBTUtil.setInteger(tablet, "liquidY", pos.func_177956_o());
        NBTUtil.setInteger(tablet, "liquidZ", pos.func_177952_p());
        NBTUtil.setInteger(tablet, "liquidDim", dimensionId);
    }

    public static Map<AmadronOffer, Integer> getShoppingCart(ItemStack tablet) {
        HashMap<AmadronOffer, Integer> offers = new HashMap<AmadronOffer, Integer>();
        if (tablet.func_77942_o() && tablet.func_77978_p().func_74764_b("shoppingCart")) {
            NBTTagList list = tablet.func_77978_p().func_150295_c("shoppingCart", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                offers.put(tag.func_74764_b("inStock") ? AmadronOfferCustom.loadFromNBT(tag) : AmadronOffer.loadFromNBT(tag), tag.func_74762_e("amount"));
            }
        }
        return offers;
    }

    public static void setShoppingCart(ItemStack tablet, Map<AmadronOffer, Integer> cart) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<AmadronOffer, Integer> entry : cart.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            entry.getKey().writeToNBT(tag);
            tag.func_74768_a("amount", entry.getValue().intValue());
            list.func_74742_a((NBTBase)tag);
        }
        NBTUtil.setCompoundTag(tablet, "shoppingCart", (NBTBase)list);
    }

    @Override
    public List<BlockPos> getStoredPositions(@Nonnull ItemStack stack) {
        return Arrays.asList(ItemAmadronTablet.getItemProvidingLocation(stack), ItemAmadronTablet.getLiquidProvidingLocation(stack));
    }

    @Override
    public int getRenderColor(int index) {
        switch (index) {
            case 0: {
                return -1868543730;
            }
            case 1: {
                return -1878998848;
            }
        }
        return -1;
    }
}

