/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config;

import java.io.File;
import java.io.IOException;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.common.config.AmadronOfferPeriodicConfig;
import me.desht.pneumaticcraft.common.config.AmadronOfferSettings;
import me.desht.pneumaticcraft.common.config.AmadronOfferStaticConfig;
import me.desht.pneumaticcraft.common.config.HelmetWidgetDefaults;
import me.desht.pneumaticcraft.common.config.ISubConfig;
import me.desht.pneumaticcraft.common.config.ProgWidgetConfig;
import me.desht.pneumaticcraft.common.config.ThirdPartyConfig;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="pneumaticcraft")
public class ConfigHandler {
    private static final ISubConfig[] subConfigs = new ISubConfig[]{new AmadronOfferSettings(), AmadronOfferStaticConfig.INSTANCE, AmadronOfferPeriodicConfig.INSTANCE, new ProgWidgetConfig(), HelmetWidgetDefaults.INSTANCE, ThirdPartyConfig.INSTANCE};
    @Config.Name(value="general")
    @Config.LangKey(value="gui.config.category.general")
    @Config.Comment(value={"General stuff that doesn't fit anywhere else"})
    public static final General general = new General();
    @Config.Name(value="machine_properties")
    @Config.LangKey(value="gui.config.category.machine")
    @Config.Comment(value={"Settings affecting the operation of machines"})
    public static final MachineProperties machineProperties = new MachineProperties();
    @Config.Name(value="advanced")
    @Config.LangKey(value="gui.config.category.advanced")
    @Config.Comment(value={"Advanced settings (shouldn't need to touch under normal circumstances)"})
    public static final Advanced advanced = new Advanced();
    @Config.Name(value="recipes")
    @Config.LangKey(value="gui.config.category.recipes")
    @Config.Comment(value={"Enable/disable certain recipes (note: vanilla recipes can be also managed via CraftTweaker)"})
    public static final Recipes recipes = new Recipes();
    @Config.Name(value="client")
    @Config.LangKey(value="gui.config.category.client")
    @Config.Comment(value={"Settings affecting only the client"})
    public static final ClientOptions client = new ClientOptions();
    @Config.Name(value="helmet")
    @Config.LangKey(value="gui.config.category.helmet")
    @Config.Comment(value={"Pneumatic Helmet HUD settings (note: you can also set this up via helmet GUI)"})
    public static final HelmetOptions helmetOptions = new HelmetOptions();

    public static void sync() {
        ConfigManager.sync((String)"pneumaticcraft", (Config.Type)Config.Type.INSTANCE);
    }

    public static void onPreInit(File configFile) {
        PneumaticCraftRepressurized.proxy.initConfig();
        for (ISubConfig subConfig : subConfigs) {
            File subFolder = new File(configFile.getAbsolutePath().substring(0, configFile.getAbsolutePath().length() - 4) + File.separator);
            if (!subFolder.exists() && !subFolder.mkdirs()) continue;
            File subFile = new File(subFolder, subConfig.getConfigFilename() + ".cfg");
            try {
                subConfig.preInit(subFile);
            }
            catch (IOException e) {
                PneumaticCraftRepressurized.logger.error("Config file " + subConfig.getConfigFilename() + " failed to create! Unexpected things can happen!");
                e.printStackTrace();
            }
            catch (ClassCastException e) {
                PneumaticCraftRepressurized.logger.error("Config file " + subConfig.getConfigFilename() + " appears to be invalid JSON! Unexpected things can happen!");
                e.printStackTrace();
            }
        }
    }

    public static void onPostInit() {
        for (ISubConfig subConfig : subConfigs) {
            try {
                subConfig.postInit();
            }
            catch (IOException e) {
                PneumaticCraftRepressurized.logger.error("Config file " + subConfig.getConfigFilename() + " failed to create! Unexpected things can happen!");
                e.printStackTrace();
            }
            catch (ClassCastException e) {
                PneumaticCraftRepressurized.logger.error("Config file " + subConfig.getConfigFilename() + " appears to be invalid JSON! Unexpected things can happen!");
                e.printStackTrace();
            }
        }
    }

    public static void setProgrammerDifficulty(int difficulty) {
        ConfigHandler.client.programmerDifficulty = difficulty;
        ConfigHandler.sync();
    }

    public static int getProgrammerDifficulty() {
        return ConfigHandler.client.programmerDifficulty;
    }

    @Mod.EventBusSubscriber
    public static class ConfigSyncHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("pneumaticcraft")) {
                ConfigManager.sync((String)"pneumaticcraft", (Config.Type)Config.Type.INSTANCE);
                PneumaticCraftRepressurized.logger.info("Configuration has been saved.");
            }
        }
    }

    public static class HelmetOptions {
        @Config.Comment(value={"Pneumatic helmet power readout X"})
        public int powerX = -1;
        @Config.Comment(value={"Pneumatic helmet power readout Y"})
        public int powerY = 2;
        @Config.Comment(value={"Pneumatic helmet power readout on left?"})
        public boolean powerLeft = false;
        @Config.Comment(value={"Pneumatic helmet message readout X"})
        public int messageX = 2;
        @Config.Comment(value={"Pneumatic helmet message readout Y"})
        public int messageY = 2;
        @Config.Comment(value={"Pneumatic helmet message readout on left?"})
        public boolean messageLeft = false;
        @Config.Comment(value={"Pneumatic helmet block tracker X"})
        public int blockTrackerX = -1;
        @Config.Comment(value={"Pneumatic helmet block tracker Y"})
        public int blockTrackerY = 46;
        @Config.Comment(value={"Pneumatic helmet block tracker on left?"})
        public boolean blockTrackerLeft = true;
        @Config.Comment(value={"Pneumatic helmet entity tracker X"})
        public int entityTrackerX = -1;
        @Config.Comment(value={"Pneumatic helmet entity tracker Y"})
        public int entityTrackerY = 90;
        @Config.Comment(value={"Pneumatic helmet entity tracker on left?"})
        public boolean entityTrackerLeft = true;
        @Config.Comment(value={"Pneumatic helmet item search X"})
        public int itemSearchX = -1;
        @Config.Comment(value={"Pneumatic helmet item search Y"})
        public int itemSearchY = 17;
        @Config.Comment(value={"Pneumatic helmet item search on left?"})
        public boolean itemSearchLeft = true;
        @Config.Comment(value={"Pneumatic helmet Path Enabled"})
        public boolean pathEnabled = true;
        @Config.Comment(value={"Pneumatic helmet Wire Path"})
        public boolean wirePath = true;
        @Config.Comment(value={"Pneumatic helmet X-Ray"})
        public boolean xRayEnabled = false;
        @Config.Comment(value={"Pneumatic helmet Path Update Rate"})
        public int pathUpdateSetting = 1;
    }

    public static class ClientOptions {
        @Config.Comment(value={"Enable Aphorism Tile Drama!  http://mc-drama.herokuapp.com/"})
        public boolean aphorismDrama = true;
        @Config.Comment(value={"When true, the Pneumatic Helmet will be a model. Warning: this model looks far too good to be in MC (currently ignored)"})
        public boolean useHelmetModel = false;
        @Config.Comment(value={"Defines the default difficulty of the Programmer shown to the user. 0 = easy, 1 = medium, 2 = advanced"})
        @Config.RangeInt(min=0, max=2)
        public int programmerDifficulty = 0;
        @Config.Comment(value={"Show tank fluids with the The One Probe.  Note that TOP also has support for showing tanks, which may or may not be enabled."})
        public boolean topShowsFluids = true;
        @Config.Comment(value={"Tint Logistics configuration GUI backgrounds according to the colour of the logistics frame you are configuring"})
        public boolean logisticsGUITint = true;
        @Config.Comment(value={"Drones render their held item (the item in slot 0 of their inventory) ?"})
        public boolean dronesRenderHeldItem = true;
        @Config.Comment(value={"Use block lighting for semiblocks (logistics frames, heat frames...). May cause occasional lighting issues - semiblocks appearing unlit - disable this if that's a problem."})
        public boolean semiBlockLighting = true;
        @Config.Comment(value={"Intensity of the FOV modification when using Pneumatic Leggings speed boost: 0.0 for no FOV modification, higher values zoom out more.  Note: non-zero values may cause FOV clashes with other mods."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double leggingsFOVfactor = 0.0;
        @Config.Comment(value={"Should GUI side tabs be shown with a beveled edge?  Setting to false uses a plain black edge, as in earlier versions of the mod"})
        public boolean guiBevel = true;
    }

    public static class Recipes {
        @Config.Comment(value={"Electric Compressor for IC2"})
        @Config.RequiresMcRestart
        public boolean enableElectricCompressorRecipe = true;
        @Config.Comment(value={"Pneumatic Generator for IC2"})
        @Config.RequiresMcRestart
        public boolean enablePneumaticGeneratorRecipe = true;
        @Config.Comment(value={"8 Block of Coal --> 1 Diamond (Pressure Chamber)"})
        @Config.RequiresMcRestart
        public boolean enableCoalToDiamondsRecipe = true;
    }

    public static class Advanced {
        @Config.Comment(value={"When set to true, Drones will not execute any program. This is useful to set to true when due to a bug Drones are lagging your server or crashing it. Please report the bug if you encounter it."})
        public boolean stopDroneAI = false;
        @Config.Comment(value={"When set to true, the Kerosene Lamp's fake air blocks won't be registered and therefore removed from the world. Useful if this causes trouble (it shouldn't though)"})
        public boolean disableKeroseneLampFakeAirBlock = false;
        @Config.Comment(value={"The amount by which any liquid tank's contents must change, as a proportion of the tank's total capacity, to trigger an update to clients. Larger values mean fewer updates but less granularity in client-side fluid rendering."})
        @Config.RangeDouble(min=1.0E-4, max=1.0)
        @Config.RequiresWorldRestart
        public double liquidTankUpdateThreshold = 0.01;
    }

    public static class MachineProperties {
        @Config.Comment(value={"Changing this value will alter the pressurized air usage of the Pneumatic Generator. The output, EU, will stay the same."})
        public int pneumaticGeneratorEfficiency = 40;
        @Config.Comment(value={"Changing this value will alter the pressurized air production of the Electric Compressor. The input, EU, will stay the same"})
        public int electricCompressorEfficiency = 40;
        @Config.Comment(value={"Changing this value will alter the pressurized air production of the Flux Compressor. The input, RF, will stay the same"})
        public int fluxCompressorEfficiency = 40;
        @Config.Comment(value={"Changing this value will alter the pressurized air usage of the Pneumatic Dynamo. The output, RF, will stay the same"})
        public int pneumaticDynamoEfficiency = 40;
        @Config.Comment(value={"The max height of an elevator per stacked Elevator Base."})
        @Config.RangeInt(min=1, max=256)
        public int elevatorBaseBlocksPerBase = 4;
        @Config.Comment(value={"Can the Kerosene Lamp burn any kind of fuel?  If false, only Kerosene can be burnt"})
        public boolean keroseneLampCanUseAnyFuel = true;
        @Config.Comment(value={"Kerosene Lamp fuel efficiency: higher values mean fuel will last longer in the lamp"})
        public float keroseneLampFuelEfficiency = 1.0f;
        @Config.Comment(value={"Speed multiplier per speed upgrade: speed mult = speedUpgradeSpeedMultiplier ^ num_of_speed_upgrades"})
        @Config.RangeDouble(min=1.0, max=2.0)
        public double speedUpgradeSpeedMultiplier = 1.5;
        @Config.Comment(value={"Fuel usage / heat gen multiplier per speed upgrade: usage mult = speedUpgradeUsageMultiplier ^ num_of_speed_upgrades"})
        @Config.RangeDouble(min=1.0, max=2.0)
        public double speedUpgradeUsageMultiplier = 1.65f;
        @Config.Comment(value={"Base chance (1/x) per tick of a lightning strike on/around the Electrostatic Generator"})
        public int electrostaticLightningChance = 100000;
        @Config.Comment(value={"Can the Liquid Dispenser absorb/dispense fluids into the world with a Dispenser Upgrade?"})
        @Config.RequiresWorldRestart
        public boolean liquidHopperDispenser = true;
    }

    public static class General {
        @Config.Comment(value={"Chance per chunk in percentage to generate an Oil Lake. Set to 0 for no spawns"})
        @Config.RangeDouble(min=0.0, max=100.0)
        @Config.RequiresMcRestart
        public double oilGenerationChance = 15.0;
        @Config.Comment(value={"Loss percentage (on average) of Compressed Iron ingots/blocks when exposed to an explosion. Note: this can also be controlled via CraftTweaker."})
        @Config.RangeInt(min=0, max=100)
        @Config.RequiresMcRestart
        public int configCompressedIngotLossRate = 20;
        @Config.Comment(value={"Enables the dungeon loot generation of the Nuke Virus and Stop! Worm (not useful in single-player worlds)"})
        public boolean enableDungeonLoot = true;
        @Config.Comment(value={"Damage of the Miniguns. This applies to the Sentry Gun, Handheld Minigun, and Drone-based minigun"})
        public float configMinigunDamage = 4.0f;
        @Config.Comment(value={"Enable Drone Suffocation Damage"})
        public boolean enableDroneSuffocationDamage = true;
        @Config.Comment(value={"Efficiency of fuel buckets as furnace fuel (default 0.05 means 1 bucket of LPG smelts 450 items in a vanilla furnace"})
        public float fuelBucketEfficiencyMultiplier = 0.05f;
        @Config.Comment(value={"Maximum number of blocks in the area defined in an Area Programming Puzzle Piece"})
        public int maxProgrammingArea = 250000;
        @Config.Comment(value={"Enable/disable explosion crafting (iron->compressed iron).  If you disable this, you'll need another way to get compressed iron initially."})
        public boolean explosionCrafting = true;
        @Config.Comment(value={"Oil worldgen blacklist: add dimension IDs to this list if you don't want oil worldgen to happen there."})
        @Config.RequiresMcRestart
        public int[] oilWorldGenBlacklist = new int[]{1, -1};
        @Config.Comment(value={"Thermal resistance of non-vanilla fluids, which is how fast heat moves between them and adjacent heat-handling blocks like the refinery.  Lower values mean faster heat movement."})
        @Config.RequiresWorldRestart
        public double fluidThermalResistance = 500.0;
        @Config.Comment(value={"Chance per shot (1 in X) of potion-tipped ammo proc'ing the potion effect"})
        public int minigunPotionProcChance = 15;
        @Config.Comment(value={"Fluids as hot or hotter than this temperature (Kelvin) will be auto-registered as Liquid Compressor fuels, the quality being dependent on fluid temperature."})
        @Config.RequiresMcRestart
        public int minimumFluidFuelTemperature = 373;
    }
}

