/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import com.google.common.base.Predicate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.client.model.module.ModelAirGrate;
import me.desht.pneumaticcraft.client.model.module.ModelModuleBase;
import me.desht.pneumaticcraft.client.render.RenderRangeLines;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.ai.StringFilterEntitySelector;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.tileentity.TileEntityHeatSink;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.lib.EnumCustomParticleType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ModuleAirGrate
extends TubeModule {
    private int grateRange;
    private boolean vacuum;
    public String entityFilter = "";
    private final Set<TileEntityHeatSink> heatSinks = new HashSet<TileEntityHeatSink>();
    private final RenderRangeLines rangeLineRenderer = new RenderRangeLines(0x5500FF00);
    private boolean resetRendering = true;

    private int getRange() {
        float range = this.pressureTube.getAirHandler(null).getPressure() * 4.0f;
        boolean bl = this.vacuum = range < 0.0f;
        if (this.vacuum) {
            range = -range * 4.0f;
        }
        return (int)range;
    }

    @Override
    public double getWidth() {
        return 1.0;
    }

    @Override
    public void update() {
        super.update();
        World world = this.pressureTube.world();
        BlockPos pos = this.pressureTube.pos();
        Vec3d tileVec = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        if (!world.field_72995_K) {
            int oldGrateRange = this.grateRange;
            this.grateRange = this.getRange();
            this.pressureTube.getAirHandler(null).addAir((this.vacuum ? 1 : -1) * this.grateRange * 10);
            if (oldGrateRange != this.grateRange) {
                this.sendDescriptionPacket();
            }
            this.coolHeatSinks(world, pos, this.grateRange);
        } else {
            if (this.resetRendering) {
                this.rangeLineRenderer.resetRendering(this.grateRange);
                this.resetRendering = false;
            }
            this.rangeLineRenderer.update();
        }
        this.pushEntities(world, pos, tileVec);
    }

    private AxisAlignedBB getAffectedAABB() {
        return new AxisAlignedBB(this.pressureTube.pos()).func_186662_g((double)this.grateRange);
    }

    private void pushEntities(World world, BlockPos pos, Vec3d tileVec) {
        AxisAlignedBB bbBox = this.getAffectedAABB();
        List entities = world.func_175647_a(Entity.class, bbBox, (Predicate)new StringFilterEntitySelector().setFilter(this.entityFilter));
        double d0 = (double)this.grateRange + 0.5;
        for (Entity entity : entities) {
            double d3;
            double d2;
            double d1;
            double d4;
            double d5;
            Vec3d entityVec;
            RayTraceResult trace;
            if (!entity.field_70170_p.field_72995_K && entity instanceof EntityItem && entity.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) < 0.6 && !entity.field_70128_L) {
                ItemStack leftover = ((EntityItem)entity).func_92059_d();
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    TileEntity inv = this.pressureTube.world().func_175625_s(pos.func_177972_a(dir));
                    leftover = IOHelper.insert(inv, leftover, dir.func_176734_d(), false);
                    if (leftover.func_190926_b()) break;
                }
                if (leftover.func_190926_b()) {
                    entity.func_70106_y();
                    continue;
                }
                ((EntityItem)entity).func_92058_a(leftover);
                continue;
            }
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d || (trace = world.func_72933_a(entityVec = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), tileVec)) == null || !trace.func_178782_a().equals((Object)pos) || !((d5 = 1.0 - (d4 = Math.sqrt((d1 = (entity.field_70165_t - (double)pos.func_177958_n() - 0.5) / d0) * d1 + (d2 = (entity.field_70163_u + (double)entity.func_70047_e() - (double)pos.func_177956_o() - 0.5) / d0) * d2 + (d3 = (entity.field_70161_v - (double)pos.func_177952_p() - 0.5) / d0) * d3))) > 0.0)) continue;
            d5 *= d5;
            if (!this.vacuum) {
                d5 *= -1.0;
            }
            entity.field_70159_w -= d1 / d4 * d5 * 0.1;
            entity.field_70181_x -= d2 / d4 * d5 * 0.1;
            entity.field_70179_y -= d3 / d4 * d5 * 0.1;
            if (!world.field_72995_K || !(world.field_73012_v.nextDouble() * 0.85 > d4)) continue;
            Vec3d vec = new Vec3d((double)pos.func_177958_n() + 0.5 + d1, (double)pos.func_177956_o() + 0.5 + d2, (double)pos.func_177952_p() + 0.5 + d3);
            PneumaticCraftRepressurized.proxy.playCustomParticle(EnumCustomParticleType.AIR_PARTICLE_DENSE, world, (double)pos.func_177958_n() + 0.5 + d1, (double)pos.func_177956_o() + 0.5 + d2, (double)pos.func_177952_p() + 0.5 + d3, d1, d2, d3);
        }
    }

    private void coolHeatSinks(World world, BlockPos pos, int range) {
        if (this.grateRange > 2) {
            int curTeIndex = (int)(world.func_82737_E() % 27L);
            BlockPos curPos = pos.func_177967_a(this.dir, 2).func_177982_a(-1 + curTeIndex % 3, -1 + curTeIndex / 3 % 3, -1 + curTeIndex / 9 % 3);
            TileEntity te = world.func_175625_s(curPos);
            if (te instanceof TileEntityHeatSink) {
                this.heatSinks.add((TileEntityHeatSink)te);
            }
            Iterator<TileEntityHeatSink> iterator = this.heatSinks.iterator();
            while (iterator.hasNext()) {
                TileEntityHeatSink heatSink = iterator.next();
                if (heatSink.func_145837_r()) {
                    iterator.remove();
                    continue;
                }
                for (int i = 0; i < 4; ++i) {
                    heatSink.onFannedByAirGrate();
                }
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.vacuum = tag.func_74767_n("vacuum");
        this.grateRange = tag.func_74762_e("grateRange");
        this.entityFilter = tag.func_74779_i("entityFilter");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("vacuum", this.vacuum);
        tag.func_74768_a("grateRange", this.grateRange);
        tag.func_74778_a("entityFilter", this.entityFilter);
    }

    @Override
    public String getType() {
        return "air_grate_module";
    }

    @Override
    public void addInfo(List<String> curInfo) {
        curInfo.add("Status: " + TextFormatting.WHITE + (this.grateRange == 0 ? "Idle" : (this.vacuum ? "Attracting" : "Repelling")));
        curInfo.add("Range: " + TextFormatting.WHITE + this.grateRange + " blocks");
        if (!this.entityFilter.equals("")) {
            curInfo.add("Entity Filter: " + TextFormatting.WHITE + "\"" + this.entityFilter + "\"");
        }
    }

    @Override
    public void addItemDescription(List<String> curInfo) {
        curInfo.add(TextFormatting.BLUE + "Formula: Range(blocks) = 4.0 x pressure(bar),");
        curInfo.add(TextFormatting.BLUE + "or -16 x pressure(bar), if vacuum");
        curInfo.add("This module will attract or repel any entity");
        curInfo.add("within range dependant on whether it is in");
        curInfo.add("vacuum or under pressure respectively.");
    }

    @Override
    protected GuiHandler.EnumGuiId getGuiId() {
        return GuiHandler.EnumGuiId.AIR_GRATE_MODULE;
    }

    @Override
    public Class<? extends ModelModuleBase> getModelClass() {
        return ModelAirGrate.class;
    }

    @Override
    public void doExtraRendering() {
        this.rangeLineRenderer.render();
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return this.getAffectedAABB();
    }
}

