/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.awt.Color;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftCamo;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAphorismTile;
import me.desht.pneumaticcraft.common.tileentity.TileEntityCompressedIronBlock;
import me.desht.pneumaticcraft.common.tileentity.TileEntityUVLightBox;
import me.desht.pneumaticcraft.common.tileentity.TileEntityVortexTube;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockColorHandler {
    public static void registerColorHandlers() {
        IBlockColor heatColor = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                TileEntity te = blockAccess.func_175625_s(pos);
                int heatLevel = 10;
                if (te instanceof TileEntityCompressedIronBlock) {
                    heatLevel = ((TileEntityCompressedIronBlock)te).getHeatLevel();
                } else if (te instanceof TileEntityVortexTube) {
                    switch (tintIndex) {
                        case 0: {
                            heatLevel = ((TileEntityVortexTube)te).getHotHeatLevel();
                            break;
                        }
                        case 1: {
                            heatLevel = ((TileEntityVortexTube)te).getColdHeatLevel();
                        }
                    }
                }
                float[] color = HeatUtil.getColorForHeatLevel(heatLevel);
                return -16777216 + ((int)(color[0] * 255.0f) << 16) + ((int)(color[1] * 255.0f) << 8) + (int)(color[2] * 255.0f);
            }
            return -1;
        };
        Minecraft.func_71410_x().func_184125_al().func_186722_a(heatColor, new Block[]{Blockss.COMPRESSED_IRON, Blockss.HEAT_SINK, Blockss.VORTEX_TUBE});
        IBlockColor uvLightBoxLampColor = (state, blockAccess, pos, tintIndex) -> {
            TileEntity te;
            if (blockAccess != null && pos != null && (te = blockAccess.func_175625_s(pos)) instanceof TileEntityUVLightBox) {
                return ((TileEntityUVLightBox)te).areLightsOn ? -12582657 : -5263388;
            }
            return -5263388;
        };
        Minecraft.func_71410_x().func_184125_al().func_186722_a(uvLightBoxLampColor, new Block[]{Blockss.UV_LIGHT_BOX});
        IBlockColor camoColor = (state, worldIn, pos, tintIndex) -> {
            if (pos == null || worldIn == null) {
                return 0xFFFFFF;
            }
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof ICamouflageableTE && ((ICamouflageableTE)te).getCamouflage() != null) {
                return Minecraft.func_71410_x().func_184125_al().func_186724_a(((ICamouflageableTE)te).getCamouflage(), (IBlockAccess)te.func_145831_w(), pos, tintIndex);
            }
            return 0xFFFFFF;
        };
        for (Block b : Blockss.blocks) {
            if (!(b instanceof BlockPneumaticCraftCamo)) continue;
            Minecraft.func_71410_x().func_184125_al().func_186722_a(camoColor, new Block[]{b});
        }
        IBlockColor aphorismTileColor = (state, worldIn, pos, tintIndex) -> {
            TileEntity te;
            if (worldIn != null && pos != null && (te = worldIn.func_175625_s(pos)) instanceof TileEntityAphorismTile) {
                switch (tintIndex) {
                    case 0: {
                        int dmg = ((TileEntityAphorismTile)te).getBorderColor();
                        return EnumDyeColor.func_176766_a((int)dmg).func_193350_e();
                    }
                    case 1: {
                        int dmg = ((TileEntityAphorismTile)te).getBackgroundColor();
                        return BlockColorHandler.desaturate(EnumDyeColor.func_176766_a((int)dmg).func_193350_e());
                    }
                }
                return 0xFFFFFF;
            }
            return 0xFFFFFF;
        };
        Minecraft.func_71410_x().func_184125_al().func_186722_a(aphorismTileColor, new Block[]{Blockss.APHORISM_TILE});
    }

    private static int desaturate(int c) {
        float[] hsb = Color.RGBtoHSB((c & 0xFF0000) >> 16, (c & 0xFF00) >> 8, c & 0xFF, null);
        Color color = Color.getHSBColor(hsb[0], hsb[1] * 0.4f, hsb[2]);
        if ((double)hsb[2] < 0.7) {
            color = color.brighter();
        }
        return color.getRGB();
    }
}

