/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.CommonHUDHandler;
import me.desht.pneumaticcraft.common.ai.ChunkPositionSorter;
import me.desht.pneumaticcraft.common.ai.DroneClaimManager;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.ThreadedSorter;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;

public abstract class DroneAIBlockInteraction<Widget extends ProgWidgetAreaItemBase>
extends EntityAIBase {
    protected final IDroneBase drone;
    protected final Widget widget;
    private final IBlockOrdered.EnumOrder order;
    protected BlockPos curPos;
    private final List<BlockPos> area;
    protected final IBlockAccess worldCache;
    private final List<BlockPos> blacklist = new ArrayList<BlockPos>();
    private int curY;
    private int lastSuccessfulY;
    private int minY;
    private int maxY;
    private ThreadedSorter<BlockPos> sorter;
    private boolean aborted;
    protected boolean searching;
    private int searchIndex;
    private static final int LOOKUPS_PER_SEARCH_TICK = 30;
    private int totalActions;
    private int maxActions = -1;

    public DroneAIBlockInteraction(IDroneBase drone, Widget widget) {
        this.drone = drone;
        this.func_75248_a(63);
        this.widget = widget;
        this.order = widget instanceof IBlockOrdered ? ((IBlockOrdered)widget).getOrder() : IBlockOrdered.EnumOrder.CLOSEST;
        this.area = ((ProgWidgetAreaItemBase)widget).getCachedAreaList();
        this.worldCache = ProgWidgetAreaItemBase.getCache(this.area, drone.world());
        if (this.area.size() > 0) {
            Iterator<BlockPos> iterator = this.area.iterator();
            BlockPos pos = iterator.next();
            this.minY = this.maxY = pos.func_177956_o();
            while (iterator.hasNext()) {
                pos = iterator.next();
                this.minY = Math.min(this.minY, pos.func_177956_o());
                this.maxY = Math.max(this.maxY, pos.func_177956_o());
            }
            if (this.order == IBlockOrdered.EnumOrder.HIGH_TO_LOW) {
                this.curY = this.maxY;
            } else if (this.order == IBlockOrdered.EnumOrder.LOW_TO_HIGH) {
                this.curY = this.minY;
            }
        }
    }

    public boolean func_75250_a() {
        if (this.aborted || this.maxActions >= 0 && this.totalActions >= this.maxActions) {
            return false;
        }
        if (!this.searching) {
            this.searching = true;
            this.searchIndex = 0;
            this.curPos = null;
            this.lastSuccessfulY = this.curY;
            if (this.sorter == null || this.sorter.isDone()) {
                this.sorter = new ThreadedSorter<BlockPos>(this.area, new ChunkPositionSorter(this.drone));
            }
            return true;
        }
        return false;
    }

    private void updateY() {
        this.searchIndex = 0;
        if (this.order == IBlockOrdered.EnumOrder.LOW_TO_HIGH) {
            if (++this.curY > this.maxY) {
                this.curY = this.minY;
            }
        } else if (this.order == IBlockOrdered.EnumOrder.HIGH_TO_LOW && --this.curY < this.minY) {
            this.curY = this.maxY;
        }
    }

    private boolean isYValid(int y) {
        return this.order == IBlockOrdered.EnumOrder.CLOSEST || y == this.curY;
    }

    public DroneAIBlockInteraction<Widget> setMaxActions(int maxActions) {
        this.maxActions = maxActions;
        return this;
    }

    protected abstract boolean isValidPosition(BlockPos var1);

    protected abstract boolean doBlockInteraction(BlockPos var1, double var2);

    public boolean func_75253_b() {
        double dist;
        if (this.aborted) {
            return false;
        }
        if (this.searching) {
            if (!this.sorter.isDone()) {
                return true;
            }
            boolean firstRun = true;
            int searchedBlocks = 0;
            while (this.curPos == null && this.curY != this.lastSuccessfulY && this.order != IBlockOrdered.EnumOrder.CLOSEST || firstRun) {
                firstRun = false;
                while (!this.shouldAbort() && this.searchIndex < this.area.size()) {
                    BlockPos pos = this.area.get(this.searchIndex);
                    if (!(!this.isYValid(pos.func_177956_o()) || this.blacklist.contains(pos) || this.respectClaims() && DroneClaimManager.getInstance(this.drone.world()).isClaimed(pos))) {
                        this.indicateToListeningPlayers(pos);
                        if (this.isValidPosition(pos)) {
                            this.curPos = pos;
                            if (this.moveToPositions()) {
                                if (this.moveIntoBlock()) {
                                    if (this.drone.getPathNavigator().moveToXYZ(this.curPos.func_177958_n(), (double)this.curPos.func_177956_o() + 0.5, this.curPos.func_177952_p())) {
                                        this.searching = false;
                                        ++this.totalActions;
                                        if (this.respectClaims()) {
                                            DroneClaimManager.getInstance(this.drone.world()).claim(pos);
                                        }
                                        this.blacklist.clear();
                                        return true;
                                    }
                                } else {
                                    for (EnumFacing dir : EnumFacing.field_82609_l) {
                                        if (!this.drone.getPathNavigator().moveToXYZ(this.curPos.func_177958_n() + dir.func_82601_c(), (double)(this.curPos.func_177956_o() + dir.func_96559_d()) + 0.5, this.curPos.func_177952_p() + dir.func_82599_e())) continue;
                                        this.searching = false;
                                        ++this.totalActions;
                                        if (this.respectClaims()) {
                                            DroneClaimManager.getInstance(this.drone.world()).claim(pos);
                                        }
                                        this.blacklist.clear();
                                        return true;
                                    }
                                }
                                if (this.drone.getPathNavigator().isGoingToTeleport()) {
                                    this.searching = false;
                                    ++this.totalActions;
                                    if (this.respectClaims()) {
                                        DroneClaimManager.getInstance(this.drone.world()).claim(pos);
                                    }
                                    this.blacklist.clear();
                                    return true;
                                }
                                this.drone.addDebugEntry("gui.progWidget.general.debug.cantNavigate", pos);
                            } else {
                                this.searching = false;
                                ++this.totalActions;
                                return true;
                            }
                        }
                        ++searchedBlocks;
                    }
                    ++this.searchIndex;
                    if (searchedBlocks < this.lookupsPerSearch()) continue;
                    return true;
                }
                if (this.curPos != null) continue;
                this.updateY();
            }
            if (!this.shouldAbort()) {
                this.addEndingDebugEntry();
            }
            return false;
        }
        Vec3d dronePos = this.drone.getDronePos();
        double d = dist = this.curPos != null ? PneumaticCraftUtils.distBetween((double)this.curPos.func_177958_n() + 0.5, (double)this.curPos.func_177956_o() + 0.5, (double)this.curPos.func_177952_p() + 0.5, dronePos.field_72450_a, dronePos.field_72448_b, dronePos.field_72449_c) : 0.0;
        if (this.curPos != null) {
            if (!this.moveToPositions()) {
                return this.doBlockInteraction(this.curPos, dist);
            }
            if (this.respectClaims()) {
                DroneClaimManager.getInstance(this.drone.world()).claim(this.curPos);
            }
            int n = this.moveIntoBlock() ? 1 : 2;
            if (dist < (double)n) {
                return this.doBlockInteraction(this.curPos, dist);
            }
        }
        return !this.drone.getPathNavigator().hasNoPath();
    }

    protected void addEndingDebugEntry() {
        this.drone.addDebugEntry("gui.progWidget.blockInteraction.debug.noBlocksValid");
    }

    protected int lookupsPerSearch() {
        return 30;
    }

    protected boolean respectClaims() {
        return false;
    }

    protected boolean moveIntoBlock() {
        return false;
    }

    protected boolean shouldAbort() {
        return this.aborted;
    }

    public void abort() {
        this.aborted = true;
    }

    protected boolean moveToPositions() {
        return true;
    }

    protected void indicateToListeningPlayers(BlockPos pos) {
        for (EntityPlayer player : this.drone.world().field_73010_i) {
            CommonHUDHandler handler;
            ItemStack helmet;
            if (!(player.func_174818_b(pos) < 1024.0) || (helmet = player.func_184582_a(EntityEquipmentSlot.HEAD)).func_77973_b() != Itemss.PNEUMATIC_HELMET || !(handler = CommonHUDHandler.getHandlerForPlayer(player)).isArmorReady(EntityEquipmentSlot.HEAD) || !handler.isEntityTrackerEnabled() || handler.getUpgradeCount(EntityEquipmentSlot.HEAD, IItemRegistry.EnumUpgrade.ENTITY_TRACKER) <= 0 || handler.getUpgradeCount(EntityEquipmentSlot.HEAD, IItemRegistry.EnumUpgrade.DISPENSER) <= 0) continue;
            NetworkHandler.sendTo(new PacketSpawnParticle(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0), (EntityPlayerMP)player);
        }
    }

    protected void addToBlacklist(BlockPos coord) {
        this.blacklist.add(coord);
        this.drone.sendWireframeToClient(coord);
    }
}

