/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler;

import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.client.gui.pneumaticHelmet.GuiCoordinateTrackerOptions;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.RenderCoordWireframe;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.RenderNavigator;
import me.desht.pneumaticcraft.common.ai.EntityPathNavigateDrone;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketCoordTrackUpdate;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CoordTrackUpgradeHandler
implements IUpgradeRenderHandler {
    private RenderCoordWireframe coordTracker;
    private RenderNavigator navigator;
    public boolean isListeningToCoordTrackerSetting = false;
    public boolean pathEnabled;
    public boolean wirePath;
    public boolean xRayEnabled;
    private int pathCalculateCooldown;
    private int noPathCooldown;
    public int pathUpdateSetting;
    public static final int SEARCH_RANGE = 150;

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getUpgradeName() {
        return "coordinateTracker";
    }

    @Override
    public void initConfig() {
        this.pathEnabled = ConfigHandler.helmetOptions.pathEnabled;
        this.wirePath = ConfigHandler.helmetOptions.wirePath;
        this.xRayEnabled = ConfigHandler.helmetOptions.xRayEnabled;
        this.pathUpdateSetting = ConfigHandler.helmetOptions.pathUpdateSetting;
    }

    @Override
    public void saveToConfig() {
        ConfigHandler.helmetOptions.pathEnabled = this.pathEnabled;
        ConfigHandler.helmetOptions.wirePath = this.wirePath;
        ConfigHandler.helmetOptions.xRayEnabled = this.xRayEnabled;
        ConfigHandler.helmetOptions.pathUpdateSetting = this.pathUpdateSetting;
        ConfigHandler.sync();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void update(EntityPlayer player, int rangeUpgrades) {
        if (this.coordTracker != null) {
            ++this.coordTracker.ticksExisted;
        } else {
            this.coordTracker = ItemPneumaticArmor.getCoordTrackLocation(player.func_184582_a(EntityEquipmentSlot.HEAD));
            if (this.coordTracker != null) {
                this.navigator = new RenderNavigator(this.coordTracker.world, this.coordTracker.pos);
            }
        }
        if (this.noPathCooldown > 0) {
            --this.noPathCooldown;
        }
        if (this.navigator != null && this.pathEnabled && this.noPathCooldown == 0 && --this.pathCalculateCooldown <= 0) {
            this.navigator.updatePath();
            if (!this.navigator.tracedToDestination()) {
                this.noPathCooldown = 100;
            }
            this.pathCalculateCooldown = this.pathUpdateSetting == 2 ? 1 : (this.pathUpdateSetting == 1 ? 20 : 100);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render3D(float partialTicks) {
        if (this.coordTracker != null) {
            if (FMLClientHandler.instance().getClient().field_71439_g.field_70170_p.field_73011_w.getDimension() != this.coordTracker.world.field_73011_w.getDimension()) {
                return;
            }
            this.coordTracker.render(partialTicks);
            if (this.pathEnabled && this.navigator != null) {
                this.navigator.render(this.wirePath, this.xRayEnabled, partialTicks);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render2D(float partialTicks, boolean upgradeEnabled) {
    }

    @Override
    public Item[] getRequiredUpgrades() {
        return new Item[]{Itemss.upgrades.get(IItemRegistry.EnumUpgrade.COORDINATE_TRACKER)};
    }

    @Override
    public float getEnergyUsage(int rangeUpgrades, EntityPlayer player) {
        return 1.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void reset() {
        this.coordTracker = null;
        this.navigator = null;
    }

    @SubscribeEvent
    public boolean onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (this.isListeningToCoordTrackerSetting) {
            this.isListeningToCoordTrackerSetting = false;
            EnumFacing dir = event.getFace();
            this.reset();
            ItemStack stack = event.getEntityPlayer().func_184582_a(EntityEquipmentSlot.HEAD);
            if (!stack.func_190926_b()) {
                NBTTagCompound tag = NBTUtil.getCompoundTag(stack, "CoordTracker");
                tag.func_74768_a("dimID", event.getEntity().field_70170_p.field_73011_w.getDimension());
                NBTUtil.setPos(tag, (Vec3i)event.getPos().func_177972_a(dir));
            }
            assert (dir != null);
            NetworkHandler.sendToServer(new PacketCoordTrackUpdate(event.getEntity().field_70170_p, event.getPos().func_177972_a(dir)));
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumNavigationResult navigateToSurface(EntityPlayer player) {
        BlockPos pathPos;
        PathPoint pathPoint;
        int i;
        World world = player.field_70170_p;
        BlockPos navigatingPos = world.func_175645_m(new BlockPos((Entity)player));
        Path path = PneumaticCraftUtils.getPathFinder().func_186336_a((IBlockAccess)world, PneumaticCraftUtils.createDummyEntity(player), navigatingPos, 150.0f);
        if (path != null) {
            for (i = 0; i < path.func_75874_d(); ++i) {
                pathPoint = path.func_75877_a(i);
                pathPos = new BlockPos(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c);
                if (!world.func_175678_i(pathPos)) continue;
                this.coordTracker = new RenderCoordWireframe(world, pathPos);
                this.navigator = new RenderNavigator(world, pathPos);
                return EnumNavigationResult.EASY_PATH;
            }
        }
        if ((path = CoordTrackUpgradeHandler.getDronePath(player, navigatingPos)) != null) {
            for (i = 0; i < path.func_75874_d(); ++i) {
                pathPoint = path.func_75877_a(i);
                pathPos = new BlockPos(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c);
                if (!world.func_175678_i(pathPos)) continue;
                this.coordTracker = new RenderCoordWireframe(world, pathPos);
                this.navigator = new RenderNavigator(world, pathPos);
                return EnumNavigationResult.DRONE_PATH;
            }
        }
        return EnumNavigationResult.NO_PATH;
    }

    public static Path getDronePath(EntityPlayer player, BlockPos pos) {
        World world = player.field_70170_p;
        EntityDrone drone = new EntityDrone(world);
        drone.func_70107_b(player.field_70165_t, player.field_70163_u - 2.0, player.field_70161_v);
        return new EntityPathNavigateDrone(drone, world).func_179680_a(pos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IOptionPage getGuiOptionsPage() {
        return new GuiCoordinateTrackerOptions();
    }

    @Override
    public EntityEquipmentSlot getEquipmentSlot() {
        return EntityEquipmentSlot.HEAD;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiAnimatedStat getAnimatedStat() {
        return null;
    }

    public static enum EnumNavigationResult {
        NO_PATH,
        EASY_PATH,
        DRONE_PATH;

    }
}

