/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.IGuiWidget;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.inventory.ContainerElevator;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElevatorBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiElevator
extends GuiPneumaticContainerBase<TileEntityElevatorBase> {
    private GuiAnimatedStat statusStat;
    private GuiAnimatedStat floorNameStat;
    private int currentEditedFloor;
    private WidgetTextField floorNameField;

    public GuiElevator(InventoryPlayer player, TileEntityElevatorBase te) {
        super(new ContainerElevator(player, te), te, "pneumaticcraft:textures/gui/gui_elevator.png");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.statusStat = this.addAnimatedStat("Elevator Status", new ItemStack(Blockss.ELEVATOR_BASE), -22016, false);
        this.floorNameStat = this.addAnimatedStat("Floor Names", new ItemStack(Blockss.ELEVATOR_CALLER), -16755456, false);
        this.floorNameStat.setTextWithoutCuttingString(this.getFloorNameStat());
        Rectangle fieldRectangle = this.floorNameStat.getButtonScaledRectangle(6, 60, 160, 20);
        this.floorNameField = this.getTextFieldFromRectangle(fieldRectangle);
        this.floorNameField.func_146180_a(((TileEntityElevatorBase)this.te).getFloorName(this.currentEditedFloor));
        this.floorNameStat.addWidget(this.floorNameField);
        Rectangle namePreviousRectangle = this.floorNameStat.getButtonScaledRectangle(5, 35, 40, 20);
        this.floorNameStat.addWidget(this.getButtonFromRectangle(1, namePreviousRectangle, "<-"));
        Rectangle nameNextRectangle = this.floorNameStat.getButtonScaledRectangle(125, 35, 40, 20);
        this.floorNameStat.addWidget(this.getButtonFromRectangle(2, nameNextRectangle, "->"));
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.field_146289_q.func_78276_b("Upgr.", 28, 19, 0x404040);
    }

    @Override
    protected void func_146976_a(float opacity, int x, int y) {
        super.func_146976_a(opacity, x, y);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.statusStat.setText(this.getStatusText());
    }

    private List<String> getFloorNameStat() {
        int i;
        ArrayList<String> textList = new ArrayList<String>();
        for (i = 0; i < 3; ++i) {
            textList.add("");
        }
        textList.add("\u00a77         Floor " + (this.currentEditedFloor + 1) + "                   ");
        for (i = 0; i < 3; ++i) {
            textList.add("");
        }
        return textList;
    }

    private List<String> getStatusText() {
        ArrayList<String> text = new ArrayList<String>();
        text.add("\u00a77Current Extension:");
        text.add("\u00a70" + PneumaticCraftUtils.roundNumberTo(((TileEntityElevatorBase)this.te).extension, 1) + " meter");
        text.add("\u00a77Max Extension:");
        text.add("\u00a70" + PneumaticCraftUtils.roundNumberTo(((TileEntityElevatorBase)this.te).getMaxElevatorHeight(), 1) + " meter");
        return text;
    }

    @Override
    protected void addProblems(List<String> textList) {
        super.addProblems(textList);
        float elevatorHeight = ((TileEntityElevatorBase)this.te).getMaxElevatorHeight();
        if (elevatorHeight == ((TileEntityElevatorBase)this.te).extension) {
            textList.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a77The elevator can't extend anymore.", 26));
            textList.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a70Add (more) Elevator Frames on top of the elevator", 26));
        }
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        super.actionPerformed(widget);
        if (widget.getID() == 1 || widget.getID() == 2) {
            int[] floorHeights = ((TileEntityElevatorBase)this.te).floorHeights;
            if (widget.getID() == 1) {
                --this.currentEditedFloor;
                if (this.currentEditedFloor < 0) {
                    this.currentEditedFloor = floorHeights.length - 1;
                    if (floorHeights.length == 0) {
                        this.currentEditedFloor = 0;
                    }
                }
            } else {
                ++this.currentEditedFloor;
                if (this.currentEditedFloor >= floorHeights.length) {
                    this.currentEditedFloor = 0;
                }
            }
            this.floorNameField.func_146180_a(((TileEntityElevatorBase)this.te).getFloorName(this.currentEditedFloor));
            this.floorNameStat.setTextWithoutCuttingString(this.getFloorNameStat());
        }
    }

    @Override
    public void onKeyTyped(IGuiWidget widget) {
        ((TileEntityElevatorBase)this.te).setFloorName(this.currentEditedFloor, this.floorNameField.func_146179_b());
        NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, this.currentEditedFloor));
    }
}

