/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.awt.Point;
import java.util.List;
import me.desht.pneumaticcraft.api.item.IPressurizable;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.common.inventory.ContainerChargingStation;
import me.desht.pneumaticcraft.common.item.IChargingStationGUIHolderItem;
import me.desht.pneumaticcraft.common.tileentity.TileEntityChargingStation;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiChargingStation
extends GuiPneumaticContainerBase<TileEntityChargingStation> {
    private GuiButton guiSelectButton;

    public GuiChargingStation(InventoryPlayer player, TileEntityChargingStation te) {
        super(new ContainerChargingStation(player, te), te, "pneumaticcraft:textures/gui/gui_charging_station.png");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        this.guiSelectButton = new GuiButton(1, xStart + 87, yStart + 15, 25, 20, "inv.");
        this.field_146292_n.add(this.guiSelectButton);
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.field_146289_q.func_78276_b("Upgr.", 46, 19, 0x404040);
    }

    @Override
    protected Point getInvTextOffset() {
        return new Point(20, 0);
    }

    @Override
    protected void func_146976_a(float opacity, int x, int y) {
        super.func_146976_a(opacity, x, y);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderAir();
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.guiSelectButton.field_146124_l = ((TileEntityChargingStation)this.te).getPrimaryInventory().getStackInSlot(0).func_77973_b() instanceof IChargingStationGUIHolderItem;
    }

    @Override
    protected Point getGaugeLocation() {
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        return new Point(xStart + this.field_146999_f * 3 / 4 + 10, yStart + this.field_147000_g / 4 + 4);
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        if (((TileEntityChargingStation)this.te).charging || ((TileEntityChargingStation)this.te).disCharging) {
            pressureStatText.add("\u00a77" + (((TileEntityChargingStation)this.te).charging ? "C" : "Disc") + "harging at");
            pressureStatText.add("\u00a70" + (double)Math.round(10.0f * ((TileEntityChargingStation)this.te).getSpeedMultiplierFromUpgrades()) + "mL/tick");
        }
    }

    @Override
    protected void addProblems(List<String> textList) {
        super.addProblems(textList);
        ItemStack chargeStack = ((TileEntityChargingStation)this.te).getPrimaryInventory().getStackInSlot(0);
        if (!chargeStack.func_190926_b() && !(chargeStack.func_77973_b() instanceof IPressurizable)) {
            textList.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a77The inserted item can't be (dis)charged", 26));
            textList.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a70Put a pneumatic item in the charge slot.", 26));
        }
    }

    @Override
    protected void addWarnings(List<String> curInfo) {
        super.addWarnings(curInfo);
        ItemStack chargeStack = ((TileEntityChargingStation)this.te).getPrimaryInventory().getStackInSlot(0);
        if (chargeStack.func_190926_b()) {
            curInfo.add("\u00a7fNo items to (dis)charge");
            curInfo.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a70Put a pneumatic item in the charge slot.", 26));
        } else if (chargeStack.func_77973_b() instanceof IPressurizable) {
            String name = chargeStack.func_82833_r();
            IPressurizable chargeItem = (IPressurizable)chargeStack.func_77973_b();
            if (chargeItem.getPressure(chargeStack) > ((TileEntityChargingStation)this.te).getPressure() + 0.01f && chargeItem.getPressure(chargeStack) <= 0.0f) {
                curInfo.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a7fThe " + name + " can't be discharged", 26));
                curInfo.add("\u00a70The item is empty.");
            } else if (chargeItem.getPressure(chargeStack) < ((TileEntityChargingStation)this.te).getPressure() - 0.01f && chargeItem.getPressure(chargeStack) >= chargeItem.maxPressure(chargeStack)) {
                curInfo.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a7fThe " + name + " can't be charged", 26));
                curInfo.add("\u00a70The item is full.");
            } else if (!((TileEntityChargingStation)this.te).charging && !((TileEntityChargingStation)this.te).disCharging) {
                curInfo.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a7fThe " + name + " can't be (dis)charged", 26));
                curInfo.add("\u00a70The pressures have equalized.");
            }
        }
    }

    private void renderAir() {
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_187441_d((float)2.0f);
        int particles = 10;
        for (int i = 0; i < particles; ++i) {
            this.renderAirParticle(((TileEntityChargingStation)this.te).renderAirProgress % (1.0f / (float)particles) + (float)i / (float)particles);
        }
        GlStateManager.func_179098_w();
    }

    private void renderAirParticle(float particleProgress) {
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        float x = (float)xStart + 117.0f;
        float y = (float)yStart + 50.5f;
        if (particleProgress < 0.5f) {
            y += particleProgress * 56.0f;
        } else if (particleProgress < 0.7f) {
            y += 28.0f;
            x -= (particleProgress - 0.5f) * 90.0f;
        } else {
            y += 28.0f;
            x -= 18.0f;
            y -= (particleProgress - 0.7f) * 70.0f;
        }
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        GL11.glPointSize((float)5.0f);
        wr.func_181668_a(0, DefaultVertexFormats.field_181705_e);
        wr.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }
}

