/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.teleport;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.meecreeps.items.PortalGunItem;
import mcjty.meecreeps.teleport.TeleportDestination;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSetDestination
implements IMessage {
    private TeleportDestination destination;
    private int destinationIndex;

    public void fromBytes(ByteBuf buf) {
        this.destination = new TeleportDestination(NetworkTools.readStringUTF8((ByteBuf)buf), buf.readInt(), BlockPos.func_177969_a((long)buf.readLong()), EnumFacing.field_82609_l[buf.readByte()]);
        this.destinationIndex = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writeStringUTF8((ByteBuf)buf, (String)this.destination.getName());
        buf.writeInt(this.destination.getDimension());
        buf.writeLong(this.destination.getPos().func_177986_g());
        buf.writeByte(this.destination.getSide().ordinal());
        buf.writeInt(this.destinationIndex);
    }

    public PacketSetDestination() {
    }

    public PacketSetDestination(TeleportDestination destination, int destinationIndex) {
        this.destination = destination;
        this.destinationIndex = destinationIndex;
    }

    public static class Handler
    implements IMessageHandler<PacketSetDestination, IMessage> {
        public IMessage onMessage(PacketSetDestination message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketSetDestination message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack heldItem = PortalGunItem.getGun((EntityPlayer)player);
            if (heldItem.func_190926_b()) {
                return;
            }
            PortalGunItem.addDestination(heldItem, message.destination, message.destinationIndex);
        }
    }
}

