/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.lib.network.PacketSendServerCommand;
import mcjty.lib.typed.TypedMap;
import mcjty.meecreeps.CommandHandler;
import mcjty.meecreeps.MeeCreeps;
import mcjty.meecreeps.MeeCreepsApi;
import mcjty.meecreeps.actions.ActionOptions;
import mcjty.meecreeps.actions.ClientActionManager;
import mcjty.meecreeps.actions.MeeCreepActionType;
import mcjty.meecreeps.actions.PacketPerformAction;
import mcjty.meecreeps.network.MeeCreepsMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class GuiMeeCreeps
extends GuiScreen {
    private static final int WIDTH = 256;
    private static final int HEIGHT = 200;
    private static final ResourceLocation gui_top = new ResourceLocation("meecreeps", "textures/gui/gui_meecreeps_top.png");
    private final int OPTION_DISTANCE = 14;
    private final int id;
    private int guiLeft;
    private int guiTop;
    private ActionOptions options;
    private boolean confirmedAction = false;
    private boolean showingAlternatives = false;
    private String furtherQuestionsHeading = null;
    private List<Pair<String, String>> furtherQuestions = Collections.emptyList();
    private MeeCreepActionType furtherQuestionType;
    private List<Question> questions = Collections.emptyList();
    private Runnable outsideWindowAction;

    public GuiMeeCreeps(int id) {
        this.id = id;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - 256) / 2;
        this.guiTop = (this.field_146295_m - 200) / 2;
        this.options = ClientActionManager.lastOptions;
        this.confirmedAction = false;
        this.showingAlternatives = false;
        this.outsideWindowAction = () -> {};
    }

    public boolean func_73868_f() {
        return false;
    }

    private void resumeAndClose() {
        this.resume();
        this.close();
    }

    private void resume() {
        this.confirmedAction = true;
        if (this.options != null) {
            MeeCreepsMessages.INSTANCE.sendToServer((IMessage)new PacketSendServerCommand("meecreeps", "resume_action", TypedMap.builder().put(CommandHandler.PARAM_ID, (Object)this.options.getActionId()).build()));
        }
    }

    private void dismissAndClose() {
        this.dismiss();
        this.close();
    }

    private void dismiss() {
        this.confirmedAction = true;
        if (this.options != null) {
            MeeCreepsMessages.INSTANCE.sendToServer((IMessage)new PacketSendServerCommand("meecreeps", "cancel_action", TypedMap.builder().put(CommandHandler.PARAM_ID, (Object)this.options.getActionId()).build()));
        }
    }

    private void close() {
        this.field_146297_k.func_147108_a(null);
        if (this.field_146297_k.field_71462_r == null) {
            this.field_146297_k.func_71381_h();
        }
    }

    public void func_146281_b() {
        if (!this.confirmedAction) {
            this.outsideWindowAction.run();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            int y = (mouseY - this.guiTop - 21) / 14;
            if (y >= 0 && y < this.questions.size()) {
                this.questions.get(y).getAction().run();
            } else {
                this.close();
            }
        }
    }

    private void doAction(MeeCreepActionType type, MeeCreepsApi.Factory factory, String furtherQuestionId) {
        String heading = factory.getFactory().getFurtherQuestionHeading((World)Minecraft.func_71410_x().field_71441_e, this.options.getTargetPos(), this.options.getTargetSide());
        if (heading == null || furtherQuestionId != null) {
            this.confirmedAction = true;
            MeeCreepsMessages.INSTANCE.sendToServer((IMessage)new PacketPerformAction(this.options, type, furtherQuestionId));
            this.close();
        } else {
            this.furtherQuestionType = type;
            this.furtherQuestionsHeading = heading;
            this.furtherQuestions = factory.getFactory().getFurtherQuestions((World)Minecraft.func_71410_x().field_71441_e, this.options.getTargetPos(), this.options.getTargetSide());
        }
    }

    private List<Question> getQuestions() {
        this.questions = new ArrayList<Question>();
        if (this.id == 2) {
            this.questions.add(new Question("message.meecreeps.gui.please_stop_now", this::dismissAndClose));
            this.questions.add(new Question("message.meecreeps.gui.carry_on", this::resumeAndClose));
            this.outsideWindowAction = this::resume;
        } else if (this.furtherQuestionsHeading != null) {
            MeeCreepsApi.Factory factory = MeeCreeps.api.getFactory(this.furtherQuestionType);
            for (Pair<String, String> pair : this.furtherQuestions) {
                this.questions.add(new Question((String)pair.getRight(), () -> this.doAction(this.furtherQuestionType, factory, (String)pair.getLeft())));
            }
            this.questions.add(new Question("message.meecreeps.gui.never_mind", this::close));
            this.outsideWindowAction = this::dismiss;
        } else if (this.showingAlternatives) {
            List<MeeCreepActionType> opts = this.options.getMaybeActionOptions();
            for (MeeCreepActionType type : opts) {
                MeeCreepsApi.Factory factory = MeeCreeps.api.getFactory(type);
                this.questions.add(new Question(factory.getMessage(), () -> this.doAction(type, factory, null)));
            }
            this.questions.add(new Question("message.meecreeps.gui.never_mind", this::close));
            this.outsideWindowAction = this::dismiss;
        } else {
            List<MeeCreepActionType> opts = this.options.getActionOptions();
            for (MeeCreepActionType type : opts) {
                MeeCreepsApi.Factory factory = MeeCreeps.api.getFactory(type);
                this.questions.add(new Question(factory.getMessage(), () -> this.doAction(type, factory, null)));
            }
            if (this.hasAlternatives()) {
                this.questions.add(new Question("message.meecreeps.gui.other_things", () -> {
                    this.showingAlternatives = true;
                }));
            }
            this.questions.add(new Question("message.meecreeps.gui.never_mind", this::dismissAndClose));
            this.outsideWindowAction = this::dismiss;
        }
        return this.questions;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.field_146297_k.func_110434_K().func_110577_a(gui_top);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 256, 10);
        int y = this.guiTop + 10;
        List<Question> questions = this.getQuestions();
        for (int i = 0; i < questions.size(); ++i) {
            this.func_73729_b(this.guiLeft, y, 0, 10, 256, 15);
            y += 14;
        }
        this.func_73729_b(this.guiLeft, y, 0, 25, 256, 15);
        String msg = this.id == 2 ? "message.meecreeps.gui.problem" : (this.furtherQuestionsHeading != null ? this.furtherQuestionsHeading : (this.showingAlternatives ? "message.meecreeps.gui.alternatives" : (this.options.getActionOptions().isEmpty() ? "message.meecreeps.gui.cant_do_much" : "message.meecreeps.gui.what_can_i_do")));
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)msg, (Object[])new Object[0]), this.guiLeft + 15, this.guiTop + 7, 0);
        y = this.guiTop + 21;
        for (Question question : questions) {
            int color = -10066432;
            if (mouseY > y && mouseY < y + 14) {
                color = -14492416;
            }
            this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)question.getMsg(), (Object[])new Object[0]), this.guiLeft + 40, y, color);
            y += 14;
        }
    }

    private boolean hasAlternatives() {
        return !this.options.getMaybeActionOptions().isEmpty();
    }

    static class Question {
        private final String msg;
        private final Runnable action;

        public Question(String msg, Runnable action) {
            this.msg = msg;
            this.action = action;
        }

        public String getMsg() {
            return this.msg;
        }

        public Runnable getAction() {
            return this.action;
        }
    }
}

