/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.entities;

import mcjty.meecreeps.MeeCreeps;
import mcjty.meecreeps.MeeCreepsApi;
import mcjty.meecreeps.actions.ActionOptions;
import mcjty.meecreeps.actions.ServerActionManager;
import mcjty.meecreeps.actions.Stage;
import mcjty.meecreeps.actions.workers.WorkerHelper;
import mcjty.meecreeps.api.IActionWorker;
import mcjty.meecreeps.entities.EntityMeeCreeps;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;

public class MeeCreepWorkerTask
extends EntityAIBase {
    private final EntityMeeCreeps meeCreep;
    private WorkerHelper helper = null;

    public MeeCreepWorkerTask(EntityMeeCreeps meeCreep) {
        this.meeCreep = meeCreep;
    }

    public boolean func_75250_a() {
        ActionOptions options;
        ServerActionManager manager = ServerActionManager.getManager();
        int actionId = this.meeCreep.getActionId();
        return actionId != 0 && (options = manager.getOptions(actionId)) != null && (options.getStage() == Stage.WORKING || options.getStage() == Stage.TIME_IS_UP || options.getStage() == Stage.TASK_IS_DONE);
    }

    public void cancelJob() {
        if (this.helper != null) {
            this.helper.cancelJob();
        }
    }

    private WorkerHelper getHelper(ActionOptions options) {
        if (this.helper == null) {
            this.helper = new WorkerHelper(options);
            MeeCreepsApi.Factory factory = MeeCreeps.api.getFactory(options.getTask());
            IActionWorker worker = factory.getFactory().createWorker(this.helper);
            this.helper.setWorker(worker);
            worker.init(this.meeCreep);
        }
        return this.helper;
    }

    public void func_75246_d() {
        ActionOptions options;
        ServerActionManager manager = ServerActionManager.getManager();
        int actionId = this.meeCreep.getActionId();
        if (actionId != 0 && (options = manager.getOptions(actionId)) != null) {
            if (options.isPaused()) {
                if (!this.meeCreep.func_70661_as().func_75500_f()) {
                    this.meeCreep.func_70661_as().func_75499_g();
                }
            } else {
                WorkerHelper helper = this.getHelper(options);
                if (options.getStage() == Stage.WORKING) {
                    helper.tick(this.meeCreep, false);
                } else if (options.getStage() == Stage.TIME_IS_UP) {
                    if (helper.getWorker().onlyStopWhenDone()) {
                        helper.tick(this.meeCreep, false);
                    } else {
                        helper.tick(this.meeCreep, true);
                    }
                } else if (options.getStage() == Stage.TASK_IS_DONE) {
                    helper.tick(this.meeCreep, true);
                }
            }
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (!this.meeCreep.getWorld().field_72995_K) {
            ActionOptions options;
            ServerActionManager manager = ServerActionManager.getManager();
            int actionId = this.meeCreep.getActionId();
            if (actionId != 0 && (options = manager.getOptions(actionId)) != null && options.getTask() != null) {
                this.getHelper(options).readFromNBT(tag);
            }
        }
    }

    public WorkerHelper getHelper() {
        return this.helper;
    }

    public void writeToNBT(NBTTagCompound tag) {
        if (this.helper != null) {
            this.helper.writeToNBT(tag);
        }
    }
}

