/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions.workers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.lib.varia.Counter;
import mcjty.meecreeps.actions.workers.AbstractActionWorker;
import mcjty.meecreeps.api.IMeeCreep;
import mcjty.meecreeps.api.IWorkerHelper;
import mcjty.meecreeps.config.Config;
import mcjty.meecreeps.varia.GeneralTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ChopTreeActionWorker
extends AbstractActionWorker {
    protected List<BlockPos> blocks = new ArrayList<BlockPos>();
    protected Counter<BlockPos> leavesToTick = new Counter();

    public ChopTreeActionWorker(IWorkerHelper helper) {
        super(helper);
    }

    @Override
    public AxisAlignedBB getActionBox() {
        return null;
    }

    private void harvest(BlockPos pos) {
        World world = this.helper.getMeeCreep().getWorld();
        this.helper.harvestAndDrop(pos);
        this.findLeaves(pos, world);
    }

    @Override
    public void init(IMeeCreep meeCreep) {
        this.helper.setSpeed(5);
    }

    @Override
    public boolean onlyStopWhenDone() {
        return true;
    }

    protected void findLeaves(BlockPos pos, World world) {
        int offs = 4;
        for (int x = -offs; x <= offs; ++x) {
            for (int y = -offs; y <= offs; ++y) {
                for (int z = -offs; z <= offs; ++z) {
                    BlockPos p = pos.func_177982_a(x, y, z);
                    IBlockState st = world.func_180495_p(p);
                    if (!st.func_177230_c().isLeaves(st, (IBlockAccess)world, p) || !((Boolean)st.func_177229_b((IProperty)BlockLeaves.field_176237_a)).booleanValue()) continue;
                    this.leavesToTick.put((Object)p, (Object)500);
                }
            }
        }
    }

    protected void traverseTreeLogs(Set<BlockPos> alreadyDone, BlockPos pos, Block woodBlock) {
        alreadyDone.add(pos);
        this.blocks.add(pos);
        if (this.blocks.size() > Config.maxTreeBlocks) {
            return;
        }
        IMeeCreep entity = this.helper.getMeeCreep();
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    IBlockState log;
                    BlockPos p;
                    if (x == 0 && y == 0 && z == 0 || alreadyDone.contains(p = pos.func_177982_a(x, y, z)) || !this.helper.allowedToHarvest(log = entity.getWorld().func_180495_p(p), entity.getWorld(), p, (EntityPlayer)GeneralTools.getHarvester(entity.getWorld())) || log.func_177230_c() != woodBlock) continue;
                    this.traverseTreeLogs(alreadyDone, p, woodBlock);
                }
            }
        }
    }

    protected void findTree() {
        IMeeCreep entity = this.helper.getMeeCreep();
        BlockPos startPos = this.options.getTargetPos();
        if (entity.getWorld().func_175623_d(startPos)) {
            return;
        }
        IBlockState logBase = entity.getWorld().func_180495_p(startPos);
        HashSet<BlockPos> alreadyDone = new HashSet<BlockPos>();
        this.traverseTreeLogs(alreadyDone, startPos, logBase.func_177230_c());
    }

    @Override
    public void tick(boolean timeToWrapUp) {
        if (timeToWrapUp) {
            this.helper.done();
            return;
        }
        if (this.blocks.isEmpty()) {
            this.findTree();
        }
        if (this.blocks.isEmpty() && this.leavesToTick.isEmpty()) {
            this.helper.done();
            return;
        }
        if (!this.leavesToTick.isEmpty()) {
            this.decayLeaves();
        }
        if (!this.blocks.isEmpty()) {
            BlockPos toRemove = this.blocks.remove(0);
            this.helper.navigateTo(this.options.getTargetPos(), blockPos -> this.harvest(toRemove));
        } else {
            this.helper.taskIsDone();
        }
    }

    private void decayLeaves() {
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        Counter newmap = new Counter();
        for (Map.Entry entry : this.leavesToTick.entrySet()) {
            Integer counter;
            BlockPos pos = (BlockPos)entry.getKey();
            if (world.func_175623_d(pos)) continue;
            IBlockState state = world.func_180495_p(pos);
            state.func_177230_c().func_180650_b(world, pos, state, entity.getRandom());
            if (world.func_175623_d(pos)) continue;
            Integer n = counter = (Integer)entry.getValue();
            Integer n2 = counter = Integer.valueOf(counter - 1);
            if (counter <= 0) continue;
            newmap.put((Object)pos, (Object)counter);
        }
        this.leavesToTick = newmap;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (BlockPos block : this.blocks) {
            list.func_74742_a((NBTBase)new NBTTagLong(block.func_177986_g()));
        }
        tag.func_74782_a("blocks", (NBTBase)list);
        list = new NBTTagList();
        for (Map.Entry entry : this.leavesToTick.entrySet()) {
            BlockPos block = (BlockPos)entry.getKey();
            Integer counter = (Integer)entry.getValue();
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74772_a("p", block.func_177986_g());
            tc.func_74768_a("c", counter.intValue());
            list.func_74742_a((NBTBase)tc);
        }
        tag.func_74782_a("leaves", (NBTBase)list);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        int i;
        NBTTagList list = tag.func_150295_c("blocks", 4);
        this.blocks.clear();
        for (i = 0; i < list.func_74745_c(); ++i) {
            this.blocks.add(BlockPos.func_177969_a((long)((NBTTagLong)list.func_179238_g(i)).func_150291_c()));
        }
        list = tag.func_150295_c("leaves", 10);
        this.leavesToTick.clear();
        for (i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tc = list.func_150305_b(i);
            BlockPos pos = BlockPos.func_177969_a((long)tc.func_74763_f("p"));
            int counter = tc.func_74762_e("c");
            this.leavesToTick.put((Object)pos, (Object)counter);
        }
    }
}

