/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions.schematics;

import java.util.function.Predicate;
import mcjty.meecreeps.api.IBuildSchematic;
import mcjty.meecreeps.api.IDesiredBlock;
import mcjty.meecreeps.api.IWorkerHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class SchematicPlatform
implements IBuildSchematic {
    private final int size;
    private final IWorkerHelper helper;
    private static final IDesiredBlock COBBLE = new IDesiredBlock(){

        @Override
        public String getName() {
            return "cobblestone";
        }

        @Override
        public int getAmount() {
            return 128;
        }

        @Override
        public Predicate<ItemStack> getMatcher() {
            return stack -> stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150347_e);
        }

        @Override
        public Predicate<IBlockState> getStateMatcher() {
            return blockState -> blockState.func_177230_c() == Blocks.field_150347_e;
        }
    };

    public SchematicPlatform(int size, IWorkerHelper helper) {
        this.size = size;
        this.helper = helper;
    }

    @Override
    public BlockPos getMinPos() {
        return new BlockPos(-this.size / 2, 0, -this.size / 2);
    }

    @Override
    public BlockPos getMaxPos() {
        return new BlockPos(this.size / 2, 0, this.size / 2);
    }

    @Override
    public IDesiredBlock getDesiredBlock(BlockPos relativePos) {
        return COBBLE;
    }
}

