/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.models;

import binnie.extratrees.blocks.BlockETDefaultLeaves;
import binnie.extratrees.genetics.ETTreeDefinition;
import com.google.common.base.Preconditions;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.core.IModelBaker;
import forestry.core.models.ModelBlockCached;
import forestry.core.models.baker.ModelBaker;
import forestry.core.proxy.Proxies;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ModelDefaultETLeaves
extends ModelBlockCached<BlockETDefaultLeaves, ETTreeDefinition> {
    public ModelDefaultETLeaves() {
        super(BlockETDefaultLeaves.class);
    }

    protected ETTreeDefinition getInventoryKey(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        Preconditions.checkArgument((boolean)(block instanceof BlockETDefaultLeaves), (Object)"ItemStack must be for default leaves.");
        BlockETDefaultLeaves bBlock = (BlockETDefaultLeaves)block;
        return bBlock.getTreeType(stack.func_77960_j());
    }

    protected ETTreeDefinition getWorldKey(IBlockState state) {
        Block block = state.func_177230_c();
        Preconditions.checkArgument((boolean)(block instanceof BlockETDefaultLeaves), (Object)"state must be for default leaves.");
        BlockETDefaultLeaves bBlock = (BlockETDefaultLeaves)block;
        ETTreeDefinition treeDefinition = bBlock.getTreeDefinition(state);
        Preconditions.checkNotNull((Object)((Object)treeDefinition));
        return treeDefinition;
    }

    protected void bakeBlock(BlockETDefaultLeaves block, ETTreeDefinition treeDefinition, IModelBaker baker, boolean inventory) {
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        ITreeGenome genome = treeDefinition.getGenome();
        IAlleleTreeSpecies species = genome.getPrimary();
        ILeafSpriteProvider leafSpriteProvider = species.getLeafSpriteProvider();
        ResourceLocation leafSpriteLocation = leafSpriteProvider.getSprite(false, Proxies.render.fancyGraphicsEnabled());
        TextureAtlasSprite leafSprite = map.func_110572_b(leafSpriteLocation.toString());
        baker.addBlockModel(null, leafSprite, 0);
        ResourceLocation fruitSpriteLocation = genome.getFruitProvider().getDecorativeSprite();
        if (fruitSpriteLocation != null) {
            TextureAtlasSprite fruitSprite = map.func_110572_b(fruitSpriteLocation.toString());
            baker.addBlockModel(null, fruitSprite, 1);
        }
        baker.setParticleSprite(leafSprite);
    }

    protected IBakedModel bakeModel(IBlockState state, ETTreeDefinition key, BlockETDefaultLeaves block) {
        if (key == null) {
            return null;
        }
        ModelBaker baker = new ModelBaker();
        if (!this.blockClass.isInstance((Object)block)) {
            return null;
        }
        BlockETDefaultLeaves bBlock = (BlockETDefaultLeaves)((Object)this.blockClass.cast((Object)block));
        this.bakeBlock(bBlock, key, (IModelBaker)baker, false);
        this.blockModel = baker.bakeModel(false);
        this.onCreateModel(this.blockModel);
        return this.blockModel;
    }
}

