/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.world;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.dave.compactmachines3.init.Blockss;
import org.dave.compactmachines3.misc.ConfigurationHandler;
import org.dave.compactmachines3.reference.EnumMachineSize;
import org.dave.compactmachines3.utility.Logz;
import org.dave.compactmachines3.world.tools.StructureTools;

public class WorldGenMachines
implements IWorldGenerator {
    private static final Set<Block> allowedBlocksToSpawnOn = new HashSet<Block>();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        Block foundationBlock;
        BlockPos startingCornerPos;
        Biome worldBiome;
        if (ConfigurationHandler.Settings.chanceForBrokenCube == 0.0f) {
            return;
        }
        boolean allowed = false;
        for (int dim : ConfigurationHandler.Settings.worldgenDimensions) {
            if (dim != world.field_73011_w.getDimension()) continue;
            allowed = true;
            break;
        }
        if (!allowed) {
            return;
        }
        if (random.nextFloat() > ConfigurationHandler.Settings.chanceForBrokenCube) {
            return;
        }
        EnumMachineSize size = EnumMachineSize.getFromMeta(random.nextInt(EnumMachineSize.values().length - 3));
        int dim = size.getDimension();
        int x = (chunkX << 4) + random.nextInt(16 - dim) + dim;
        int z = (chunkZ << 4) + random.nextInt(16 - dim) + dim;
        int y = world.func_189649_b(x, z) + dim;
        if (world.field_73011_w.func_186058_p() == DimensionType.NETHER) {
            for (y = 120; y > 0 && !world.func_175623_d(new BlockPos(x, y, z)); --y) {
            }
            while (y > 0 && world.func_175623_d(new BlockPos(x, y, z))) {
                --y;
            }
            if (y == 0) {
                return;
            }
            y += dim;
        }
        if ((worldBiome = world.func_180494_b(startingCornerPos = new BlockPos(x, y, z))) == Biomes.field_76771_b || worldBiome == Biomes.field_150575_M || worldBiome == Biomes.field_76776_l) {
            return;
        }
        BlockPos foundationPos = startingCornerPos.func_177972_a(EnumFacing.DOWN);
        while (true) {
            foundationBlock = world.func_180495_p(foundationPos).func_177230_c();
            if (foundationPos.func_177956_o() <= 0 || !world.func_175623_d(foundationPos) && !foundationBlock.isFoliage((IBlockAccess)world, foundationPos) && !foundationBlock.func_176200_f((IBlockAccess)world, foundationPos)) break;
            foundationPos = foundationPos.func_177972_a(EnumFacing.DOWN);
        }
        if (!allowedBlocksToSpawnOn.contains(foundationBlock)) {
            return;
        }
        Logz.debug("Generating cube in dim=%d: chunkX=%d, chunkZ=%d, pos=%s", world.field_73011_w.getDimension(), chunkX, chunkZ, startingCornerPos);
        int cxSphere = x - (random.nextBoolean() ? dim : 0);
        int cySphere = y;
        int czSphere = z - (random.nextBoolean() ? dim : 0);
        int rSphere = dim - random.nextInt(3);
        IBlockState state = Blockss.wallBreakable.func_176223_P();
        IBlockState fluidState = Blocks.field_150353_l.func_176223_P();
        for (BlockPos pos : StructureTools.getCubePositions(new BlockPos(x, y, z), dim + 1, dim + 1, dim + 1, true)) {
            float xx = pos.func_177958_n() - cxSphere;
            float yy = pos.func_177956_o() - cySphere;
            float zz = pos.func_177952_p() - czSphere;
            if (Math.pow(xx, 2.0) + Math.pow(yy, 2.0) + Math.pow(zz, 2.0) < Math.pow(rSphere, 2.0)) continue;
            if (random.nextInt(100) <= 1) {
                world.func_175656_a(pos, fluidState);
                continue;
            }
            world.func_175656_a(pos, state);
        }
    }

    static {
        allowedBlocksToSpawnOn.add((Block)Blocks.field_150354_m);
        allowedBlocksToSpawnOn.add(Blocks.field_150322_A);
        allowedBlocksToSpawnOn.add(Blocks.field_150346_d);
        allowedBlocksToSpawnOn.add((Block)Blocks.field_150349_c);
        allowedBlocksToSpawnOn.add(Blocks.field_150348_b);
        allowedBlocksToSpawnOn.add(Blocks.field_150347_e);
        allowedBlocksToSpawnOn.add(Blocks.field_150424_aL);
        allowedBlocksToSpawnOn.add(Blocks.field_150425_aM);
        allowedBlocksToSpawnOn.add(Blocks.field_150377_bs);
    }
}

