/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.utility;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fml.common.FMLLog;
import org.dave.compactmachines3.utility.ChunkBlockAccess;
import org.dave.compactmachines3.world.data.provider.AbstractExtraTileDataProvider;
import org.dave.compactmachines3.world.data.provider.ExtraTileDataProviderRegistry;

public class ChunkUtils {
    public static IBlockAccess getBlockAccessFromChunk(Chunk chunk) {
        return new ChunkBlockAccess(chunk);
    }

    public static NBTTagCompound writeChunkToNBT(Chunk chunkIn, World worldIn, NBTTagCompound compound) {
        compound.func_74768_a("xPos", chunkIn.field_76635_g);
        compound.func_74768_a("zPos", chunkIn.field_76647_h);
        compound.func_74772_a("LastUpdate", worldIn.func_82737_E());
        compound.func_74783_a("HeightMap", chunkIn.func_177445_q());
        compound.func_74757_a("TerrainPopulated", chunkIn.func_177419_t());
        compound.func_74757_a("LightPopulated", chunkIn.func_177423_u());
        compound.func_74772_a("InhabitedTime", chunkIn.func_177416_w());
        ExtendedBlockStorage[] aextendedblockstorage = chunkIn.func_76587_i();
        NBTTagList nbttaglist = new NBTTagList();
        boolean flag = worldIn.field_73011_w.func_191066_m();
        for (ExtendedBlockStorage extendedblockstorage : aextendedblockstorage) {
            if (extendedblockstorage == Chunk.field_186036_a) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Y", (byte)(extendedblockstorage.func_76662_d() >> 4 & 0xFF));
            byte[] abyte = new byte[4096];
            NibbleArray nibblearray = new NibbleArray();
            NibbleArray nibblearray1 = extendedblockstorage.func_186049_g().func_186017_a(abyte, nibblearray);
            nbttagcompound.func_74773_a("Blocks", abyte);
            nbttagcompound.func_74773_a("Data", nibblearray.func_177481_a());
            if (nibblearray1 != null) {
                nbttagcompound.func_74773_a("Add", nibblearray1.func_177481_a());
            }
            nbttagcompound.func_74773_a("BlockLight", extendedblockstorage.func_76661_k().func_177481_a());
            if (flag) {
                nbttagcompound.func_74773_a("SkyLight", extendedblockstorage.func_76671_l().func_177481_a());
            } else {
                nbttagcompound.func_74773_a("SkyLight", new byte[extendedblockstorage.func_76661_k().func_177481_a().length]);
            }
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Sections", (NBTBase)nbttaglist);
        compound.func_74773_a("Biomes", chunkIn.func_76605_m());
        chunkIn.func_177409_g(false);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (int i = 0; i < chunkIn.func_177429_s().length; ++i) {
            for (Entity entity : chunkIn.func_177429_s()[i]) {
                NBTTagCompound nbttagcompound2 = new NBTTagCompound();
                try {
                    if (!entity.func_70039_c(nbttagcompound2)) continue;
                    chunkIn.func_177409_g(true);
                    nbttaglist1.func_74742_a((NBTBase)nbttagcompound2);
                }
                catch (Exception e) {
                    FMLLog.log.error("An Entity type {} has thrown an exception trying to write state. It will not persist. Report this to the mod author", (Object)entity.getClass().getName(), (Object)e);
                }
            }
        }
        compound.func_74782_a("Entities", (NBTBase)nbttaglist1);
        NBTTagList nbttaglist2 = new NBTTagList();
        for (TileEntity tileentity : chunkIn.func_177434_r().values()) {
            try {
                NBTTagCompound nbttagcompound3 = tileentity.func_189515_b(new NBTTagCompound());
                for (AbstractExtraTileDataProvider provider : ExtraTileDataProviderRegistry.getDataProviders(tileentity)) {
                    NBTTagCompound extraData = provider.writeExtraData(tileentity);
                    String tagName = String.format("cm3_extra:%s", provider.getName());
                    nbttagcompound3.func_74782_a(tagName, (NBTBase)extraData);
                }
                nbttaglist2.func_74742_a((NBTBase)nbttagcompound3);
            }
            catch (Exception e) {
                FMLLog.log.error("A TileEntity type {} has throw an exception trying to write state. It will not persist. Report this to the mod author", (Object)tileentity.getClass().getName(), (Object)e);
            }
        }
        compound.func_74782_a("TileEntities", (NBTBase)nbttaglist2);
        List list = worldIn.func_72920_a(chunkIn, false);
        if (list != null) {
            long j = worldIn.func_82737_E();
            NBTTagList nbttaglist3 = new NBTTagList();
            for (NextTickListEntry nextticklistentry : list) {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)nextticklistentry.func_151351_a());
                nbttagcompound1.func_74778_a("i", resourcelocation == null ? "" : resourcelocation.toString());
                nbttagcompound1.func_74768_a("x", nextticklistentry.field_180282_a.func_177958_n());
                nbttagcompound1.func_74768_a("y", nextticklistentry.field_180282_a.func_177956_o());
                nbttagcompound1.func_74768_a("z", nextticklistentry.field_180282_a.func_177952_p());
                nbttagcompound1.func_74768_a("t", (int)(nextticklistentry.field_77180_e - j));
                nbttagcompound1.func_74768_a("p", nextticklistentry.field_82754_f);
                nbttaglist3.func_74742_a((NBTBase)nbttagcompound1);
            }
            compound.func_74782_a("TileTicks", (NBTBase)nbttaglist3);
        }
        return compound;
    }

    public static Chunk readChunkFromNBT(World worldIn, NBTTagCompound compound) {
        int i = compound.func_74762_e("xPos");
        int j = compound.func_74762_e("zPos");
        Chunk chunk = new Chunk(worldIn, i, j);
        chunk.func_177420_a(compound.func_74759_k("HeightMap"));
        chunk.func_177446_d(compound.func_74767_n("TerrainPopulated"));
        chunk.func_177421_e(compound.func_74767_n("LightPopulated"));
        chunk.func_177415_c(compound.func_74763_f("InhabitedTime"));
        NBTTagList nbttaglist = compound.func_150295_c("Sections", 10);
        int k = 16;
        ExtendedBlockStorage[] aextendedblockstorage = new ExtendedBlockStorage[16];
        boolean flag = true;
        for (int l = 0; l < nbttaglist.func_74745_c(); ++l) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(l);
            byte i1 = nbttagcompound.func_74771_c("Y");
            ExtendedBlockStorage extendedblockstorage = new ExtendedBlockStorage(i1 << 4, flag);
            byte[] abyte = nbttagcompound.func_74770_j("Blocks");
            NibbleArray nibblearray = new NibbleArray(nbttagcompound.func_74770_j("Data"));
            NibbleArray nibblearray1 = nbttagcompound.func_150297_b("Add", 7) ? new NibbleArray(nbttagcompound.func_74770_j("Add")) : null;
            extendedblockstorage.func_186049_g().func_186019_a(abyte, nibblearray, nibblearray1);
            extendedblockstorage.func_76659_c(new NibbleArray(nbttagcompound.func_74770_j("BlockLight")));
            if (flag) {
                extendedblockstorage.func_76666_d(new NibbleArray(nbttagcompound.func_74770_j("SkyLight")));
            }
            extendedblockstorage.func_76672_e();
            aextendedblockstorage[i1] = extendedblockstorage;
        }
        chunk.func_76602_a(aextendedblockstorage);
        if (compound.func_150297_b("Biomes", 7)) {
            chunk.func_76616_a(compound.func_74770_j("Biomes"));
        }
        ChunkUtils.loadEntities(worldIn, compound, chunk);
        return chunk;
    }

    public static void loadEntities(World worldIn, NBTTagCompound compound, Chunk chunk) {
        NBTTagList nbttaglist1 = compound.func_150295_c("Entities", 10);
        for (int j1 = 0; j1 < nbttaglist1.func_74745_c(); ++j1) {
            NBTTagCompound nbttagcompound1 = nbttaglist1.func_150305_b(j1);
            AnvilChunkLoader.func_186050_a((NBTTagCompound)nbttagcompound1, (World)worldIn, (Chunk)chunk);
            chunk.func_177409_g(true);
        }
        NBTTagList nbttaglist2 = compound.func_150295_c("TileEntities", 10);
        for (int k1 = 0; k1 < nbttaglist2.func_74745_c(); ++k1) {
            NBTTagCompound nbttagcompound2 = nbttaglist2.func_150305_b(k1);
            TileEntity tileentity = TileEntity.func_190200_a((World)worldIn, (NBTTagCompound)nbttagcompound2);
            if (tileentity == null) continue;
            tileentity.func_145834_a(worldIn);
            BlockPos pos = tileentity.func_174877_v();
            tileentity.func_174878_a(new BlockPos(pos.func_177958_n() % 1024, pos.func_177956_o(), pos.func_177952_p()));
            for (AbstractExtraTileDataProvider provider : ExtraTileDataProviderRegistry.getDataProviders(tileentity)) {
                String tagName = String.format("cm3_extra:%s", provider.getName());
                if (!nbttagcompound2.func_74764_b(tagName)) continue;
                provider.readExtraData(tileentity, (NBTTagCompound)nbttagcompound2.func_74781_a(tagName));
            }
            chunk.func_150813_a(tileentity);
        }
    }
}

