/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.misc;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dave.compactmachines3.gui.machine.GuiMachineData;
import org.dave.compactmachines3.misc.ConfigurationHandler;
import org.dave.compactmachines3.reference.EnumMachineSize;
import org.dave.compactmachines3.world.WorldSavedDataMachines;
import org.dave.compactmachines3.world.tools.StructureTools;
import org.dave.compactmachines3.world.tools.TeleportationTools;

public class PlayerEventHandler {
    @SubscribeEvent
    public static void onPlayerSpawn(PlayerEvent.PlayerRespawnEvent event) {
        boolean bedInCM;
        if (event.player.func_130014_f_().field_73011_w.getDimension() != ConfigurationHandler.Settings.dimensionId) {
            return;
        }
        int bedCoords = WorldSavedDataMachines.INSTANCE.getBedCoords(event.player);
        boolean bl = bedInCM = bedCoords != -1;
        if (bedInCM && ConfigurationHandler.MachineSettings.allowRespawning) {
            TeleportationTools.teleportPlayerToMachine((EntityPlayerMP)event.player, bedCoords, false);
        } else {
            TeleportationTools.teleportPlayerOutOfMachineDimension((EntityPlayerMP)event.player);
            event.player.getEntityData().func_82580_o("compactmachines3-coordHistory");
        }
    }

    @SubscribeEvent
    public static void onPlayerSleepInBed(PlayerSleepInBedEvent event) {
        if (event.getEntityPlayer().field_70170_p.field_73011_w.getDimension() != ConfigurationHandler.Settings.dimensionId) {
            return;
        }
        if (!ConfigurationHandler.MachineSettings.allowRespawning) {
            event.setResult(EntityPlayer.SleepResult.NOT_POSSIBLE_HERE);
            event.getEntityPlayer().func_146105_b((ITextComponent)new TextComponentTranslation("hint.compactmachines3.cant_sleep_here", new Object[0]), true);
            return;
        }
        if (event.getEntityPlayer().func_70608_bn() || !event.getEntityPlayer().func_70089_S()) {
            event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
            return;
        }
        event.getEntityPlayer().func_146105_b((ITextComponent)new TextComponentTranslation("hint.compactmachines3.bed_position_set", new Object[0]), true);
        WorldSavedDataMachines.INSTANCE.setBedCoords(event.getEntityPlayer());
        event.setResult(EntityPlayer.SleepResult.OK);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onGuiClose(GuiOpenEvent event) {
        if (event.getGui() == null) {
            GuiMachineData.canRender = false;
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        if (event.player.field_70170_p.field_73011_w.getDimension() != ConfigurationHandler.Settings.dimensionId) {
            return;
        }
        if (event.player.field_70170_p.func_82737_E() % 20L != 0L) {
            return;
        }
        int lastCoords = TeleportationTools.getLastKnownCoords(event.player);
        if (lastCoords == -1 && !ConfigurationHandler.MachineSettings.allowEnteringWithoutPSD) {
            event.player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"minecraft:nausea"), 200, 5, false, false));
            event.player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"minecraft:wither"), 160, 1, false, false));
            event.player.getEntityData().func_82580_o("compactmachines3-oldDimension");
            event.player.getEntityData().func_82580_o("compactmachines3-oldPosX");
            event.player.getEntityData().func_82580_o("compactmachines3-oldPosY");
            event.player.getEntityData().func_82580_o("compactmachines3-oldPosZ");
            TeleportationTools.teleportPlayerOutOfMachineDimension((EntityPlayerMP)event.player);
            return;
        }
        if (!ConfigurationHandler.MachineSettings.keepPlayersInside) {
            return;
        }
        int actualCoords = StructureTools.getCoordsForPos(new BlockPos(event.player.field_70165_t, event.player.field_70163_u, event.player.field_70161_v));
        EnumMachineSize enumSize = WorldSavedDataMachines.INSTANCE.machineSizes.getOrDefault(lastCoords, null);
        if (enumSize == null) {
            return;
        }
        if (event.player.func_184812_l_() && event.player.func_70003_b(2, "")) {
            return;
        }
        int size = enumSize.getDimension() + 1;
        AxisAlignedBB bb = new AxisAlignedBB((double)(lastCoords << 10), 40.0, 0.0, (double)((lastCoords << 10) + size), (double)(40 + size), (double)size);
        if (!bb.func_72318_a(new Vec3d(event.player.field_70165_t, event.player.field_70163_u, event.player.field_70161_v))) {
            event.player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"minecraft:nausea"), 200, 5, false, false));
            event.player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"minecraft:wither"), 160, 1, false, false));
            TeleportationTools.teleportPlayerOutOfMachine((EntityPlayerMP)event.player);
            return;
        }
    }
}

