/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import org.dave.compactmachines3.miniaturization.MultiblockRecipe;
import org.dave.compactmachines3.misc.RenderTickCounter;
import org.dave.compactmachines3.render.RecipeRenderManager;

public class MultiblockRecipeWrapper
implements IRecipeWrapper {
    public final MultiblockRecipe recipe;
    private final List<ItemStack> input = new ArrayList<ItemStack>();

    public MultiblockRecipeWrapper(MultiblockRecipe recipe) {
        this.recipe = recipe;
        int added = 0;
        for (ItemStack stack : this.recipe.getRequiredItemStacks()) {
            this.input.add(stack);
            ++added;
        }
        for (int emptySlot = 0; emptySlot < 6 - added; ++emptySlot) {
            this.input.add(null);
        }
        this.input.add(this.recipe.getCatalystStack());
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.input);
        ingredients.setOutput(ItemStack.class, (Object)this.recipe.getTargetStack());
    }

    public void drawInfo(Minecraft mc, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)216.5f);
        mc.field_71466_p.func_78276_b(this.recipe.getDimensionsString(), 153 - mc.field_71466_p.func_78256_a(this.recipe.getDimensionsString()), 105, 0x444444);
        GlStateManager.func_179121_F();
        float angle = (float)RenderTickCounter.renderTicks * 45.0f / 128.0f;
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179106_n();
        GlStateManager.func_179140_f();
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179089_o();
        GlStateManager.func_179141_d();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(recipeWidth / 2), (float)(recipeHeight / 2), (float)100.0f);
        GlStateManager.func_179114_b((float)-25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)16.0f, (float)-16.0f, (float)16.0f);
        BlockPos mn = this.recipe.getMinPos();
        BlockPos mx = this.recipe.getMaxPos();
        int diffX = mx.func_177958_n() - mn.func_177958_n();
        int diffY = mx.func_177956_o() - mn.func_177956_o();
        int diffZ = mx.func_177952_p() - mn.func_177952_p();
        int maxDiff = Math.max(Math.max(diffZ, diffX), diffY) + 1;
        float scale = 1.0f / ((float)maxDiff / 4.0f);
        GlStateManager.func_179089_o();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179109_b((float)((float)(diffX + 1) / -2.0f), (float)((float)(diffY + 1) / -2.0f), (float)((float)(diffZ + 1) / -2.0f));
        boolean renderWireframe = false;
        if (GuiScreen.func_146272_n()) {
            renderWireframe = true;
            GlStateManager.func_187409_d((int)1032, (int)6913);
        }
        RecipeRenderManager.instance.renderRecipe(this.recipe, 0.0f);
        if (renderWireframe) {
            GlStateManager.func_187409_d((int)1032, (int)6914);
        }
        GlStateManager.func_179121_F();
    }
}

