/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.block;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dave.compactmachines3.block.BlockProtected;
import org.dave.compactmachines3.block.BlockRedstoneTunnel;
import org.dave.compactmachines3.block.BlockTunnel;
import org.dave.compactmachines3.init.Blockss;
import org.dave.compactmachines3.item.ItemPersonalShrinkingDevice;
import org.dave.compactmachines3.item.ItemRedstoneTunnelTool;
import org.dave.compactmachines3.item.ItemTunnelTool;
import org.dave.compactmachines3.misc.ConfigurationHandler;
import org.dave.compactmachines3.misc.CreativeTabCompactMachines3;
import org.dave.compactmachines3.misc.CubeTools;
import org.dave.compactmachines3.world.WorldSavedDataMachines;
import org.dave.compactmachines3.world.data.RedstoneTunnelData;
import org.dave.compactmachines3.world.tools.StructureTools;

public class BlockWall
extends BlockProtected {
    public BlockWall(Material material) {
        super(material);
        this.func_149713_g(1);
        this.func_149715_a(1.0f);
        this.func_149647_a(CreativeTabCompactMachines3.COMPACTMACHINES3_TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return CubeTools.shouldSideBeRendered(blockAccess, pos, side);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return pos.func_177956_o() == 40;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack playerStack = player.func_184614_ca();
        if (playerStack.func_190926_b()) {
            return false;
        }
        if (player.func_70093_af()) {
            return false;
        }
        if (playerStack.func_77973_b() instanceof ItemPersonalShrinkingDevice) {
            return false;
        }
        if (world.field_72995_K || !(player instanceof EntityPlayerMP)) {
            return true;
        }
        if (world.field_73011_w.getDimension() != ConfigurationHandler.Settings.dimensionId) {
            return false;
        }
        if (playerStack.func_77973_b() instanceof ItemTunnelTool) {
            EnumFacing tunnelSide = EnumFacing.DOWN;
            int coords = StructureTools.getCoordsForPos(pos);
            HashMap<EnumFacing, BlockPos> sideMapping = WorldSavedDataMachines.INSTANCE.tunnels.get(coords);
            while (sideMapping != null && tunnelSide != null && sideMapping.get(tunnelSide) != null) {
                tunnelSide = StructureTools.getNextDirection(tunnelSide);
            }
            if (tunnelSide != null) {
                IBlockState blockState = Blockss.tunnel.func_176223_P().func_177226_a((IProperty)BlockTunnel.MACHINE_SIDE, (Comparable)tunnelSide);
                world.func_175656_a(pos, blockState);
                playerStack.func_190920_e(playerStack.func_190916_E() - 1);
                WorldSavedDataMachines.INSTANCE.addTunnel(pos, tunnelSide);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "All tunnels already used up"), false);
            }
            return true;
        }
        if (playerStack.func_77973_b() instanceof ItemRedstoneTunnelTool) {
            EnumFacing tunnelSide = EnumFacing.DOWN;
            int coords = StructureTools.getCoordsForPos(pos);
            HashMap<EnumFacing, RedstoneTunnelData> sideMapping = WorldSavedDataMachines.INSTANCE.redstoneTunnels.get(coords);
            while (sideMapping != null && tunnelSide != null && sideMapping.get(tunnelSide) != null) {
                tunnelSide = StructureTools.getNextDirection(tunnelSide);
            }
            if (tunnelSide != null) {
                IBlockState blockState = Blockss.redstoneTunnel.func_176223_P().func_177226_a((IProperty)BlockRedstoneTunnel.MACHINE_SIDE, (Comparable)tunnelSide);
                world.func_175656_a(pos, blockState);
                playerStack.func_190920_e(playerStack.func_190916_E() - 1);
                WorldSavedDataMachines.INSTANCE.addRedstoneTunnel(pos, tunnelSide, false);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "All tunnels already used up"), false);
            }
            return true;
        }
        return false;
    }
}

