/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.crafting;

import appeng.block.crafting.BlockCraftingUnit;
import appeng.bootstrap.BlockRenderingCustomizer;
import appeng.bootstrap.IBlockRendering;
import appeng.bootstrap.IItemRendering;
import appeng.client.render.crafting.CraftingCubeModel;
import appeng.client.render.crafting.CraftingMonitorTESR;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CraftingCubeRendering
extends BlockRenderingCustomizer {
    private final String registryName;
    private final BlockCraftingUnit.CraftingUnitType type;

    public CraftingCubeRendering(String registryName, BlockCraftingUnit.CraftingUnitType type) {
        this.registryName = registryName;
        this.type = type;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void customize(IBlockRendering rendering, IItemRendering itemRendering) {
        ResourceLocation baseName = new ResourceLocation("appliedenergistics2", this.registryName);
        if (this.type != BlockCraftingUnit.CraftingUnitType.MONITOR) {
            rendering.modelCustomizer((loc, model) -> model);
        }
        ModelResourceLocation defaultModel = new ModelResourceLocation(baseName, "normal");
        String builtInName = "models/block/crafting/" + this.registryName + "/builtin";
        ModelResourceLocation builtInModelName = new ModelResourceLocation(new ResourceLocation("appliedenergistics2", builtInName), "normal");
        rendering.builtInModel(builtInName, new CraftingCubeModel(this.type));
        rendering.stateMapper(block -> this.mapState(block, defaultModel, builtInModelName));
        if (this.type == BlockCraftingUnit.CraftingUnitType.MONITOR) {
            rendering.tesr(new CraftingMonitorTESR());
        }
    }

    private Map<IBlockState, ModelResourceLocation> mapState(Block block, ModelResourceLocation defaultModel, ModelResourceLocation formedModel) {
        HashMap<IBlockState, ModelResourceLocation> result = new HashMap<IBlockState, ModelResourceLocation>();
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            if (((Boolean)state.func_177229_b((IProperty)BlockCraftingUnit.FORMED)).booleanValue()) {
                result.put(state, formedModel);
                continue;
            }
            result.put(state, defaultModel);
        }
        return result;
    }
}

