/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.world;

import elec332.core.main.ElecCore;
import elec332.core.util.NBTHelper;
import elec332.core.world.WorldHelper;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.Validate;

public final class DimensionCoordinate
implements INBTSerializable<NBTTagCompound> {
    private final BlockPos pos;
    private final int dim;
    private WeakReference<World> worldRef;

    public DimensionCoordinate(DimensionCoordinate dim) {
        this(dim.dim, dim.pos, dim.worldRef);
    }

    public DimensionCoordinate(World world, BlockPos pos) {
        this(WorldHelper.getDimID(world), pos, new WeakReference<World>(world));
    }

    public DimensionCoordinate(int dimension, BlockPos pos) {
        this(dimension, pos, null);
    }

    private DimensionCoordinate(int dimension, BlockPos pos, WeakReference<World> worldRef) {
        this.pos = (BlockPos)Validate.notNull((Object)pos, (String)"Cannot have a DimensionCoordinate with a null BlockPos!", (Object[])new Object[0]);
        this.dim = dimension;
        this.worldRef = worldRef;
    }

    @Nonnull
    public BlockPos getPos() {
        return this.pos;
    }

    public int getDimension() {
        return this.dim;
    }

    @Nullable
    public World getWorld() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            World world = ElecCore.proxy.getClientWorld();
            if (WorldHelper.getDimID(world) == this.dim) {
                return world;
            }
            return null;
        }
        if (this.worldRef == null || this.worldRef.get() == null) {
            this.worldRef = new WeakReference<WorldServer>(DimensionManager.getWorld((int)this.dim));
        }
        return (World)this.worldRef.get();
    }

    @Nullable
    public TileEntity getTileEntity() {
        return this.getTileEntity(this.getWorld());
    }

    @Nullable
    public TileEntity getTileEntity(World world) {
        if (this.loaded(world)) {
            return WorldHelper.getTileAt((IBlockAccess)world, this.pos);
        }
        return null;
    }

    @Nullable
    public IBlockState getBlockState() {
        return this.getBlockState(this.getWorld());
    }

    @Nullable
    public IBlockState getBlockState(World world) {
        if (this.loaded(world)) {
            return WorldHelper.getBlockState((IBlockAccess)world, this.pos);
        }
        return null;
    }

    public boolean isLoaded() {
        return this.loaded(this.getWorld());
    }

    private boolean loaded(World world) {
        return world != null && WorldHelper.chunkLoaded(world, this.pos);
    }

    public NBTTagCompound serializeNBT() {
        return new NBTHelper().addToTag(this.pos).addToTag(this.dim, "dim").serializeNBT();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        throw new UnsupportedOperationException();
    }

    public static DimensionCoordinate fromNBT(NBTTagCompound tag) {
        NBTHelper nbt = new NBTHelper(tag);
        return new DimensionCoordinate(nbt.getInteger("dim"), nbt.getPos());
    }

    public static DimensionCoordinate fromTileEntity(TileEntity tile) {
        return new DimensionCoordinate(tile.func_145831_w(), tile.func_174877_v());
    }

    public boolean equals(Object obj) {
        return obj instanceof DimensionCoordinate && ((DimensionCoordinate)obj).pos.equals((Object)this.pos) && ((DimensionCoordinate)obj).dim == this.dim;
    }

    public int hashCode() {
        return 31 * this.pos.hashCode() + this.dim;
    }

    public String toString() {
        return "[DimensionCoordinate: " + this.pos.toString() + " dim: " + this.dim + "]";
    }
}

