/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.mcabstractionlayer.impl;

import com.google.common.collect.Sets;
import elec332.core.world.IElecWorldEventListener;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public enum WorldEventListener implements IWorldEventListener
{
    INSTANCE;

    private static Set<IElecWorldEventListener> listeners;

    public static void unRegisterWorldEventListener(IElecWorldEventListener listener) {
        listeners.remove(listener);
    }

    public static void registerWorldEventListener(IElecWorldEventListener listener) {
        listeners.add(listener);
    }

    public void func_184376_a(World worldIn, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        for (IElecWorldEventListener l : listeners) {
            l.notifyBlockUpdate(worldIn, pos, oldState, newState, flags);
        }
    }

    public void func_174959_b(BlockPos pos) {
        for (IElecWorldEventListener l : listeners) {
            l.notifyLightSet(pos);
        }
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
        for (IElecWorldEventListener l : listeners) {
            l.markBlockRangeForRenderUpdate(x1, y1, z1, x2, y2, z2);
        }
    }

    public void func_184375_a(@Nullable EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
        for (IElecWorldEventListener l : listeners) {
            l.playSoundToAllNearExcept(player, soundIn, category, x, y, z, volume, pitch);
        }
    }

    public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
        for (IElecWorldEventListener l : listeners) {
            l.playRecord(soundIn, pos);
        }
    }

    public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        this.func_190570_a(particleID, ignoreRange, false, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters);
    }

    public void func_190570_a(int particleID, boolean ignoreRange, boolean minParticles, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        for (IElecWorldEventListener l : listeners) {
            l.spawnParticle(particleID, ignoreRange, minParticles, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters);
        }
    }

    public void func_72703_a(Entity entityIn) {
        for (IElecWorldEventListener l : listeners) {
            l.onEntityAdded(entityIn);
        }
    }

    public void func_72709_b(Entity entityIn) {
        for (IElecWorldEventListener l : listeners) {
            l.onEntityRemoved(entityIn);
        }
    }

    public void func_180440_a(int soundID, BlockPos pos, int data) {
        for (IElecWorldEventListener l : listeners) {
            l.broadcastSound(soundID, pos, data);
        }
    }

    public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
        for (IElecWorldEventListener l : listeners) {
            l.playEvent(player, type, blockPosIn, data);
        }
    }

    public void func_180441_b(int breakerId, BlockPos pos, int progress) {
        for (IElecWorldEventListener l : listeners) {
            l.sendBlockBreakProgress(breakerId, pos, progress);
        }
    }

    public static void register() {
    }

    static {
        listeners = Sets.newHashSet();
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent
            public void loadWorld(WorldEvent.Load event) {
                World world = event.getWorld();
                if (!world.field_72995_K) {
                    world.func_72848_b((IWorldEventListener)INSTANCE);
                    world.func_72954_a((IWorldEventListener)INSTANCE);
                }
            }
        });
    }
}

