/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.handler;

import elec332.core.main.ElecCore;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class TickHandler {
    private final Side mainSide;
    private final Queue<Runnable> unknownCallbacks = new ArrayDeque<Runnable>();
    private final Queue<Runnable> clientCallbacks = new ArrayDeque<Runnable>();
    private final Queue<Runnable> serverCallbacks = new ArrayDeque<Runnable>();
    private final Queue<Runnable> unknownTickables = new ArrayDeque<Runnable>();
    private final Queue<Runnable> clientTickables = new ArrayDeque<Runnable>();
    private final Queue<Runnable> serverTickables = new ArrayDeque<Runnable>();

    public TickHandler() {
        this.mainSide = FMLCommonHandler.instance().getSide();
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        this.processSingleTicks((TickEvent)event, this.serverCallbacks);
        this.processTickables((TickEvent)event, this.serverTickables);
        if (this.mainSide.isServer()) {
            this.processTickables((TickEvent)event, this.unknownTickables);
            this.processSingleTicks((TickEvent)event, this.unknownCallbacks);
        }
    }

    @SubscribeEvent
    public void onTickClient(TickEvent.ClientTickEvent event) {
        this.processSingleTicks((TickEvent)event, this.clientCallbacks);
        this.processTickables((TickEvent)event, this.clientTickables);
        if (this.mainSide.isClient()) {
            this.processSingleTicks((TickEvent)event, this.unknownCallbacks);
            this.processTickables((TickEvent)event, this.unknownTickables);
        }
    }

    @Deprecated
    public void registerCall(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        this.unknownCallbacks.add(runnable);
        ElecCore.logger.info("##############################################");
        ElecCore.logger.info("## Error, someone is using an unsafe method!##");
        ElecCore.logger.info("##############################################");
        ElecCore.logger.info("Source: " + runnable.getClass().toString());
    }

    public void registerCall(Runnable runnable, World world) {
        if (world == null) {
            this.registerCall(runnable);
            return;
        }
        if (!world.field_72995_K) {
            this.registerCallServer(runnable);
        } else {
            this.registerCallClient(runnable);
        }
    }

    public void registerCall(Runnable runnable, Side side) {
        if (side == null) {
            this.registerCall(runnable);
            return;
        }
        if (side.isServer()) {
            this.registerCallServer(runnable);
        } else if (side.isClient()) {
            this.registerCallClient(runnable);
        } else {
            throw new IllegalArgumentException("What am I supposed to do with side: " + side + "?");
        }
    }

    public void registerCallServer(Runnable runnable) {
        this.serverCallbacks.add(runnable);
    }

    public void registerCallClient(Runnable runnable) {
        this.clientCallbacks.add(runnable);
    }

    public void registerTickable(Runnable runnable, World world) {
        if (runnable == null) {
            return;
        }
        if (world == null) {
            this.unknownTickables.add(runnable);
            ElecCore.logger.info("##############################################");
            ElecCore.logger.info("## Error, someone is using an unsafe method!##");
            ElecCore.logger.info("##############################################");
            ElecCore.logger.info("Source: " + runnable.getClass().toString());
            return;
        }
        this.registerTickable(runnable, world.field_72995_K ? Side.CLIENT : Side.SERVER);
    }

    public void registerTickable(Runnable runnable, Side side) {
        if (runnable == null) {
            return;
        }
        if (side == null) {
            this.registerTickable(runnable, (World)null);
            return;
        }
        if (side.isServer()) {
            this.registerServerTickable(runnable);
        } else if (side.isClient()) {
            this.registerClientTickable(runnable);
        } else {
            throw new IllegalArgumentException("What am I supposed to do with side: " + side + "?");
        }
    }

    public void registerServerTickable(Runnable runnable) {
        this.serverTickables.add(runnable);
    }

    public void registerClientTickable(Runnable runnable) {
        this.clientTickables.add(runnable);
    }

    public void removeTickable(Runnable runnable) {
        this.serverTickables.remove(runnable);
        this.clientTickables.remove(runnable);
        this.unknownTickables.remove(runnable);
    }

    private void processSingleTicks(TickEvent event, Queue<Runnable> process) {
        if (event.phase == TickEvent.Phase.START && !process.isEmpty()) {
            Runnable runnable = process.poll();
            while (runnable != null) {
                runnable.run();
                runnable = process.poll();
            }
            process.clear();
        }
    }

    private void processTickables(TickEvent event, Queue<Runnable> process) {
        if (event.phase == TickEvent.Phase.START && !process.isEmpty()) {
            for (Runnable runnable : process) {
                runnable.run();
            }
        }
    }
}

