/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.entity.IBreathAttacker;
import twilightforest.entity.ai.EntityAITFBreathAttack;

public class EntityTFFireBeetle
extends EntityMob
implements IBreathAttacker {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("twilightforest", "entities/fire_beetle");
    private static final DataParameter<Boolean> BREATHING = EntityDataManager.func_187226_a(EntityTFFireBeetle.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final int BREATH_DURATION = 10;
    private static final int BREATH_DAMAGE = 2;

    public EntityTFFireBeetle(World world) {
        super(world);
        this.func_70105_a(1.1f, 0.75f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITFBreathAttack((EntityLiving)this, 1.0f, 5.0f, 30, 0.1f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BREATHING, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    public boolean isBreathing() {
        return (Boolean)this.field_70180_af.func_187225_a(BREATHING);
    }

    @Override
    public void setBreathing(boolean flag) {
        this.field_70180_af.func_187227_b(BREATHING, (Object)flag);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isBreathing()) {
            Vec3d look = this.func_70040_Z();
            double dist = 0.9;
            double px = this.field_70165_t + look.field_72450_a * dist;
            double py = this.field_70163_u + 0.25 + look.field_72448_b * dist;
            double pz = this.field_70161_v + look.field_72449_c * dist;
            for (int i = 0; i < 2; ++i) {
                double dx = look.field_72450_a;
                double dy = look.field_72448_b;
                double dz = look.field_72449_c;
                double spread = 5.0 + this.func_70681_au().nextDouble() * 2.5;
                double velocity = 0.15 + this.func_70681_au().nextDouble() * 0.15;
                dx += this.func_70681_au().nextGaussian() * (double)0.0075f * spread;
                dy += this.func_70681_au().nextGaussian() * (double)0.0075f * spread;
                dz += this.func_70681_au().nextGaussian() * (double)0.0075f * spread;
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity, new int[0]);
            }
            this.func_184185_a(SoundEvents.field_187557_bK, this.field_70146_Z.nextFloat() * 0.5f, this.field_70146_Z.nextFloat() * 0.5f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        if (this.isBreathing()) {
            return 0xF000F0;
        }
        return super.func_70070_b();
    }

    public int func_70646_bf() {
        return 500;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.6f;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public void doBreathAttack(Entity target) {
        if (!target.func_70045_F() && target.func_70097_a(DamageSource.field_76372_a, 2.0f)) {
            target.func_70015_d(10);
        }
    }
}

