/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.base.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import thaumcraft.api.crafting.IInfusionStabiliser;
import twilightforest.TwilightForestMod;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFBlocks;
import twilightforest.client.ModelRegisterCallbackCTM;
import twilightforest.item.TFItems;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Optional.Interface(modid="thaumcraft", iface="thaumcraft.api.crafting.IInfusionStabiliser")
public class BlockTFTrophyPedestal
extends Block
implements ModelRegisterCallbackCTM,
IInfusionStabiliser {
    public static final IProperty<EnumFacing> FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final IProperty<Boolean> LATENT = PropertyBool.func_177716_a((String)"latent");
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);

    public BlockTFTrophyPedestal() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(2000.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(TFItems.creativeTab);
        this.func_180632_j(this.func_176223_P().func_177226_a(LATENT, (Comparable)Boolean.valueOf(true)).func_177226_a(FACING, (Comparable)EnumFacing.NORTH));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LATENT});
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b(FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b(LATENT)).booleanValue()) {
            meta |= 4;
        }
        return meta;
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        IBlockState ret = this.func_176223_P();
        ret = ret.func_177226_a(FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
        if ((meta & 4) > 0) {
            ret = ret.func_177226_a(LATENT, (Comparable)Boolean.valueOf(true));
        }
        return ret;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b(LATENT)).booleanValue() && this.isTrophyOnTop(world, pos)) {
            if (world.func_82736_K().func_82766_b("tfEnforcedProgression")) {
                if (this.areNearbyPlayersEligible(world, pos)) {
                    this.doPedestalEffect(world, pos, state);
                }
                this.warnIneligiblePlayers(world, pos);
            } else {
                this.doPedestalEffect(world, pos, state);
            }
            this.rewardNearbyPlayers(world, pos);
        }
    }

    private boolean isTrophyOnTop(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a()).func_177230_c() == TFBlocks.trophy;
    }

    private void warnIneligiblePlayers(World world, BlockPos pos) {
        for (EntityPlayer player : world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(pos).func_72314_b(16.0, 16.0, 16.0))) {
            if (this.isPlayerEligible(player)) continue;
            player.func_145747_a((ITextComponent)new TextComponentTranslation("twilightforest.trophy_pedestal.ineligible", new Object[0]));
        }
    }

    private boolean areNearbyPlayersEligible(World world, BlockPos pos) {
        for (EntityPlayer player : world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(pos).func_72314_b(16.0, 16.0, 16.0))) {
            if (!this.isPlayerEligible(player)) continue;
            return true;
        }
        return false;
    }

    private boolean isPlayerEligible(EntityPlayer player) {
        return TwilightForestMod.proxy.doesPlayerHaveAdvancement(player, new ResourceLocation("twilightforest", "progress_lich"));
    }

    private void doPedestalEffect(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177226_a(LATENT, (Comparable)Boolean.valueOf(false)));
        this.removeNearbyShields(world, pos);
        world.func_184133_a(null, pos, SoundEvents.field_187945_hs, SoundCategory.BLOCKS, 4.0f, 0.1f);
    }

    private void rewardNearbyPlayers(World world, BlockPos pos) {
        for (EntityPlayerMP player : world.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(pos).func_72314_b(16.0, 16.0, 16.0))) {
            TFAdvancements.PLACED_TROPHY_ON_PEDESTAL.trigger(player);
        }
    }

    private void removeNearbyShields(World world, BlockPos pos) {
        for (int sx = -5; sx <= 5; ++sx) {
            for (int sy = -5; sy <= 5; ++sy) {
                for (int sz = -5; sz <= 5; ++sz) {
                    if (world.func_180495_p(pos.func_177982_a(sx, sy, sz)).func_177230_c() != TFBlocks.stronghold_shield) continue;
                    world.func_175655_b(pos.func_177982_a(sx, sy, sz), false);
                }
            }
        }
    }

    @Deprecated
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Deprecated
    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        return (Boolean)state.func_177229_b(LATENT) != false ? -1.0f : super.func_180647_a(state, player, world, pos);
    }

    protected boolean func_149700_E() {
        return false;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public boolean canStabaliseInfusion(World world, BlockPos blockPos) {
        return true;
    }

    @Override
    public void registerItemModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)(Loader.isModLoaded((String)"ctm") ? new ModelResourceLocation(this.getRegistryName() + "_ctm", "latent=false") : new ModelResourceLocation(this.getRegistryName(), "latent=false")));
    }

    @Override
    public IProperty<?>[] getIgnoredProperties() {
        return new IProperty[]{FACING};
    }
}

