/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib3.multiblock.api.structure;

import com.valkyrieofnight.vlib3.multiblock.api.structure.IBlockOffset;
import com.valkyrieofnight.vlib3.multiblock.api.structure.IMBComponent;
import java.util.List;
import java.util.Map;
import net.minecraft.util.EnumFacing;

public interface IMBStructure {
    public boolean isValidDirection(EnumFacing var1);

    public List<EnumFacing> getValidDirections();

    public List<IBlockOffset> getComponentLayout(IMBComponent var1);

    public Map<IMBComponent, List<IBlockOffset>> getLayout();

    public List<IMBComponent> getComponents();

    public void addComponent(IMBComponent var1, int var2, int var3, int var4);

    default public void addComponentParallelX(IMBComponent comp, int xOffset, int yOffset, int zOffset) {
        if (xOffset == 0) {
            this.addComponent(comp, xOffset, yOffset, zOffset);
        } else {
            this.addComponent(comp, xOffset, yOffset, zOffset);
            this.addComponent(comp, -xOffset, yOffset, zOffset);
        }
    }

    default public void addComponentParallelY(IMBComponent comp, int xOffset, int yOffset, int zOffset) {
        if (yOffset == 0) {
            this.addComponent(comp, xOffset, yOffset, zOffset);
        } else {
            this.addComponent(comp, xOffset, yOffset, zOffset);
            this.addComponent(comp, xOffset, -yOffset, zOffset);
        }
    }

    default public void addComponentParallelZ(IMBComponent comp, int xOffset, int yOffset, int zOffset) {
        if (xOffset == 0) {
            this.addComponent(comp, xOffset, yOffset, zOffset);
        } else {
            this.addComponent(comp, xOffset, yOffset, zOffset);
            this.addComponent(comp, xOffset, yOffset, -zOffset);
        }
    }

    default public void addComponentSymmetricalXZ(IMBComponent comp, int xOffset, int yOffset, int zOffset) {
        if (xOffset == 0 && zOffset == 0) {
            if (yOffset == 0) {
                return;
            }
            this.addComponent(comp, xOffset, yOffset, zOffset);
        } else if (Math.abs(xOffset) == Math.abs(zOffset)) {
            this.addComponent(comp, xOffset, yOffset, zOffset);
            this.addComponent(comp, -xOffset, yOffset, zOffset);
            this.addComponent(comp, xOffset, yOffset, -zOffset);
            this.addComponent(comp, -xOffset, yOffset, -zOffset);
        } else if (xOffset == 0 || zOffset == 0) {
            int off = Math.max(xOffset, zOffset);
            this.addComponent(comp, off, yOffset, 0);
            this.addComponent(comp, -off, yOffset, 0);
            this.addComponent(comp, 0, yOffset, off);
            this.addComponent(comp, 0, yOffset, -off);
        } else {
            this.addComponent(comp, xOffset, yOffset, zOffset);
            this.addComponent(comp, -xOffset, yOffset, zOffset);
            this.addComponent(comp, xOffset, yOffset, -zOffset);
            this.addComponent(comp, -xOffset, yOffset, -zOffset);
            this.addComponent(comp, zOffset, yOffset, xOffset);
            this.addComponent(comp, -zOffset, yOffset, xOffset);
            this.addComponent(comp, zOffset, yOffset, -xOffset);
            this.addComponent(comp, -zOffset, yOffset, -xOffset);
        }
    }
}

