/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.util;

import com.google.gson.JsonObject;
import com.valkyrieofnight.vlib3.core.util.ClassUtil;
import io.netty.util.internal.StringUtil;
import java.util.function.BooleanSupplier;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.JsonContext;

public class ConditionFactoryUtil {
    public static IConditionFactory getConditionFactoryOrGenericTrue(String address) {
        if (!StringUtil.isNullOrEmpty((String)address)) {
            IConditionFactory cf = ClassUtil.getClassInstance(address, IConditionFactory.class);
            return cf;
        }
        return new GenericTrueFactory();
    }

    public static IConditionFactory getConditionFactoryOrGenericFalse(String address) {
        if (!StringUtil.isNullOrEmpty((String)address)) {
            IConditionFactory cf = ClassUtil.getClassInstance(address, IConditionFactory.class);
            return cf;
        }
        return new GenericFalseFactory();
    }

    public static class GenericFalseFactory
    implements IConditionFactory {
        public BooleanSupplier parse(JsonContext context, JsonObject json) {
            return new BooleanSupplier(){

                @Override
                public boolean getAsBoolean() {
                    return false;
                }
            };
        }
    }

    public static class GenericTrueFactory
    implements IConditionFactory {
        public BooleanSupplier parse(JsonContext context, JsonObject json) {
            return new BooleanSupplier(){

                @Override
                public boolean getAsBoolean() {
                    return true;
                }
            };
        }
    }
}

