/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.tile.energy;

import com.valkyrieofnight.vlib.lib.tile.tickable.VLTileTickable;
import com.valkyrieofnight.vlib.lib.tilemodule.energyu.ITileUEProducer;
import com.valkyrieofnight.vlib.lib.tilemodule.energyu.TileModuleUEnergy;
import com.valkyrieofnight.vlib.lib.tilemodule.energyu.storage.UEnergyProducer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;

public abstract class VLTileEnergyProducer
extends VLTileTickable
implements ITileUEProducer {
    protected boolean ic2EU = false;
    protected boolean bcMJ = false;
    protected UEnergyProducer eBuffer;

    public VLTileEnergyProducer(int capacity) {
        this(capacity, capacity);
    }

    public VLTileEnergyProducer(int capacity, int maxExtract) {
        this.eBuffer = new UEnergyProducer(capacity, maxExtract);
        this.addModule(new TileModuleUEnergy(this));
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return this.canEnergyConnect(facing);
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && (facing == null || this.canEnergyConnect(facing))) {
            return (T)this.eBuffer;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound saveTileData(NBTTagCompound nbt, boolean toItem) {
        super.saveTileData(nbt, toItem);
        this.eBuffer.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public void loadTileData(NBTTagCompound nbt, boolean fromItem) {
        super.loadTileData(nbt, fromItem);
        this.eBuffer.readFromNBT(nbt);
    }

    public UEnergyProducer getEBuffer() {
        return this.eBuffer;
    }

    protected abstract boolean canEnergyConnect(EnumFacing var1);

    @Optional.Method(modid="valkyriecompat")
    public boolean emitsIc2EnergyTo(EnumFacing side) {
        return !this.ic2EU ? false : this.canEnergyConnect(side);
    }

    @Optional.Method(modid="valkyriecompat")
    public double getIc2OfferedEnergy() {
        return this.eBuffer.getIc2OfferedEnergy();
    }

    @Optional.Method(modid="valkyriecompat")
    public void drawIc2Energy(double amount) {
        this.eBuffer.drawIc2Energy(amount);
    }

    @Optional.Method(modid="valkyriecompat")
    public int getIc2Tier() {
        return 1;
    }
}

