/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.sys.tile.tocker;

import com.valkyrieofnight.vlib.lib.sys.io.nbt.INBTHandler;
import net.minecraft.nbt.NBTTagCompound;

public class TockTracker
implements INBTHandler<TockTracker> {
    private int tocksTotal = 0;
    private int tocksComplete = 0;

    public void resetTracker(int tockTotal) {
        this.tocksTotal = tockTotal + 1;
        this.tocksComplete = 0;
    }

    public void startTracker() {
        if (this.tocksComplete <= 0) {
            this.tock();
        }
    }

    public boolean hasStarted() {
        return this.tocksComplete >= 1 && !this.isComplete();
    }

    public boolean isComplete() {
        return this.tocksComplete >= this.tocksTotal;
    }

    public void tock() {
        ++this.tocksComplete;
    }

    public int tock(int tockAmount) {
        int rem = this.getTocksRemaining();
        int use = Math.min(rem, tockAmount);
        this.tocksComplete += use;
        return use;
    }

    @Override
    public TockTracker readFromNBT(NBTTagCompound nbt) {
        this.tocksTotal = nbt.func_74762_e("tocks_total");
        this.tocksComplete = nbt.func_74762_e("tocks_complete");
        return this;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("tocks_total", this.tocksTotal);
        nbt.func_74768_a("tocks_complete", this.tocksComplete);
        return nbt;
    }

    public int getValidTocks(int tocks) {
        return Math.min(tocks, this.getTocksRemaining());
    }

    public int getTocksRemaining() {
        return this.tocksTotal - this.tocksComplete;
    }

    public int getTocksTotal() {
        return this.tocksTotal - 1;
    }

    public int getTocksComplete() {
        if (this.tocksComplete == 0) {
            return 0;
        }
        return this.tocksComplete - 1;
    }
}

